/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.bag.Group;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.client.EditButton;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.KeyboardHandler;
import hardcorequesting.common.forge.client.interfaces.GuiBase;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.LargeButton;
import hardcorequesting.common.forge.client.interfaces.RenderRotation;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.TextBoxGroup;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuCommandEditor;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuDeath;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuTeam;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.client.sounds.SoundHandler;
import hardcorequesting.common.forge.config.HQMConfig;
import hardcorequesting.common.forge.death.DeathStatsManager;
import hardcorequesting.common.forge.items.ModItems;
import hardcorequesting.common.forge.network.NetworkManager;
import hardcorequesting.common.forge.network.message.CloseBookMessage;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestSet;
import hardcorequesting.common.forge.quests.QuestingData;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.reputation.Reputation;
import hardcorequesting.common.forge.reputation.ReputationBar;
import hardcorequesting.common.forge.reputation.ReputationManager;
import hardcorequesting.common.forge.reputation.ReputationMarker;
import hardcorequesting.common.forge.team.PlayerEntry;
import hardcorequesting.common.forge.team.Team;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.OPBookHelper;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiQuestBook
extends GuiBase {
    public static final int PAGE_WIDTH = 170;
    public static final int VISIBLE_REPUTATION_TIERS = 9;
    public static final int VISIBLE_REPUTATIONS = 10;
    public static final int VISIBLE_DISPLAY_REPUTATIONS = 4;
    public static final int LIST_X = 25;
    public static final int LIST_Y = 20;
    public static final int TEXT_HEIGHT = 9;
    public static final int TEXT_SPACING = 20;
    public static final int DESCRIPTION_X = 180;
    public static final int DESCRIPTION_Y = 20;
    public static final int VISIBLE_DESCRIPTION_LINES = 7;
    public static final int VISIBLE_MAIN_DESCRIPTION_LINES = 21;
    public static final int VISIBLE_SETS = 7;
    public static final int TIERS_X = 180;
    public static final int TIERS_Y = 20;
    public static final int TIERS_SPACING = 25;
    public static final int TIERS_SECOND_LINE_X = -5;
    public static final int TIERS_SECOND_LINE_Y = 12;
    public static final int WEIGHT_SPACING = 25;
    public static final int VISIBLE_TIERS = 8;
    public static final int GROUPS_X = 20;
    public static final int GROUPS_Y = 20;
    public static final int GROUPS_SPACING = 25;
    public static final int GROUPS_SECOND_LINE_X = 5;
    public static final int GROUPS_SECOND_LINE_Y = 12;
    public static final int VISIBLE_GROUPS = 8;
    public static final int GROUP_ITEMS_X = 20;
    public static final int GROUP_ITEMS_Y = 40;
    public static final int GROUP_ITEMS_SPACING = 20;
    public static final int ITEMS_PER_LINE = 7;
    private static final String FRONT_KEY = "hqm_front_texture";
    private static final int TEXTURE_WIDTH = 340;
    private static final int TEXTURE_HEIGHT = 234;
    private static final int INFO_RIGHT_X = 180;
    private static final int INFO_LIVES_Y = 20;
    private static final int INFO_DEATHS_Y = 55;
    private static final int INFO_TEAM_Y = 95;
    private static final int INFO_LEFT_X = 20;
    private static final int INFO_QUESTS_Y = 20;
    private static final int INFO_REPUTATION_Y = 110;
    private static final int INFO_HEARTS_X = 5;
    private static final int INFO_HEARTS_Y = 12;
    private static final int INFO_HEARTS_SPACING = 18;
    private static final int TEAM_TEXT_Y = 12;
    private static final int TEAM_CLICK_TEXT_Y = 30;
    private static final int DEATH_TEXT_Y = 0;
    private static final int DEATH_CLICK_TEXT_Y = 10;
    private static final int QUEST_CLICK_TEXT_Y = 67;
    private static final int INFO_REPUTATION_OFFSET_X = 5;
    private static final int INFO_REPUTATION_OFFSET_Y = 12;
    private static final int BACK_ARROW_X = 9;
    private static final int BACK_ARROW_Y = 219;
    private static final int BACK_ARROW_SRC_X = 0;
    private static final int BACK_ARROW_SRC_Y = 113;
    private static final int BACK_ARROW_WIDTH = 15;
    private static final int BACK_ARROW_HEIGHT = 10;
    private static final int MENU_ARROW_X = 161;
    private static final int MENU_ARROW_Y = 217;
    private static final int MENU_ARROW_SRC_X = 0;
    private static final int MENU_ARROW_SRC_Y = 104;
    private static final int MENU_ARROW_WIDTH = 14;
    private static final int MENU_ARROW_HEIGHT = 9;
    private static final ResourceLocation BG_TEXTURE = ResourceHelper.getResource("book");
    public static QuestSet selectedSet;
    public static Quest selectedQuest;
    public static Group selectedGroup;
    public static Reputation selectedReputation;
    private static boolean isSetOpened;
    private static boolean isMainPageOpen;
    private static boolean isMenuPageOpen;
    private static boolean isBagPage;
    private static boolean isReputationPage;
    private static ItemStack selectedStack;
    public final boolean isOpBook;
    private final PlayerEntity player;
    public ScrollBar reputationDisplayScroll;
    public ScrollBar reputationScroll;
    public ScrollBar reputationTierScroll;
    public Group modifyingGroup;
    public QuestSet modifyingQuestSet;
    public Quest modifyingQuest;
    public ReputationBar modifyingBar;
    private ScrollBar setScroll;
    private ScrollBar descriptionScroll;
    private ScrollBar mainDescriptionScroll;
    private ScrollBar groupScroll;
    private ScrollBar tierScroll;
    private List<ScrollBar> scrollBars;
    private TextBoxGroup.TextBox textBoxGroupAmount;
    private TextBoxGroup textBoxes;
    private int tick;
    private GuiEditMenu editMenu;
    private LargeButton saveButton;
    private List<LargeButton> buttons = new ArrayList<LargeButton>();
    private EditMode currentMode = EditMode.NORMAL;
    private EditButton[] groupButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.ITEM, EditMode.DELETE);
    private EditButton[] bagButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.TIER, EditMode.DELETE);
    private EditButton[] reputationButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.REPUTATION_VALUE, EditMode.DELETE);
    private EditButton[] mainButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.RENAME);
    private EditButton[] menuButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.BAG, EditMode.REPUTATION);
    private EditButton[] overviewButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.CREATE, EditMode.RENAME, EditMode.SWAP_SELECT, EditMode.DELETE);
    private EditButton[] setButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.MOVE, EditMode.CREATE, EditMode.REQUIREMENT, EditMode.SIZE, EditMode.ITEM, EditMode.REPEATABLE, EditMode.TRIGGER, EditMode.REQUIRED_PARENTS, EditMode.QUEST_SELECTION, EditMode.QUEST_OPTION, EditMode.SWAP, EditMode.REP_BAR_CREATE, EditMode.REP_BAR_CHANGE, EditMode.DELETE);
    private EditButton[] questButtons = EditButton.createButtons(this, EditMode.NORMAL, EditMode.RENAME, EditMode.TASK, EditMode.ITEM, EditMode.LOCATION, EditMode.MOB, EditMode.REPUTATION_TASK, EditMode.REPUTATION_REWARD, EditMode.COMMAND_CREATE, EditMode.COMMAND_CHANGE, EditMode.DELETE);

    private GuiQuestBook(PlayerEntity player, boolean isOpBook) {
        super(NarratorChatListener.field_216868_a);
        this.scrollBars = new ArrayList<ScrollBar>();
        this.descriptionScroll = new ScrollBar(312, 18, 64, 249, 102, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && !isBagPage && !isMainPageOpen && selectedSet != null && !isSetOpened && selectedSet.getDescription(gui).size() > 7;
            }
        };
        this.scrollBars.add(this.descriptionScroll);
        this.setScroll = new ScrollBar(160, 18, 186, 171, 69, 25){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && !isBagPage && !isMainPageOpen && (selectedSet == null || !isSetOpened) && Quest.getQuestSets().size() > 7;
            }
        };
        this.scrollBars.add(this.setScroll);
        this.mainDescriptionScroll = new ScrollBar(312, 18, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && !isBagPage && isMainPageOpen && Quest.getMainDescription(gui).size() > 21;
            }
        };
        this.scrollBars.add(this.mainDescriptionScroll);
        this.groupScroll = new ScrollBar(160, 18, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && isBagPage && selectedGroup == null && Group.getGroups().size() > 8;
            }
        };
        this.scrollBars.add(this.groupScroll);
        this.tierScroll = new ScrollBar(312, 18, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return !isReputationPage && isBagPage && selectedGroup == null && GroupTierManager.getInstance().getTiers().size() > 8;
            }
        };
        this.scrollBars.add(this.tierScroll);
        this.reputationTierScroll = new ScrollBar(312, 23, 186, 171, 69, 180){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isReputationPage && !isBagPage && !isMainPageOpen && selectedReputation != null && selectedReputation.getMarkerCount() > 9;
            }
        };
        this.scrollBars.add(this.reputationTierScroll);
        this.reputationScroll = new ScrollBar(160, 23, 186, 171, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isReputationPage && !isBagPage && (GuiQuestBook.this.getCurrentMode() != EditMode.CREATE || selectedReputation == null) && ReputationManager.getInstance().size() > 10;
            }
        };
        this.scrollBars.add(this.reputationScroll);
        this.reputationDisplayScroll = new ScrollBar(160, 125, 87, 164, 69, 20){

            @Override
            public boolean isVisible(GuiBase gui) {
                return isMenuPageOpen && !isMainPageOpen && ReputationManager.getInstance().size() > 4;
            }
        };
        this.scrollBars.add(this.reputationDisplayScroll);
        this.textBoxes = new TextBoxGroup();
        this.textBoxGroupAmount = new TextBoxGroup.TextBox(this, "0", 180, 30, false){

            @Override
            protected boolean isCharacterValid(char c, String rest) {
                return rest.length() < 3 && Character.isDigit(c);
            }

            @Override
            public void textChanged(GuiBase gui) {
                try {
                    int number = this.getText().equals("") ? 1 : Integer.parseInt(this.getText());
                    if (selectedGroup != null) {
                        selectedGroup.setLimit(number);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.textBoxes.add(this.textBoxGroupAmount);
        this.saveButton = new LargeButton("hqm.questBook.saveAll", 360, 10){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return Quest.canQuestsBeEdited() && SaveHelper.isLarge();
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GuiQuestBook.this.save();
            }
        };
        this.buttons.add(this.saveButton);
        this.buttons.add(new LargeButton("hqm.questBook.open", 245, 190){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && selectedSet != null && !isBagPage && !isSetOpened && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                isSetOpened = true;
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createSet", 185, 50){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && Quest.canQuestsBeEdited() && GuiQuestBook.this.currentMode == EditMode.CREATE && !isBagPage && !isSetOpened && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                int i = 0;
                for (QuestSet set : Quest.getQuestSets()) {
                    if (!set.getName().startsWith("Unnamed set")) continue;
                    ++i;
                }
                Quest.getQuestSets().add(new QuestSet("Unnamed set" + (i == 0 ? "" : Integer.valueOf(i)), "No description"));
                SaveHelper.add(EditType.SET_CREATE);
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createGroup", 100, 175){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedGroup == null && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                Group.add(new Group(null));
                SaveHelper.add(EditType.GROUP_CREATE);
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createTier", 100, 200){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedGroup == null && !isMainPageOpen && !isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                GroupTierManager.getInstance().getTiers().add(new GroupTier("New Tier", GuiColor.BLACK, 0, 0, 0, 0, 0));
                SaveHelper.add(EditType.TIER_CREATE);
            }
        });
        this.buttons.add(new LargeButton("Reset", 90, 190){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return Screen.func_231172_r_() && Screen.func_231173_s_();
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && !isBagPage && !isMainPageOpen && GuiQuestBook.this.isOpBook && isMenuPageOpen && !isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                OPBookHelper.reset(player);
            }
        });
        this.buttons.add(new LargeButton("Create New", 180, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && !isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedReputation == null && !isMainPageOpen && !isMenuPageOpen && isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                ReputationManager.getInstance().addReputation(new Reputation("Unnamed", "Neutral"));
                SaveHelper.add(EditType.REPUTATION_ADD);
            }
        });
        this.buttons.add(new LargeButton("hqm.questBook.createTier", 20, 20){

            @Override
            public boolean isEnabled(GuiBase gui, PlayerEntity player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, PlayerEntity player) {
                return GuiQuestBook.this.editMenu == null && !isBagPage && GuiQuestBook.this.currentMode == EditMode.CREATE && selectedReputation != null && !isMainPageOpen && !isMenuPageOpen && isReputationPage;
            }

            @Override
            public void onClick(GuiBase gui, PlayerEntity player) {
                selectedReputation.add(new ReputationMarker("Unnamed", 0, false));
                SaveHelper.add(EditType.REPUTATION_MARKER_CREATE);
            }
        });
        this.player = player;
        this.isOpBook = isOpBook;
        if (Quest.canQuestsBeEdited()) {
            Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        }
        QuestingData data = QuestingDataManager.getInstance().getQuestingData(player);
        if (!data.playedLore && SoundHandler.hasLoreMusic()) {
            SoundHandler.triggerFirstLore();
            data.playedLore = true;
        }
    }

    public static void resetBookPosition() {
        selectedSet = null;
        isSetOpened = false;
        selectedQuest = null;
        isMainPageOpen = true;
        isBagPage = false;
        isReputationPage = false;
        isMenuPageOpen = true;
        selectedGroup = null;
        selectedReputation = null;
    }

    public static Group getSelectedGroup() {
        return selectedGroup;
    }

    public static void displayGui(PlayerEntity player, boolean isOpBook) {
        if (player != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!(mc.field_71462_r instanceof GuiQuestBook)) {
                mc.func_147108_a((Screen)new GuiQuestBook(player, isOpBook));
            }
        }
    }

    public static void setSelectedStack(ItemStack stack) {
        selectedStack = stack;
    }

    public TextBoxGroup.TextBox getTextBoxGroupAmount() {
        return this.textBoxGroupAmount;
    }

    public int getTick() {
        return this.tick;
    }

    @Override
    public void setEditMenu(GuiEditMenu editMenu) {
        this.editMenu = editMenu;
    }

    public void func_230430_a_(MatrixStack matrices, int x0, int y0, float f) {
        selectedStack = null;
        this.left = (this.field_230708_k_ - 340) / 2;
        this.top = (this.field_230709_l_ - 234) / 2;
        int x = x0 - this.left;
        int y = y0 - this.top;
        this.applyColor(-1);
        ResourceHelper.bindResource(BG_TEXTURE);
        this.drawRect(0, 0, 0, 0, 170, 234);
        this.drawRect(170, 0, 0, 0, 170, 234, RenderRotation.FLIP_HORIZONTAL);
        if (Quest.canQuestsBeEdited()) {
            this.applyColor(-1);
            ResourceHelper.bindResource(MAP_TEXTURE);
            SaveHelper.render(matrices, this, x, y);
        }
        for (LargeButton button2 : this.buttons) {
            button2.draw(matrices, this, this.player, x, y);
        }
        this.applyColor(-1);
        ResourceHelper.bindResource(MAP_TEXTURE);
        if (this.shouldDisplayControlArrow(false)) {
            this.drawRect(9, 219, 0 + (this.inArrowBounds(false, x, y) ? 15 : 0), 113, 15, 10);
        }
        if (this.shouldDisplayControlArrow(true)) {
            this.drawRect(161, 217, 0 + (this.inArrowBounds(true, x, y) ? 14 : 0), 104, 14, 9);
        }
        if (this.editMenu == null) {
            if (Quest.canQuestsBeEdited()) {
                for (EditButton editButton : this.getButtons()) {
                    editButton.draw(x, y);
                }
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.draw(this);
            }
            if (isMainPageOpen) {
                this.drawMainPage(matrices);
            } else if (isMenuPageOpen) {
                this.drawMenuPage(matrices, x, y);
            } else if (isBagPage) {
                this.drawBagPage(matrices, x, y);
            } else if (isReputationPage) {
                Reputation.drawEditPage(matrices, this, x, y);
            } else if (selectedSet == null || !isSetOpened) {
                QuestSet.drawOverview(matrices, this, this.setScroll, this.descriptionScroll, x, y);
            } else if (selectedQuest == null) {
                selectedSet.draw(matrices, this, x0, y0, x, y);
            } else {
                selectedQuest.drawMenu(matrices, this, this.player, x, y);
            }
            if (Quest.canQuestsBeEdited()) {
                for (EditButton editButton : this.getButtons()) {
                    editButton.drawInfo(matrices, x, y);
                }
            }
            if (this.currentMode == EditMode.DELETE) {
                matrices.func_227860_a_();
                matrices.func_227861_a_(0.0, 0.0, 200.0);
                this.drawCenteredString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.warning", new Object[0]), 0, 0, 2.0f, 340, 234, 0xFF0000);
                IFormattableTextComponent iFormattableTextComponent = Translator.translatable("hqm.questBook.deleteOnClick", new Object[0]);
                this.field_230712_o_.getClass();
                this.drawCenteredString(matrices, (ITextProperties)iFormattableTextComponent, 0, 9 * 2, 1.0f, 340, 234, 0xFF0000);
                this.applyColor(-1);
                ResourceHelper.bindResource(MAP_TEXTURE);
                matrices.func_227865_b_();
            }
        } else {
            this.editMenu.draw(matrices, this, x, y);
            this.editMenu.renderTooltip(matrices, this, x, y);
        }
        if (this.currentMode != EditMode.MOVE) {
            this.buttons.forEach(button -> button.renderTooltip(matrices, this, this.player, x, y));
        }
        if (this.shouldDisplayAndIsInArrowBounds(false, x, y)) {
            this.renderTooltip(matrices, ITextProperties.func_240655_a_((ITextProperties[])new ITextProperties[]{Translator.translatable("hqm.questBook.goBack", new Object[0]), Translator.plain("\n"), Translator.translatable("hqm.questBook.rightClick", GuiColor.GRAY, new Object[0])}), x + this.left, y + this.top);
        } else if (this.shouldDisplayAndIsInArrowBounds(true, x, y)) {
            this.func_238652_a_(matrices, (ITextComponent)Translator.translatable("hqm.questBook.backToMenu", new Object[0]), x + this.left, y + this.top);
        }
    }

    public void openSet() {
        isSetOpened = true;
    }

    public boolean func_231042_a_(char c, int k) {
        if (super.func_231042_a_(c, k)) {
            return true;
        }
        if (this.editMenu != null) {
            this.editMenu.onKeyStroke(this, c, -1);
        } else if (isBagPage && selectedGroup != null) {
            this.textBoxes.onKeyStroke(this, c, -1);
        } else {
            return false;
        }
        return true;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (super.func_231046_a_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.editMenu != null) {
            this.editMenu.onKeyStroke(this, '\u0000', keyCode);
        } else if (isBagPage && selectedGroup != null) {
            this.textBoxes.onKeyStroke(this, '\u0000', keyCode);
        } else if (KeyboardHandler.pressedHotkey(this, keyCode, this.getButtons())) {
            this.onButtonClicked();
        }
        return false;
    }

    public boolean func_231044_a_(double x0, double y0, int button) {
        if (super.func_231044_a_(x0, y0, button)) {
            return true;
        }
        int x = (int)(x0 - (double)this.left);
        int y = (int)(y0 - (double)this.top);
        if (this.shouldDisplayAndIsInArrowBounds(false, x, y)) {
            button = 1;
            if (this.editMenu != null) {
                this.editMenu.save(this);
                this.editMenu.close(this);
                return true;
            }
        } else if (this.shouldDisplayAndIsInArrowBounds(true, x, y)) {
            isMenuPageOpen = true;
            if (this.editMenu != null) {
                this.editMenu.save(this);
                this.editMenu.close(this);
                this.editMenu = null;
            }
            isBagPage = false;
            isReputationPage = false;
            return true;
        }
        boolean buttonClicked = false;
        for (LargeButton largeButton : this.buttons) {
            if (!largeButton.isVisible(this, this.player) || !largeButton.isEnabled(this, this.player) || !largeButton.inButtonBounds(this, x, y)) continue;
            largeButton.onClick(this, this.player);
            buttonClicked = true;
            break;
        }
        if (Quest.canQuestsBeEdited()) {
            SaveHelper.onClick(this, x, y);
        }
        if (buttonClicked) {
            return true;
        }
        if (this.editMenu == null) {
            if (Quest.canQuestsBeEdited()) {
                for (EditButton editButton : this.getButtons()) {
                    if (!editButton.onClick(x, y)) continue;
                    this.onButtonClicked();
                    break;
                }
            }
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onClick(this, x, y);
            }
            if (isMainPageOpen) {
                this.mainPageMouseClicked(x, y);
            } else if (isMenuPageOpen) {
                this.menuPageMouseClicked(button, x, y);
            } else if (isBagPage) {
                this.bagPageMouseClicked(button, x, y);
            } else if (isReputationPage) {
                if (button == 1) {
                    isMenuPageOpen = true;
                    isReputationPage = false;
                } else {
                    Reputation.onClick(this, x, y, this.player);
                }
            } else if (selectedSet == null || !isSetOpened) {
                if (button == 1) {
                    isMenuPageOpen = true;
                    return true;
                }
                QuestSet.mouseClickedOverview(this, this.setScroll, x, y);
            } else if (selectedQuest == null) {
                if (button == 1) {
                    isSetOpened = false;
                } else {
                    selectedSet.mouseClicked(this, x, y);
                }
            } else {
                selectedQuest.onClick(this, this.player, x, y, button);
            }
        } else {
            this.editMenu.onClick(this, x, y, button);
        }
        return true;
    }

    public boolean func_231048_c_(double x0, double y0, int button) {
        if (super.func_231048_c_(x0, y0, button)) {
            return true;
        }
        int x = (int)(x0 - (double)this.left);
        int y = (int)(y0 - (double)this.top);
        this.updatePosition(x, y);
        if (this.currentMode == EditMode.MOVE) {
            this.modifyingQuest = null;
            this.modifyingBar = null;
        }
        if (this.editMenu != null) {
            this.editMenu.onRelease(this, x, y);
        } else if (selectedQuest != null) {
            selectedQuest.onRelease(this, this.player, x, y, button);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onRelease(this, x, y);
            }
        }
        return true;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY)) {
            return true;
        }
        int x = (int)(mouseX - (double)this.left);
        int y = (int)(mouseY - (double)this.top);
        this.updatePosition(x, y);
        if (this.editMenu != null) {
            this.editMenu.onDrag(this, x, y);
        } else if (selectedQuest != null) {
            selectedQuest.onDrag(this, this.player, x, y, button);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onDrag(this, x, y);
            }
        }
        return true;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        double x = mouseX - (double)this.left;
        double y = mouseY - (double)this.top;
        if (this.editMenu != null) {
            this.editMenu.onScroll(this, x, y, scroll);
        } else if (selectedQuest != null) {
            selectedQuest.onScroll(this, x, y, scroll);
        } else {
            for (ScrollBar scrollBar : this.scrollBars) {
                scrollBar.onScroll(this, x, y, scroll);
            }
        }
        return true;
    }

    public void func_231023_e_() {
        ++this.tick;
        super.func_231023_e_();
    }

    public void func_231164_f_() {
        NetworkManager.sendToServer(new CloseBookMessage(this.player.func_110124_au()));
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        SoundHandler.stopLoreMusic();
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void drawBagPage(MatrixStack matrices, int x, int y) {
        if (selectedGroup != null) {
            selectedGroup.draw(matrices, this, x, y);
            this.textBoxes.draw(matrices, this);
        } else {
            Group.drawOverview(matrices, this, this.tierScroll, this.groupScroll, x, y);
        }
    }

    private void drawMenuPage(MatrixStack matrices, int x, int y) {
        IFormattableTextComponent str;
        QuestingDataManager manager = QuestingDataManager.getInstance();
        this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.lives", new Object[0]), 180, 20, 0x404040);
        if (HQMConfig.getInstance().ENABLE_TEAMS) {
            this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.party", new Object[0]), 180, 95, 0x404040);
        }
        this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.quests", new Object[0]), 20, 20, 0x404040);
        this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.reputation", new Object[0]), 20, 110, 0x404040);
        QuestSet.drawQuestInfo(matrices, this, null, 20, 33);
        this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.showQuests", new Object[0]), 20, 87, 0.7f, 0x707070);
        if (manager.isHardcoreActive()) {
            int spacing;
            int count;
            int heartX;
            boolean almostOut;
            boolean bl = almostOut = manager.getQuestingData(this.player).getLives() == manager.getQuestingData(this.player).getLivesToStayAlive();
            if (almostOut) {
                this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.deadOut", GuiColor.RED, new Object[0]), 230, 22, 0.7f, 0x404040);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int lives = manager.getQuestingData(this.player).getLives();
            if (lives < 8) {
                heartX = 185;
                count = lives;
                spacing = 18;
            } else {
                heartX = 205;
                count = 3;
                spacing = 3;
                this.drawString(matrices, Translator.plain(lives + " x"), 185, 37, 0.7f, 0x404040);
            }
            for (int i = 0; i < count; ++i) {
                this.drawItemStack(new ItemStack((IItemProvider)ModItems.heart.get(), 1), heartX + spacing * i, 32, almostOut);
            }
        } else {
            this.drawString(matrices, this.getLinesFromText((ITextProperties)Translator.translatable("hqm.questBook.infiniteLives", new Object[0]), 0.5f, 140), 180, 32, 0.5f, 0x707070);
        }
        int deaths = DeathStatsManager.getInstance().getDeathStat(this.getPlayer().func_110124_au()).getTotalDeaths();
        this.drawString(matrices, (ITextProperties)Translator.pluralTranslated(deaths != 1, "hqm.questBook.deaths", deaths), 180, 55, 0.7f, 0x404040);
        this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.moreInfo", new Object[0]), 180, 65, 0.7f, 0x707070);
        if (!HQMConfig.getInstance().ENABLE_TEAMS) {
            return;
        }
        Team team = manager.getQuestingData(this.player).getTeam();
        if (team.isSingle()) {
            int invites;
            int n = invites = team.getInvites() == null ? 0 : team.getInvites().size();
            str = invites > 0 ? Translator.pluralTranslated(invites != 1, "hqm.questBook.invites", invites) : Translator.translatable("hqm.questBook.notInParty", new Object[0]);
        } else {
            int players = 0;
            for (PlayerEntry player : team.getPlayers()) {
                if (!player.isInTeam()) continue;
                ++players;
            }
            str = Translator.pluralTranslated(players != 1, "hqm.questBook.inParty", players);
        }
        this.drawString(matrices, (ITextProperties)str, 180, 107, 0.7f, 0x404040);
        this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.openParty", new Object[0]), 180, 125, 0.7f, 0x707070);
        if (this.isOpBook) {
            this.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.resetParty", new Object[0]), 22, 182, 0.6f, 0x404040);
            this.drawString(matrices, this.getLinesFromText((ITextProperties)Translator.translatable("hqm.questBook.shiftCtrlConfirm", new Object[0]), 0.6f, 70), 22, 192, 0.6f, GuiColor.RED.getHexColor());
        }
        Reputation.drawAll(matrices, this, 25, 122, x, y, this.player);
    }

    private void drawMainPage(MatrixStack matrices) {
        QuestLine questLine = QuestLine.getActiveQuestLine();
        int startLine = this.mainDescriptionScroll.isVisible(this) ? Math.round((float)(Quest.getMainDescription(this).size() - 21) * this.mainDescriptionScroll.getScroll()) : 0;
        this.drawString(matrices, Quest.getMainDescription(this), startLine, 21, 180, 20, 0.7f, 0x404040);
        this.drawCenteredString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.start", new Object[0]), 0, 195, 0.7f, 170, 39, 0x707070);
        if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
            this.drawCenteredString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.playAgain", new Object[0]), 170, 195, 0.7f, 160, 39, 0x707070);
        }
        if (questLine.front == null) {
            File file = new File(HardcoreQuestingCore.configDir.toFile(), "front.png");
            if (file.exists()) {
                try {
                    NativeImage img = NativeImage.func_195713_a((InputStream)new FileInputStream(file));
                    DynamicTexture dm = new DynamicTexture(img);
                    questLine.front = Minecraft.func_71410_x().func_110434_K().func_110578_a(FRONT_KEY, dm);
                }
                catch (IOException ignored) {
                    questLine.front = ResourceHelper.getResource("front");
                }
            } else {
                questLine.front = ResourceHelper.getResource("front");
            }
        }
        if (questLine.front != null) {
            ResourceHelper.bindResource(questLine.front);
            this.applyColor(-1);
            this.drawRect(20, 20, 0, 0, 140, 180);
        }
    }

    public void goBack() {
        if (isMenuPageOpen) {
            isMainPageOpen = true;
        } else if (isBagPage) {
            isBagPage = false;
            isMenuPageOpen = true;
        } else if (isReputationPage) {
            isMenuPageOpen = true;
            isReputationPage = false;
        } else if (selectedSet == null || !isSetOpened) {
            isMenuPageOpen = true;
        } else if (selectedQuest == null) {
            isSetOpened = false;
        }
    }

    private void onButtonClicked() {
        if (this.currentMode == EditMode.BAG) {
            this.currentMode = EditMode.NORMAL;
            isBagPage = true;
            isMenuPageOpen = false;
        } else if (this.currentMode == EditMode.REPUTATION) {
            this.currentMode = EditMode.NORMAL;
            isReputationPage = true;
            isMenuPageOpen = false;
        }
    }

    private void bagPageMouseClicked(int button, int x, int y) {
        if (selectedGroup != null) {
            if (button == 1) {
                selectedGroup = null;
            } else {
                selectedGroup.mouseClicked(this, x, y);
                this.textBoxes.onClick(this, x, y);
            }
        } else if (button == 1) {
            isBagPage = false;
            isMenuPageOpen = true;
        } else {
            Group.mouseClickedOverview(this, this.groupScroll, x, y);
            GroupTier.mouseClickedOverview(this, this.tierScroll, x, y);
        }
    }

    private void menuPageMouseClicked(int button, int x, int y) {
        if (button == 1) {
            isMainPageOpen = true;
        } else if (HQMConfig.getInstance().ENABLE_TEAMS && this.inBounds(180, 125, 170, 6, x, y)) {
            this.editMenu = new GuiEditMenuTeam(this, this.player);
        } else if (this.inBounds(180, 65, 170, 6, x, y)) {
            this.editMenu = new GuiEditMenuDeath(this, this.player);
        } else if (this.inBounds(20, 87, 170, 6, x, y)) {
            isMenuPageOpen = false;
        }
    }

    private void mainPageMouseClicked(int x, int y) {
        if (x > 0 && x < 170 && y > 205) {
            isMainPageOpen = false;
            SoundHandler.stopLoreMusic();
        } else if (x > 170 && x < 340 && y > 205) {
            if (SoundHandler.hasLoreMusic() && !SoundHandler.isLorePlaying()) {
                SoundHandler.playLoreMusic();
            }
        } else if (Quest.canQuestsBeEdited() && this.currentMode == EditMode.RENAME && this.inBounds(180, 20, 130, 132, x, y)) {
            TextMenu.display(this, this.player, Quest.getRawMainDescription(), false, QuestLine.getActiveQuestLine()::setMainDescription);
        }
    }

    private void updatePosition(int x, int y) {
        if (Quest.canQuestsBeEdited() && this.currentMode == EditMode.MOVE) {
            if (this.modifyingQuest != null) {
                this.modifyingQuest.setGuiCenterX(x);
                this.modifyingQuest.setGuiCenterY(y);
            }
            if (this.modifyingBar != null) {
                this.modifyingBar.moveTo(x, y);
            }
        }
    }

    public void loadMap() {
        selectedQuest = null;
    }

    public EditMode getCurrentMode() {
        return this.currentMode;
    }

    public void setCurrentMode(EditMode mode) {
        this.currentMode = mode;
        if (this.currentMode == EditMode.COMMAND_CREATE || this.currentMode == EditMode.COMMAND_CHANGE) {
            this.setEditMenu(new GuiEditMenuCommandEditor(this, this.player));
        }
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public void save() {
        QuestLine.getActiveQuestLine().saveAll();
        SaveHelper.onSave();
    }

    private EditButton[] getButtons() {
        return isMainPageOpen ? this.mainButtons : (isMenuPageOpen ? this.menuButtons : (isReputationPage ? this.reputationButtons : (isBagPage ? (selectedGroup != null ? this.groupButtons : this.bagButtons) : (selectedSet == null || !isSetOpened ? this.overviewButtons : (selectedQuest == null ? this.setButtons : this.questButtons)))));
    }

    private boolean shouldDisplayControlArrow(boolean isMenuArrow) {
        return !isMainPageOpen && ((!isMenuArrow || !isMenuPageOpen) && this.editMenu == null || this.editMenu != null && !this.editMenu.hasButtons());
    }

    private boolean inArrowBounds(boolean isMenuArrow, int mX, int mY) {
        if (isMenuArrow) {
            return this.inBounds(161, 217, 14, 9, mX, mY);
        }
        return this.inBounds(9, 219, 15, 10, mX, mY);
    }

    private boolean shouldDisplayAndIsInArrowBounds(boolean isMenuArrow, int mX, int mY) {
        return this.shouldDisplayControlArrow(isMenuArrow) && this.inArrowBounds(isMenuArrow, mX, mY);
    }

    static {
        isMainPageOpen = true;
        isMenuPageOpen = true;
    }
}

