/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

public enum GuiColor {
    BLACK(0, 0),
    BLUE(1, 170),
    GREEN(2, 43520),
    CYAN(3, 43690),
    RED(4, 0xFF5555),
    PURPLE(5, 0xAA00AA),
    ORANGE(6, 0xFFAA00),
    LIGHT_GRAY(7, 0x555555),
    GRAY(8, 0xAAAAAA),
    LIGHT_BLUE(9, 3964623),
    LIME(10, 0x55FF55),
    TURQUOISE(11, 4251856),
    PINK(12, 0xFF55FF),
    MAGENTA(13, 0xFF00FF),
    YELLOW(14, 0xFFFF55),
    WHITE(15, 0xFFFFFF);

    private String tagColor;
    private float red;
    private float green;
    private float blue;
    private int hex;

    private GuiColor(int number, float red, float green, float blue) {
        this.tagColor = "\u00a7" + Integer.toHexString(number);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.hex = 0xFF000000 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
    }

    private GuiColor(int number, int hex) {
        this.tagColor = "\u00a7" + Integer.toHexString(number);
        this.hex = hex;
        this.red = hex >> 16 & 0xFF;
        this.green = hex >> 8 & 0xFF;
        this.blue = hex & 0xFF;
    }

    public float getRed() {
        return this.red;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public int getHexColor() {
        return this.hex;
    }

    public String toString() {
        return this.tagColor;
    }

    public String getName() {
        return (super.toString().charAt(0) + super.toString().substring(1).toLowerCase()).replace("_", " ");
    }
}

