/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client.interfaces;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.client.interfaces.RenderRotation;
import hardcorequesting.common.forge.client.interfaces.ResourceHelper;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenu;
import hardcorequesting.common.forge.platform.FluidStack;
import hardcorequesting.common.forge.util.Translator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class GuiBase
extends Screen {
    public static final ResourceLocation MAP_TEXTURE = ResourceHelper.getResource("questmap");
    public static final int ITEM_SIZE = 18;
    protected static final int ITEM_SRC_Y = 235;
    protected static ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    protected int left;
    protected int top;

    protected GuiBase(ITextComponent title) {
        super(title);
    }

    public void setEditMenu(GuiEditMenu menu) {
    }

    public void drawRect(int x, int y, int u, int v, int w, int h) {
        this.drawRect(x, y, u, v, w, h, RenderRotation.NORMAL);
    }

    public void drawRect(int x, int y, int u, int v, int w, int h, RenderRotation rotation) {
        double[] pt4;
        double[] pt3;
        double[] pt2;
        double[] pt1;
        boolean rotate = rotation == RenderRotation.ROTATE_90 || rotation == RenderRotation.ROTATE_270 || rotation == RenderRotation.ROTATE_90_FLIP || rotation == RenderRotation.ROTATE_270_FLIP;
        int targetW = rotate ? h : w;
        int targetH = rotate ? w : h;
        x += this.left;
        y += this.top;
        float fw = 0.00390625f;
        float fy = 0.00390625f;
        double a = (float)u * fw;
        double b = (float)(u + w) * fw;
        double c = (float)(v + h) * fy;
        double d = (float)v * fy;
        double[] ptA = new double[]{a, c};
        double[] ptB = new double[]{b, c};
        double[] ptC = new double[]{b, d};
        double[] ptD = new double[]{a, d};
        switch (rotation) {
            default: {
                pt1 = ptA;
                pt2 = ptB;
                pt3 = ptC;
                pt4 = ptD;
                break;
            }
            case ROTATE_90: {
                pt1 = ptB;
                pt2 = ptC;
                pt3 = ptD;
                pt4 = ptA;
                break;
            }
            case ROTATE_180: {
                pt1 = ptC;
                pt2 = ptD;
                pt3 = ptA;
                pt4 = ptB;
                break;
            }
            case ROTATE_270: {
                pt1 = ptD;
                pt2 = ptA;
                pt3 = ptB;
                pt4 = ptC;
                break;
            }
            case FLIP_HORIZONTAL: {
                pt1 = ptB;
                pt2 = ptA;
                pt3 = ptD;
                pt4 = ptC;
                break;
            }
            case ROTATE_90_FLIP: {
                pt1 = ptA;
                pt2 = ptD;
                pt3 = ptC;
                pt4 = ptB;
                break;
            }
            case FLIP_VERTICAL: {
                pt1 = ptD;
                pt2 = ptC;
                pt3 = ptB;
                pt4 = ptA;
                break;
            }
            case ROTATE_270_FLIP: {
                pt1 = ptC;
                pt2 = ptB;
                pt3 = ptA;
                pt4 = ptD;
            }
        }
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_((double)x, (double)(y + targetH), (double)this.func_230927_p_()).func_225583_a_((float)pt1[0], (float)pt1[1]).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + targetW), (double)(y + targetH), (double)this.func_230927_p_()).func_225583_a_((float)pt2[0], (float)pt2[1]).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + targetW), (double)y, (double)this.func_230927_p_()).func_225583_a_((float)pt3[0], (float)pt3[1]).func_181675_d();
        bufferBuilder.func_225582_a_((double)x, (double)y, (double)this.func_230927_p_()).func_225583_a_((float)pt4[0], (float)pt4[1]).func_181675_d();
        bufferBuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }

    public void renderTooltip(MatrixStack matrices, ITextProperties stringRenderable, int x, int y) {
        this.renderTooltipL(matrices, this.field_230712_o_.func_238420_b_().func_238362_b_(stringRenderable, Integer.MAX_VALUE, Style.field_240709_b_), x, y);
    }

    public void renderTooltipL(MatrixStack matrices, List<? extends ITextProperties> stringRenderables, int x, int y) {
        this.func_238654_b_(matrices, LanguageMap.func_74808_a().func_244260_a(stringRenderables), x, y);
    }

    public void drawLine(int x1, int y1, int x2, int y2, int thickness, int color) {
        RenderSystem.disableTexture();
        this.applyColor(color);
        GL11.glEnable((int)2848);
        float scale = (float)this.field_230706_i_.func_228018_at_().func_198100_s();
        GL11.glLineWidth((float)(1.0f + (float)thickness * scale / 2.0f));
        GL11.glBegin((int)1);
        GL11.glVertex3f((float)x1, (float)y1, (float)0.0f);
        GL11.glVertex3f((float)x2, (float)y2, (float)0.0f);
        GL11.glEnd();
        RenderSystem.enableTexture();
    }

    public void func_230457_a_(MatrixStack matrices, ItemStack stack, int x, int y) {
        super.func_230457_a_(matrices, stack, x, y);
    }

    public void drawFluid(FluidStack fluid, MatrixStack stack, int x, int y, int mX, int mY) {
        this.drawItemBackground(x, y, mX, mY, false);
        if (fluid != null) {
            this.drawFluid(fluid, stack, x + 1, y + 1);
        }
    }

    public void drawFluid(FluidStack fluid, MatrixStack stack, int x, int y) {
        HardcoreQuestingCore.platform.renderFluidStack(fluid, stack, this.getLeft() + x, this.getTop() + y, this.getLeft() + x + 16, this.getTop() + y + 16);
    }

    public void applyColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public void drawIcon(ItemStack stack, int x, int y) {
        itemRenderer.func_180453_a(this.field_230712_o_, stack, x, y, null);
    }

    public void drawItemBackground(int x, int y, int mX, int mY, boolean selected) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelper.bindResource(MAP_TEXTURE);
        this.drawRect(x, y, this.inBounds(x, y, 18, 18, mX, mY) ? 18 : 0, 235, 18, 18);
        if (selected) {
            this.drawRect(x, y, 36, 235, 18, 18);
        }
    }

    public void drawItemStack(ItemStack stack, int x, int y, int mX, int mY, boolean selected) {
        this.drawItemBackground(x, y, mX, mY, selected);
        if (!stack.func_190926_b()) {
            this.drawItemStack(stack, x + 1, y + 1, true);
        }
    }

    protected void setColor(int color) {
        float[] colorComponents = new float[3];
        for (int i = 0; i < colorComponents.length; ++i) {
            colorComponents[i] = (float)((color & 255 << i * 8) >> i * 8) / 255.0f;
        }
        RenderSystem.color4f((float)colorComponents[2], (float)colorComponents[1], (float)colorComponents[0], (float)1.0f);
    }

    public void drawItemStack(@NotNull ItemStack stack, int x, int y, boolean renderEffect) {
        try {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.enableDepthTest();
            RenderSystem.enableRescaleNormal();
            ItemRenderer renderer = Minecraft.func_71410_x().func_175599_af();
            renderer.func_239390_c_(stack, this.getLeft() + x, this.getTop() + y);
            renderer.func_175030_a(this.field_230712_o_, stack, this.getLeft() + x, this.getTop() + y);
            RenderSystem.popMatrix();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getStringWidth(String txt) {
        return this.field_230712_o_.func_78256_a(txt);
    }

    public int getStringWidth(ITextProperties txt) {
        return this.field_230712_o_.func_238414_a_(txt);
    }

    public void drawString(MatrixStack matrices, ITextProperties str, int x, int y, int color) {
        this.drawString(matrices, str, x, y, 1.0f, color);
    }

    public void drawString(MatrixStack matrices, ITextProperties str, int x, int y, float mult, int color) {
        this.drawString(matrices, str, x, y, false, mult, color);
    }

    public void drawString(MatrixStack matrices, ITextProperties str, int x, int y, boolean shadow, float mult, int color) {
        RenderSystem.pushMatrix();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        matrices.func_227860_a_();
        matrices.func_227862_a_(mult, mult, 1.0f);
        IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        this.field_230712_o_.func_238416_a_(str.getString().isEmpty() ? IReorderingProcessor.field_242232_a : LanguageMap.func_74808_a().func_241870_a(str), (float)((int)((float)(x + this.left) / mult)), (float)((int)((float)(y + this.top) / mult)), color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)immediate, false, 0, 0xF000F0);
        immediate.func_228461_a_();
        matrices.func_227865_b_();
        RenderSystem.popMatrix();
    }

    public void drawStringWithShadow(MatrixStack matrices, ITextProperties str, int x, int y, float mult, int color) {
        this.drawString(matrices, str, x, y, true, mult, color);
    }

    public void drawString(MatrixStack matrices, String str, int x, int y, int color) {
        this.drawString(matrices, str, x, y, 1.0f, color);
    }

    public void drawString(MatrixStack matrices, String str, int x, int y, float mult, int color) {
        this.drawString(matrices, str == null ? ITextProperties.field_240651_c_ : ITextProperties.func_240652_a_((String)str), x, y, mult, color);
    }

    public void drawStringWithShadow(MatrixStack matrices, String str, int x, int y, float mult, int color) {
        this.drawStringWithShadow(matrices, str == null ? ITextProperties.field_240651_c_ : ITextProperties.func_240652_a_((String)str), x, y, mult, color);
    }

    public boolean inBounds(int x, int y, int w, int h, double mX, double mY) {
        return (double)x <= mX && mX <= (double)(x + w) && (double)y <= mY && mY <= (double)(y + h);
    }

    public void drawCursor(MatrixStack matrices, int x, int y, int z, float size, int color) {
        matrices.func_227860_a_();
        matrices.func_227861_a_(0.0, 0.0, (double)z);
        matrices.func_227861_a_((double)(x += this.left), (double)(y += this.top), 0.0);
        matrices.func_227862_a_(size, size, 0.0f);
        matrices.func_227861_a_((double)(-x), (double)(-y), 0.0);
        AbstractGui.func_238467_a_((MatrixStack)matrices, (int)x, (int)(y + 1), (int)(x + 1), (int)(y + 10), (int)color);
        matrices.func_227865_b_();
    }

    public void drawString(MatrixStack matrices, List<ITextProperties> str, int x, int y, float mult, int color) {
        this.drawString(matrices, str, 0, str.size(), x, y, mult, color);
    }

    public void drawString(MatrixStack matrices, List<ITextProperties> str, int start, int length, int x, int y, float mult, int color) {
        matrices.func_227860_a_();
        matrices.func_227862_a_(mult, mult, 1.0f);
        start = Math.max(start, 0);
        int end = Math.min(start + length, str.size());
        for (int i = start; i < end; ++i) {
            this.field_230712_o_.func_238422_b_(matrices, LanguageMap.func_74808_a().func_241870_a(str.get(i)), (float)((int)((float)(x + this.left) / mult)), (float)((int)((float)(y + this.top) / mult)), color);
            this.field_230712_o_.getClass();
            y += 9;
        }
        matrices.func_227865_b_();
    }

    public void drawCenteredString(MatrixStack matrices, ITextProperties str, int x, int y, float mult, int width, int height, int color) {
        int n = x + (width - (int)((float)this.field_230712_o_.func_238414_a_(str) * mult)) / 2;
        this.field_230712_o_.getClass();
        this.drawString(matrices, str, n, y + (height - (int)((float)(9 - 2) * mult)) / 2, mult, color);
    }

    public List<ITextProperties> getLinesFromText(ITextProperties str, float mult, int width) {
        if (str == null) {
            str = Translator.plain("Missing info");
        }
        return this.field_230712_o_.func_238420_b_().func_238362_b_(str, (int)((float)width / mult), Style.field_240709_b_);
    }
}

