/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import hardcorequesting.common.forge.HardcoreQuestingCore;
import hardcorequesting.common.forge.platform.FluidStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.EmptyFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.Registry;

public class TextSearch<T> {
    private static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    private static Future<?> currentSearch;
    public static List<SearchEntry<ItemStack>> ITEMS;
    public static List<SearchEntry<FluidStack>> FLUIDS;
    private final String text;
    private final Supplier<Stream<SearchEntry<T>>> searchEntrySupplier;
    private final int limit;
    private final boolean advancedTooltips;

    public static <A, B> Stream<SearchEntry<B>> innerMap(Stream<SearchEntry<A>> stream, Function<A, B> mapper) {
        return stream.map(entry -> entry.map(mapper));
    }

    public static <T> Future<List<T>> startSearch(String text, Supplier<Stream<SearchEntry<T>>> searchEntrySupplier, int limit) {
        if (currentSearch != null) {
            currentSearch.cancel(true);
        }
        TextSearch<T> search = new TextSearch<T>(text, searchEntrySupplier, limit);
        Future<List<T>> future = EXECUTOR.submit(search::doSearch);
        currentSearch = future;
        return future;
    }

    private TextSearch(String text, Supplier<Stream<SearchEntry<T>>> searchEntrySupplier, int limit) {
        this.text = text;
        this.searchEntrySupplier = searchEntrySupplier;
        this.limit = limit;
        this.advancedTooltips = Minecraft.func_71410_x().field_71474_y.field_82882_x;
    }

    private List<T> doSearch() {
        TextSearch.initItems();
        Pattern pattern = Pattern.compile(Pattern.quote(this.text), 2);
        return this.searchEntrySupplier.get().flatMap(entry -> entry.tryMatch(pattern, this.advancedTooltips)).limit(this.limit).collect(Collectors.toList());
    }

    public static void initItems() {
        if (ITEMS.isEmpty() || FLUIDS.isEmpty()) {
            TextSearch.clear();
            NonNullList stacks = NonNullList.func_191196_a();
            for (Item item : Registry.field_212630_s) {
                try {
                    item.func_150895_a(item.func_77640_w(), stacks);
                }
                catch (Exception exception) {}
            }
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            for (ItemStack stack : stacks) {
                List tooltipList = stack.func_82840_a((PlayerEntity)player, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                List advTooltipList = stack.func_82840_a((PlayerEntity)player, (ITooltipFlag)ITooltipFlag.TooltipFlags.ADVANCED);
                StringBuilder searchString = new StringBuilder();
                for (Object string : tooltipList) {
                    if (string == null) continue;
                    searchString.append(string).append("\n");
                }
                StringBuilder advSearchString = new StringBuilder();
                for (Object string : advTooltipList) {
                    if (string == null) continue;
                    advSearchString.append(string).append("\n");
                }
                ITEMS.add(new SearchEntry<ItemStack>(searchString.toString(), advSearchString.toString(), stack));
            }
            for (Fluid fluid : Registry.field_212619_h) {
                if (fluid instanceof EmptyFluid || !fluid.func_207188_f().func_206889_d()) continue;
                FluidStack fluidVolume = HardcoreQuestingCore.platform.createFluidStack(fluid, HardcoreQuestingCore.platform.getBucketAmount());
                String search = fluidVolume.getName().getString();
                FLUIDS.add(new SearchEntry<FluidStack>(search, search, fluidVolume));
            }
        }
    }

    public static void clear() {
        FLUIDS.clear();
        ITEMS.clear();
    }

    static {
        ITEMS = new ArrayList<SearchEntry<ItemStack>>();
        FLUIDS = new ArrayList<SearchEntry<FluidStack>>();
    }

    public static class SearchEntry<T> {
        private final String toolTip;
        private final String advToolTip;
        private final T element;

        public SearchEntry(String searchString, String advSearchString, T element) {
            this.toolTip = searchString;
            this.advToolTip = advSearchString;
            this.element = element;
        }

        public Stream<T> tryMatch(Pattern pattern, boolean advanced) {
            if (pattern.matcher(advanced ? this.advToolTip : this.toolTip).find()) {
                return Stream.of(this.element);
            }
            return Stream.empty();
        }

        public <R> SearchEntry<R> map(Function<T, R> mapper) {
            return new SearchEntry<R>(this.toolTip, this.advToolTip, mapper.apply(this.element));
        }
    }
}

