/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.KeyboardHandler;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextPropertiesManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class EditButton {
    private static final int BUTTON_SIZE = 16;
    private static final int BUTTON_ICON_SIZE = 12;
    private static final int BUTTON_ICON_SRC_X = 0;
    private static final int BUTTON_ICON_SRC_Y = 0;
    private static final int EDIT_BUTTONS_PER_ROW = 2;
    private static final int EDIT_BUTTONS_SRC_PER_ROW = 8;
    private GuiQuestBook guiQuestBook;
    private int x;
    private int y;
    private EditMode mode;
    private List<IReorderingProcessor> text;

    public EditButton(GuiQuestBook guiQuestBook, EditMode mode, int id) {
        this.guiQuestBook = guiQuestBook;
        this.mode = mode;
        int x = id % 2;
        int y = id / 2;
        this.x = -38 + x * 20;
        this.y = 5 + y * 20;
    }

    public static EditButton[] createButtons(GuiQuestBook gui, EditMode ... modes) {
        EditButton[] ret = new EditButton[modes.length];
        for (int i = 0; i < modes.length; ++i) {
            EditMode mode = modes[i];
            ret[i] = new EditButton(gui, mode, i);
        }
        return ret;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(int mX, int mY) {
        int srcY = this.guiQuestBook.getCurrentMode() == this.mode ? 2 : (this.guiQuestBook.inBounds(this.x, this.y, 16, 16, mX, mY) ? 1 : 0);
        this.guiQuestBook.drawRect(this.x, this.y, 240, srcY * 16, 16, 16);
        this.guiQuestBook.drawRect(this.x + 2, this.y + 2, 0 + this.mode.ordinal() % 8 * 12, 0 + this.mode.ordinal() / 8 * 12, 12, 12);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInfo(MatrixStack matrices, int mX, int mY) {
        if (this.guiQuestBook.inBounds(this.x, this.y, 16, 16, mX, mY)) {
            if (this.text == null) {
                ArrayList<Object> text = new ArrayList<Object>();
                if (KeyboardHandler.keyMap.containsValue((Object)this.mode)) {
                    ArrayList<String> builder = new ArrayList<String>();
                    for (Map.Entry entry : KeyboardHandler.keyMap.entries()) {
                        if (entry.getValue() != this.mode) continue;
                        builder.add("\u00a77" + StringUtils.capitalize((String)InputMappings.Type.KEYSYM.func_197944_a(((Integer)entry.getKey()).intValue()).func_237520_d_().getString()));
                    }
                    text.add(Translator.translatable("hqm.editMode.keybind", this.mode.getName(), String.join((CharSequence)", ", builder)));
                } else {
                    text.add(ITextProperties.func_240652_a_((String)this.mode.getName()));
                }
                text.addAll(this.guiQuestBook.getLinesFromText(Translator.plain("\n" + this.mode.getDescription()), 1.0f, 150));
                for (int i = 1; i < text.size(); ++i) {
                    TextPropertiesManager collector = new TextPropertiesManager();
                    ((ITextProperties)text.get(i)).func_230439_a_((style, string) -> {
                        collector.func_238155_a_(ITextProperties.func_240653_a_((String)string, (Style)style));
                        return Optional.empty();
                    }, Style.field_240709_b_);
                    text.set(i, collector.func_238156_b_());
                }
                this.text = LanguageMap.func_74808_a().func_244260_a(text);
            }
            this.guiQuestBook.func_238654_b_(matrices, this.text, mX + this.guiQuestBook.getLeft(), mY + this.guiQuestBook.getTop());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean onClick(int mX, int mY) {
        if (this.guiQuestBook.inBounds(this.x, this.y, 16, 16, mX, mY)) {
            this.guiQuestBook.setCurrentMode(this.mode);
            this.guiQuestBook.modifyingQuest = null;
            this.guiQuestBook.modifyingBar = null;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean click() {
        return this.onClick(this.x, this.y);
    }

    public boolean matchesMode(EditMode mode) {
        return this.mode == mode;
    }
}

