/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.blue.endless.jankson.impl;

import hardcorequesting.common.forge.blue.endless.jankson.JsonArray;
import hardcorequesting.common.forge.blue.endless.jankson.JsonElement;
import hardcorequesting.common.forge.blue.endless.jankson.JsonGrammar;
import hardcorequesting.common.forge.blue.endless.jankson.JsonNull;
import hardcorequesting.common.forge.blue.endless.jankson.JsonObject;
import hardcorequesting.common.forge.blue.endless.jankson.JsonPrimitive;
import hardcorequesting.common.forge.blue.endless.jankson.annotation.Deserializer;
import hardcorequesting.common.forge.blue.endless.jankson.annotation.SerializedName;
import hardcorequesting.common.forge.blue.endless.jankson.api.DeserializationException;
import hardcorequesting.common.forge.blue.endless.jankson.api.Marshaller;
import hardcorequesting.common.forge.blue.endless.jankson.impl.serializer.DeserializerFunctionPool;
import hardcorequesting.common.forge.blue.endless.jankson.impl.serializer.InternalDeserializerFunction;
import hardcorequesting.common.forge.blue.endless.jankson.magic.TypeMagic;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class POJODeserializer {
    public static void unpackObject(Object target, JsonObject source) {
        try {
            POJODeserializer.unpackObject(target, source, false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void unpackObject(Object target, JsonObject source, boolean failFast) throws DeserializationException {
        int modifiers;
        JsonObject work = source.clone();
        for (Field f : target.getClass().getDeclaredFields()) {
            modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            POJODeserializer.unpackField(target, f, work, failFast);
        }
        for (Field f : target.getClass().getFields()) {
            modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            POJODeserializer.unpackField(target, f, work, failFast);
        }
        if (!work.isEmpty() && failFast) {
            throw new DeserializationException("There was data that couldn't be applied to the destination object: " + work.toJson(JsonGrammar.STRICT));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unpackField(Object parent, Field f, JsonObject source, boolean failFast) throws DeserializationException {
        String fieldName = f.getName();
        SerializedName nameAnnotation = f.getAnnotation(SerializedName.class);
        if (nameAnnotation != null) {
            fieldName = nameAnnotation.value();
        }
        if (!source.containsKey(fieldName)) return;
        JsonElement elem = source.get(fieldName);
        source.remove(fieldName);
        if (elem == null || elem == JsonNull.INSTANCE) {
            boolean accessible = f.isAccessible();
            if (!accessible) {
                f.setAccessible(true);
            }
            try {
                f.set(parent, null);
                if (accessible) return;
                f.setAccessible(false);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                if (!failFast) return;
                throw new DeserializationException("Couldn't set field \"" + f.getName() + "\" of class \"" + parent.getClass().getCanonicalName() + "\"", ex);
            }
        }
        try {
            POJODeserializer.unpackFieldData(parent, f, elem, source.getMarshaller());
            return;
        }
        catch (Throwable t) {
            if (!failFast) return;
            throw new DeserializationException("There was a problem unpacking field " + f.getName() + " of class " + parent.getClass().getCanonicalName(), t);
        }
    }

    @Nullable
    public static Object unpack(Type t, JsonElement elem, Marshaller marshaller) {
        Class<?> rawClass = TypeMagic.classForType(t);
        if (rawClass.isPrimitive()) {
            return null;
        }
        if (elem == null) {
            return null;
        }
        return null;
    }

    public static boolean unpackFieldData(Object parent, Field field, JsonElement elem, Marshaller marshaller) throws Throwable {
        if (elem == null) {
            return true;
        }
        try {
            field.setAccessible(true);
        }
        catch (Throwable t) {
            return false;
        }
        if (elem == JsonNull.INSTANCE) {
            field.set(parent, null);
            return true;
        }
        Class<?> fieldClass = field.getType();
        if (!POJODeserializer.isCollections(fieldClass)) {
            Object result = marshaller.marshallCarefully(fieldClass, elem);
            field.set(parent, result);
            return true;
        }
        if (field.get(parent) == null) {
            Object fieldValue = TypeMagic.createAndCast(field.getGenericType());
            if (fieldValue == null) {
                return false;
            }
            field.set(parent, fieldValue);
        }
        if (Map.class.isAssignableFrom(fieldClass)) {
            Type[] parameters = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
            POJODeserializer.unpackMap((Map)field.get(parent), parameters[0], parameters[1], elem, marshaller);
            return true;
        }
        if (Collection.class.isAssignableFrom(fieldClass)) {
            Type elementType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            POJODeserializer.unpackCollection((Collection)field.get(parent), elementType, elem, marshaller);
            return true;
        }
        return false;
    }

    private static boolean isCollections(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz);
    }

    public static void unpackMap(Map<Object, Object> map, Type keyType, Type valueType, JsonElement elem, Marshaller marshaller) throws DeserializationException {
        if (!(elem instanceof JsonObject)) {
            throw new DeserializationException("Cannot deserialize a " + elem.getClass().getSimpleName() + " into a Map - expected a JsonObject!");
        }
        JsonObject object = (JsonObject)elem;
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            try {
                Object k = marshaller.marshall(keyType, (JsonElement)new JsonPrimitive(entry.getKey()));
                Object v = marshaller.marshall(valueType, entry.getValue());
                if (k == null || v == null) continue;
                map.put(k, v);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void unpackCollection(Collection<Object> collection, Type elementType, JsonElement elem, Marshaller marshaller) throws DeserializationException {
        if (!(elem instanceof JsonArray)) {
            throw new DeserializationException("Cannot deserialize a " + elem.getClass().getSimpleName() + " into a Set - expected a JsonArray!");
        }
        JsonArray array = (JsonArray)elem;
        for (JsonElement arrayElem : array) {
            Object o = marshaller.marshall(elementType, arrayElem);
            if (o == null) continue;
            collection.add(o);
        }
    }

    protected static <B> DeserializerFunctionPool<B> deserializersFor(Class<B> targetClass) {
        DeserializerFunctionPool<B> pool = new DeserializerFunctionPool<B>(targetClass);
        for (Method m : targetClass.getDeclaredMethods()) {
            Class<?> sourceClass;
            InternalDeserializerFunction<B> deserializer;
            Parameter[] params;
            if (m.getAnnotation(Deserializer.class) == null || !Modifier.isStatic(m.getModifiers()) || !m.getReturnType().equals(targetClass) || (params = m.getParameters()).length < 1 || (deserializer = POJODeserializer.makeDeserializer(m, sourceClass = params[0].getType(), targetClass)) == null) continue;
            pool.registerUnsafe(sourceClass, deserializer);
        }
        return pool;
    }

    @Nullable
    private static <A, B> InternalDeserializerFunction<B> makeDeserializer(@Nonnull Method m, @Nonnull Class<A> sourceClass, @Nonnull Class<B> targetClass) {
        if (!m.getReturnType().equals(targetClass)) {
            return null;
        }
        Parameter[] params = m.getParameters();
        if (params.length == 1) {
            return (o, marshaller) -> {
                try {
                    return m.invoke(null, o);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new DeserializationException(ex);
                }
            };
        }
        if (params.length == 2) {
            if (params[1].getClass().equals(Marshaller.class)) {
                return (o, marshaller) -> {
                    try {
                        return m.invoke(null, o, marshaller);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                        throw new DeserializationException(ex);
                    }
                };
            }
            return null;
        }
        return null;
    }
}

