/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.blue.endless.jankson;

import hardcorequesting.common.forge.blue.endless.jankson.JsonElement;
import hardcorequesting.common.forge.blue.endless.jankson.JsonGrammar;
import java.util.Objects;
import javax.annotation.Nonnull;

public class JsonPrimitive
extends JsonElement {
    public static JsonPrimitive TRUE = new JsonPrimitive(Boolean.TRUE);
    public static JsonPrimitive FALSE = new JsonPrimitive(Boolean.FALSE);
    @Nonnull
    private Object value;

    public JsonPrimitive(@Nonnull Object value) {
        this.value = value;
    }

    @Nonnull
    public String asString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.toString();
    }

    public boolean asBoolean(boolean defaultValue) {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        return defaultValue;
    }

    public byte asByte(byte defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).byteValue();
        }
        return defaultValue;
    }

    public char asChar(char defaultValue) {
        if (this.value instanceof Number) {
            return (char)((Number)this.value).intValue();
        }
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        if (this.value instanceof String) {
            if (((String)this.value).length() == 1) {
                return ((String)this.value).charAt(0);
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public short asShort(short defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).shortValue();
        }
        return defaultValue;
    }

    public int asInt(int defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        return defaultValue;
    }

    public long asLong(long defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).longValue();
        }
        return defaultValue;
    }

    public float asFloat(float defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).floatValue();
        }
        return defaultValue;
    }

    public double asDouble(double defaultValue) {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        return defaultValue;
    }

    @Nonnull
    public String toString() {
        return this.toJson();
    }

    @Nonnull
    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof JsonPrimitive) {
            return Objects.equals(this.value, ((JsonPrimitive)other).value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static String escape(String s) {
        StringBuilder result = new StringBuilder();
        block9: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\b': {
                    result.append("\\b");
                    continue block9;
                }
                case '\f': {
                    result.append("\\f");
                    continue block9;
                }
                case '\n': {
                    result.append("\\n");
                    continue block9;
                }
                case '\r': {
                    result.append("\\r");
                    continue block9;
                }
                case '\t': {
                    result.append("\\t");
                    continue block9;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block9;
                }
                default: {
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        return this.toJson(JsonGrammar.builder().withComments(comments).printWhitespace(newlines).build(), depth);
    }

    @Override
    public String toJson(JsonGrammar grammar, int depth) {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof Double && grammar.bareSpecialNumerics) {
            double d = (Double)this.value;
            if (Double.isNaN(d)) {
                return "NaN";
            }
            if (Double.isInfinite(d)) {
                if (d < 0.0) {
                    return "-Infinity";
                }
                return "Infinity";
            }
            return this.value.toString();
        }
        if (this.value instanceof Number) {
            return this.value.toString();
        }
        if (this.value instanceof Boolean) {
            return this.value.toString();
        }
        return '\"' + JsonPrimitive.escape(this.value.toString()) + '\"';
    }

    @Override
    public JsonPrimitive clone() {
        return this;
    }
}

