/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.bag;

import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import hardcorequesting.common.forge.bag.Group;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.io.SaveHandler;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.SimpleSerializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class GroupTierManager
extends SimpleSerializable {
    public final Map<UUID, Group> groups = new ConcurrentHashMap<UUID, Group>();
    private final List<GroupTier> tiers = Lists.newArrayList();

    public GroupTierManager(QuestLine parent) {
        super(parent);
    }

    public static GroupTierManager getInstance() {
        return QuestLine.getActiveQuestLine().groupTierManager;
    }

    @Override
    public String saveToString() {
        return SaveHandler.save(this.tiers, new TypeToken<List<GroupTier>>(){}.getType());
    }

    @Override
    public void loadFromString(Optional<String> string) {
        this.groups.clear();
        this.tiers.clear();
        string.flatMap(s -> SaveHandler.load(s, new TypeToken<List<GroupTier>>(){}.getType())).ifPresent(this.tiers::addAll);
    }

    @Override
    public String filePath() {
        return "bags.json";
    }

    @Override
    public boolean isData() {
        return false;
    }

    public List<GroupTier> getTiers() {
        return this.tiers;
    }
}

