/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.bag;

import hardcorequesting.common.forge.bag.Group;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.client.interfaces.GuiColor;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.edit.GuiEditMenuTier;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GroupTier {
    private String name;
    private GuiColor color;
    private int[] weights;

    public GroupTier(String name, GuiColor color, int ... weights) {
        this.name = name;
        this.color = color;
        this.weights = Arrays.copyOf(weights, weights.length);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar tierScroll, int x, int y) {
        int start;
        List<GroupTier> tiers = GroupTierManager.getInstance().getTiers();
        block6: for (int i = start = tierScroll.isVisible(gui) ? Math.round((float)(tiers.size() - 8) * tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
            int posY = 20 + 25 * (i - start);
            GroupTier groupTier = tiers.get(i);
            if (!gui.inBounds(180, posY, gui.getStringWidth(groupTier.getName()), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case TIER: {
                    if (gui.modifyingGroup == null) break block6;
                    gui.modifyingGroup.setTier(groupTier);
                    SaveHelper.add(EditType.GROUP_CHANGE);
                    break;
                }
                case NORMAL: {
                    gui.setEditMenu(new GuiEditMenuTier(gui, gui.getPlayer(), groupTier));
                    break;
                }
                case RENAME: {
                    TextMenu.display(gui, gui.getPlayer(), groupTier.getName(), 110, groupTier::setName);
                    break;
                }
                case DELETE: {
                    if (tiers.size() <= 1 && Group.getGroups().size() != 0) break block6;
                    for (Group group : Group.getGroups().values()) {
                        if (group.getTier() != groupTier) continue;
                        group.setTier(i == 0 ? tiers.get(1) : tiers.get(0));
                    }
                    tiers.remove(i);
                    SaveHelper.add(EditType.TIER_REMOVE);
                    break;
                }
            }
            break;
        }
    }

    public static void initBaseTiers(QuestLine questLine) {
        List<GroupTier> tiers = questLine.groupTierManager.getTiers();
        tiers.add(new GroupTier("Crap", GuiColor.RED, 50, 50, 50, 5, 0));
        tiers.add(new GroupTier("Plain", GuiColor.GRAY, 50, 50, 50, 30, 10));
        tiers.add(new GroupTier("Common", GuiColor.GREEN, 20, 30, 40, 30, 20));
        tiers.add(new GroupTier("Uncommon", GuiColor.BLUE, 5, 10, 15, 20, 25));
        tiers.add(new GroupTier("Rare", GuiColor.ORANGE, 3, 6, 12, 18, 21));
        tiers.add(new GroupTier("Unique", GuiColor.PURPLE, 1, 2, 3, 4, 30));
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return this.name == null || this.name.equals("") ? I18n.func_135052_a((String)"hqm.bag.unknown", (Object[])new Object[0]) : this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getRawName() {
        return this.name;
    }

    public GuiColor getColor() {
        return this.color;
    }

    public void setColor(GuiColor color) {
        this.color = color;
    }

    public int[] getWeights() {
        return this.weights;
    }

    public GroupTier copy() {
        return new GroupTier(this.name, this.getColor(), this.getWeights());
    }

    public void load(GroupTier tier) {
        this.name = tier.name;
        this.color = tier.color;
        this.weights = Arrays.copyOf(tier.weights, tier.weights.length);
    }
}

