/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.common.forge.bag;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import hardcorequesting.common.forge.bag.BagTier;
import hardcorequesting.common.forge.bag.GroupData;
import hardcorequesting.common.forge.bag.GroupTier;
import hardcorequesting.common.forge.bag.GroupTierManager;
import hardcorequesting.common.forge.client.EditMode;
import hardcorequesting.common.forge.client.interfaces.GuiQuestBook;
import hardcorequesting.common.forge.client.interfaces.ScrollBar;
import hardcorequesting.common.forge.client.interfaces.edit.PickItemMenu;
import hardcorequesting.common.forge.client.interfaces.edit.TextMenu;
import hardcorequesting.common.forge.quests.Quest;
import hardcorequesting.common.forge.quests.QuestLine;
import hardcorequesting.common.forge.quests.QuestingDataManager;
import hardcorequesting.common.forge.util.EditType;
import hardcorequesting.common.forge.util.SaveHelper;
import hardcorequesting.common.forge.util.Translator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Group {
    private GroupTier tier;
    private NonNullList<ItemStack> items;
    private String name;
    private int limit;
    private UUID groupId;

    public Group(UUID groupId) {
        this.groupId = groupId;
        while (this.groupId == null || Group.getGroups().containsKey(this.groupId)) {
            this.groupId = UUID.randomUUID();
        }
        if (groupId == null) {
            if (GroupTierManager.getInstance().getTiers().size() < 1) {
                GroupTier.initBaseTiers(QuestLine.getActiveQuestLine());
            }
            this.tier = GroupTierManager.getInstance().getTiers().get(0);
        }
        this.items = NonNullList.func_191196_a();
    }

    public static int size() {
        return GroupTierManager.getInstance().groups.size();
    }

    public static Map<UUID, Group> getGroups() {
        return GroupTierManager.getInstance().groups;
    }

    public static void remove(UUID groupId) {
        Group.getGroups().remove(groupId);
    }

    public static void add(Group group) {
        Group.getGroups().put(group.getId(), group);
    }

    public static Group getGroup(UUID groupId) {
        return Group.getGroups().get(groupId);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawOverview(MatrixStack matrices, GuiQuestBook gui, ScrollBar tierScroll, ScrollBar groupScroll, int x, int y) {
        int start;
        List<GroupTier> tiers = GroupTierManager.getInstance().getTiers();
        for (int i = start = tierScroll.isVisible(gui) ? Math.round((float)(tiers.size() - 8) * tierScroll.getScroll()) : 0; i < Math.min(start + 8, tiers.size()); ++i) {
            GroupTier groupTier = tiers.get(i);
            String str = groupTier.getName();
            int yPos = 20 + 25 * (i - start);
            boolean inBounds = gui.inBounds(180, yPos, gui.getStringWidth(str), 9, x, y);
            int color = groupTier.getColor().getHexColor();
            if (inBounds) {
                color &= 0xFFFFFF;
                color |= 0xBB000000;
                RenderSystem.enableBlend();
            }
            gui.drawString(matrices, Translator.plain(str), 180, yPos, color);
            if (inBounds) {
                RenderSystem.disableBlend();
            }
            for (int j = 0; j < BagTier.values().length; ++j) {
                BagTier bagTier = BagTier.values()[j];
                gui.drawCenteredString(matrices, (ITextProperties)Translator.text(groupTier.getWeights()[j] + "", bagTier.getColor()), 175 + j * 25, yPos + 12, 0.7f, 25, 0, 0x404040);
            }
        }
        ArrayList<Group> groups = new ArrayList<Group>(Group.getGroups().values());
        for (int i = start = groupScroll.isVisible(gui) ? Math.round((float)(groups.size() - 8) * groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
            boolean selected;
            Group group = (Group)groups.get(i);
            ITextProperties str = Translator.plain(group.getDisplayName());
            int yPos = 20 + 25 * (i - start);
            boolean inBounds = gui.inBounds(20, yPos, gui.getStringWidth(str), 9, x, y);
            int color = group.getTier().getColor().getHexColor();
            boolean bl = selected = group == gui.modifyingGroup;
            if (inBounds || selected) {
                color &= 0xFFFFFF;
                RenderSystem.enableBlend();
                color = selected ? (color |= 0x50000000) : (color |= 0xBB000000);
            }
            gui.drawString(matrices, str, 20, yPos, color);
            if (inBounds || selected) {
                RenderSystem.disableBlend();
            }
            gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.items", group.getItems().size()), 25, yPos + 12, 0.7f, 0x404040);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void mouseClickedOverview(GuiQuestBook gui, ScrollBar groupScroll, int x, int y) {
        int start;
        ArrayList<Group> groups = new ArrayList<Group>(Group.getGroups().values());
        for (int i = start = groupScroll.isVisible(gui) ? Math.round((float)(groups.size() - 8) * groupScroll.getScroll()) : 0; i < Math.min(start + 8, groups.size()); ++i) {
            int posY = 20 + 25 * (i - start);
            Group group = (Group)groups.get(i);
            if (!gui.inBounds(20, posY, gui.getStringWidth(group.getDisplayName()), 9, x, y)) continue;
            switch (gui.getCurrentMode()) {
                case TIER: {
                    gui.modifyingGroup = group == gui.modifyingGroup ? null : group;
                    break;
                }
                case NORMAL: {
                    GuiQuestBook.selectedGroup = group;
                    gui.getTextBoxGroupAmount().setTextAndCursor(gui, String.valueOf(GuiQuestBook.getSelectedGroup().getLimit()));
                    break;
                }
                case RENAME: {
                    TextMenu.display(gui, gui.getPlayer(), group.getDisplayName(), true, group::setName);
                    break;
                }
                case DELETE: {
                    Group.remove(group.getId());
                    SaveHelper.add(EditType.GROUP_REMOVE);
                    break;
                }
            }
            break;
        }
    }

    public GroupTier getTier() {
        return this.tier;
    }

    public void setTier(GroupTier tier) {
        this.tier = tier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getDisplayName() {
        return this.hasName() ? this.name : I18n.func_135052_a((String)"hqm.bag.group", (Object[])new Object[]{this.tier.getName()});
    }

    public String getName() {
        return this.hasName() ? this.name : Translator.translatable("hqm.bag.group", this.tier.getName()).getString();
    }

    public void setName(String name) {
        this.name = name;
        SaveHelper.add(EditType.NAME_CHANGE);
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int id, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        if (id >= this.items.size()) {
            this.items.add((Object)stack);
            SaveHelper.add(EditType.GROUP_ITEM_CREATE);
        } else {
            this.items.set(id, (Object)stack);
            SaveHelper.add(EditType.GROUP_ITEM_CHANGE);
        }
    }

    public void open(PlayerEntity player) {
        GroupData data;
        if (this.limit > 0 && (data = QuestingDataManager.getInstance().getQuestingData(player).getGroupData(this.getId())) != null) {
            ++data.retrieved;
        }
        List<ItemStack> itemsToAdd = this.items.stream().map(ItemStack::func_77946_l).collect(Collectors.toList());
        Quest.addItems(player, itemsToAdd);
        itemsToAdd.stream().filter(item -> item.func_190916_E() > 0).forEach(item -> {
            ItemEntity entityItem = new ItemEntity(player.func_130014_f_(), player.func_226277_ct_() + 0.5, player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, item);
            player.func_130014_f_().func_217376_c((Entity)entityItem);
        });
    }

    public UUID getId() {
        return this.groupId;
    }

    public void removeItem(int i) {
        if (i >= 0 && i < this.items.size()) {
            this.items.remove(i);
        }
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getRetrievalCount(PlayerEntity player) {
        GroupData data = QuestingDataManager.getInstance().getQuestingData(player).getGroupData(this.getId());
        return data != null ? data.retrieved : 0;
    }

    public void setRetrievalCount(PlayerEntity player, int count) {
        GroupData data = QuestingDataManager.getInstance().getQuestingData(player).getGroupData(this.getId());
        if (data != null) {
            data.retrieved = count;
        }
    }

    public boolean isValid(PlayerEntity player) {
        return this.limit == 0 || this.getRetrievalCount(player) < this.limit;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Group && Objects.equals(this.name, ((Group)obj).name) && this.limit == ((Group)obj).limit && this.items.size() == ((Group)obj).items.size()) {
            for (ItemStack stack : this.items) {
                if (this.listContains(stack, (List<ItemStack>)((Group)obj).items)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean listContains(ItemStack stack, List<ItemStack> stacks) {
        for (ItemStack stack2 : stacks) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)stack2)) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void draw(MatrixStack matrices, GuiQuestBook gui, int x, int y) {
        int yPos;
        int xPos;
        ItemStack stack;
        int i;
        gui.drawString(matrices, Translator.plain(this.getDisplayName()), 20, 20, this.getTier().getColor().getHexColor());
        ArrayList<ItemStack> items = new ArrayList<ItemStack>((Collection<ItemStack>)this.getItems());
        items.add(ItemStack.field_190927_a);
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            gui.drawItemStack(stack, xPos, yPos, x, y, false);
        }
        for (i = 0; i < items.size(); ++i) {
            stack = (ItemStack)items.get(i);
            xPos = i % 7 * 20 + 20;
            yPos = i / 7 * 20 + 40;
            if (!gui.inBounds(xPos, yPos, 18, 18, x, y)) continue;
            if (stack.func_190926_b()) break;
            try {
                gui.func_230457_a_(matrices, stack, x + gui.getLeft(), y + gui.getTop());
            }
            catch (Exception exception) {}
            break;
        }
        gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.maxRetrieval", new Object[0]), 180, 20, 0x404040);
        gui.drawString(matrices, (ITextProperties)Translator.translatable("hqm.questBook.noRestriction", new Object[0]), 180, 48, 0.7f, 0x404040);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>((Collection<ItemStack>)this.getItems());
        items.add(ItemStack.field_190927_a);
        for (int i = 0; i < items.size(); ++i) {
            int xPos = i % 7 * 20 + 20;
            int yPos = i / 7 * 20 + 40;
            if (!gui.inBounds(xPos, yPos, 18, 18, x, y)) continue;
            if (gui.getCurrentMode() == EditMode.ITEM) {
                int amount;
                ItemStack stack;
                ItemStack itemStack = stack = i < items.size() ? (ItemStack)items.get(i) : ItemStack.field_190927_a;
                if (!stack.func_190926_b()) {
                    stack = stack.func_77946_l();
                    amount = stack.func_190916_E();
                } else {
                    amount = 1;
                }
                int id = i;
                PickItemMenu.display(gui, gui.getPlayer(), stack, PickItemMenu.Type.ITEM, amount, result -> this.setItem(id, (ItemStack)result.getWithAmount()));
                break;
            }
            if (gui.getCurrentMode() != EditMode.DELETE) break;
            this.removeItem(i);
            SaveHelper.add(EditType.GROUP_ITEM_REMOVE);
            break;
        }
    }
}

