/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawConfig;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawManager;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ZombieDungeonStructure
extends Structure<NoFeatureConfig> {
    public static List<String> whitelistedDimensions = Lists.newArrayList((Object[])new String[]{"minecraft:overworld"});
    public static List<String> blacklistedBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:ocean", "minecraft:frozen_ocean", "minecraft:deep_ocean", "minecraft:warm_ocean", "minecraft:lukewarm_ocean", "minecraft:cold_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:deep_cold_ocean", "minecraft:deep_frozen_ocean", "minecraft:beach", "minecraft:snowy_beach", "minecraft:river", "minecraft:frozen_river"});
    private static final List<MobSpawnInfo.Spawners> STRUCTURE_MONSTERS = ImmutableList.of((Object)new MobSpawnInfo.Spawners(EntityType.field_200725_aD, 100, 4, 15));

    public ZombieDungeonStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.UNDERGROUND_STRUCTURES;
    }

    public List<MobSpawnInfo.Spawners> getDefaultSpawnList() {
        return STRUCTURE_MONSTERS;
    }

    public boolean getDefaultRestrictsSpawnsToInside() {
        return true;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void func_230364_a_(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            int x = (chunkX << 4) + 7;
            int z = (chunkZ << 4) + 7;
            int minY = (Integer)BDConfig.zombieDungeons.zombieDungeonStartMinY.get();
            int maxY = (Integer)BDConfig.zombieDungeons.zombieDungeonStartMaxY.get();
            int y = this.field_214631_d.nextInt(maxY - minY) + minY;
            BlockPos blockpos = new BlockPos(x, y, z);
            YungJigsawConfig jigsawConfig = new YungJigsawConfig(() -> (JigsawPattern)dynamicRegistryManager.func_243612_b(Registry.field_243555_ax).func_82594_a(new ResourceLocation("betterdungeons", "zombie_dungeon")), 20);
            YungJigsawManager.assembleJigsawStructure((DynamicRegistries)dynamicRegistryManager, (YungJigsawConfig)jigsawConfig, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)blockpos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)false);
            this.func_202500_a();
            BetterDungeons.LOGGER.debug("Zombie Dungeon at {} {} {}", (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a, (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78895_b, (Object)((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

