/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructurePieces;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.piece.SpiderDungeonPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class SpiderDungeonEggRoomPiece
extends SpiderDungeonPiece {
    private final BlockPos startPos;
    private float xRadius = 0.0f;
    private float yRadius = 0.0f;
    private float zRadius = 0.0f;
    private static final float X_MINRADIUS = 2.0f;
    private static final float X_MAXRADIUS = 3.0f;
    private static final float Y_MINRADIUS = 2.0f;
    private static final float Y_MAXRADIUS = 3.0f;
    private static final float Z_MINRADIUS = 2.0f;
    private static final float Z_MAXRADIUS = 3.0f;
    private static final BlockSetSelector WOOL_SELECTOR = BlockSetSelector.from((BlockState[])new BlockState[]{Blocks.field_196556_aL.func_176223_P()});
    private static final BlockSetSelector COBWEB_SELECTOR = BlockSetSelector.from((BlockState[])new BlockState[]{Blocks.field_196553_aF.func_176223_P()});

    public SpiderDungeonEggRoomPiece(BlockPos startPos, int pieceChainLength) {
        super(BDModStructurePieces.SPIDER_DUNGEON_EGG_ROOM_PIECE, pieceChainLength);
        this.field_74887_e = new MutableBoundingBox(startPos.func_177958_n() - 64, 1, startPos.func_177952_p() - 64, startPos.func_177958_n() + 64, 256, startPos.func_177952_p() + 64);
        this.startPos = new BlockPos((Vector3i)startPos);
    }

    public SpiderDungeonEggRoomPiece(TemplateManager templateManager, CompoundNBT compoundNBT) {
        super(BDModStructurePieces.SPIDER_DUNGEON_EGG_ROOM_PIECE, compoundNBT);
        int[] start = compoundNBT.func_74759_k("startPos");
        this.startPos = new BlockPos(start[0], start[1], start[2]);
        this.xRadius = compoundNBT.func_74760_g("xRadius");
        this.yRadius = compoundNBT.func_74760_g("yRadius");
        this.zRadius = compoundNBT.func_74760_g("zRadius");
    }

    @ParametersAreNonnullByDefault
    protected void func_143011_b(CompoundNBT tagCompound) {
        tagCompound.func_74783_a("startPos", new int[]{this.startPos.func_177958_n(), this.startPos.func_177956_o(), this.startPos.func_177952_p()});
        tagCompound.func_74776_a("xRadius", this.xRadius);
        tagCompound.func_74776_a("yRadius", this.yRadius);
        tagCompound.func_74776_a("zRadius", this.zRadius);
    }

    @ParametersAreNonnullByDefault
    public void func_74861_a(StructurePiece piece, List<StructurePiece> pieceList, Random rand) {
        this.xRadius = rand.nextFloat() * 1.0f + 2.0f;
        this.yRadius = rand.nextFloat() * 1.0f + 2.0f;
        this.zRadius = rand.nextFloat() * 1.0f + 2.0f;
        this.field_74887_e.field_78897_a = this.startPos.func_177958_n() - (int)this.xRadius - 4;
        this.field_74887_e.field_78893_d = this.startPos.func_177958_n() + (int)this.xRadius + 4;
        this.field_74887_e.field_78895_b = this.startPos.func_177956_o() - (int)this.yRadius - 4;
        this.field_74887_e.field_78894_e = this.startPos.func_177956_o() + (int)this.yRadius + 4;
        this.field_74887_e.field_78896_c = this.startPos.func_177952_p() - (int)this.zRadius - 4;
        this.field_74887_e.field_78892_f = this.startPos.func_177952_p() + (int)this.zRadius + 4;
    }

    @ParametersAreNonnullByDefault
    public boolean func_230383_a_(ISeedReader world, StructureManager structureManager, ChunkGenerator chunkGenerator, Random random, MutableBoundingBox box, ChunkPos chunkPos, BlockPos blockPos) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        SharedSeedRandom decoRand = new SharedSeedRandom();
        decoRand.func_202424_a(world.func_72905_C(), this.startPos.func_177958_n(), this.startPos.func_177952_p());
        BitSet carvingMask = new BitSet(65536);
        int[] surface = new int[256];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(chunkPos.func_180334_c() + x, 1, chunkPos.func_180333_d() + z);
                surface[x * 16 + z] = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)mutable).func_177956_o();
            }
        }
        float caveStartX = this.startPos.func_177958_n();
        float caveStartY = this.startPos.func_177956_o();
        float caveStartZ = this.startPos.func_177952_p();
        int minX = MathHelper.func_76141_d((float)(caveStartX - this.xRadius)) - chunkPos.field_77276_a * 16 - 1;
        int maxX = MathHelper.func_76141_d((float)(caveStartX + this.xRadius)) - chunkPos.field_77276_a * 16 + 1;
        int minY = MathHelper.func_76125_a((int)(MathHelper.func_76141_d((float)(caveStartY - this.yRadius)) - 1), (int)0, (int)255);
        int maxY = MathHelper.func_76125_a((int)(MathHelper.func_76141_d((float)(caveStartY + this.yRadius)) + 1), (int)0, (int)255);
        int minZ = MathHelper.func_76141_d((float)(caveStartZ - this.zRadius)) - chunkPos.field_77275_b * 16 - 1;
        int maxZ = MathHelper.func_76141_d((float)(caveStartZ + this.zRadius)) - chunkPos.field_77275_b * 16 + 1;
        minX = MathHelper.func_76125_a((int)minX, (int)0, (int)15);
        maxX = MathHelper.func_76125_a((int)maxX, (int)0, (int)15);
        minZ = MathHelper.func_76125_a((int)minZ, (int)0, (int)15);
        maxZ = MathHelper.func_76125_a((int)maxZ, (int)0, (int)15);
        for (float x = (float)minX; x <= (float)maxX; x += 1.0f) {
            int globalX = (int)x + chunkPos.field_77276_a * 16;
            if (globalX < chunkPos.func_180334_c() || globalX > chunkPos.func_180332_e()) continue;
            float radialXDist = ((float)globalX - caveStartX + 0.5f) / this.xRadius;
            for (float z = (float)minZ; z <= (float)maxZ; z += 1.0f) {
                int globalY;
                int globalZ = (int)z + chunkPos.field_77275_b * 16;
                if (globalZ < chunkPos.func_180333_d() || globalZ > chunkPos.func_180330_f()) continue;
                float radialZDist = ((float)globalZ - caveStartZ + 0.5f) / this.zRadius;
                for (float y = (float)minY; y <= (float)maxY && (globalY = (int)y) <= surface[(int)x % 16 * 16 + (int)z % 16]; y += 1.0f) {
                    BlockState state;
                    float radialYDist = (y - caveStartY - 0.5f) / this.yRadius;
                    int mask = (int)x | (int)z << 4 | (int)y << 8;
                    float radialDist = radialXDist * radialXDist + radialYDist * radialYDist + radialZDist * radialZDist;
                    if ((double)radialDist < 1.0) {
                        if (carvingMask.get(mask) || BLOCK_BLACKLIST.contains(this.func_175807_a((IBlockReader)world, globalX, globalY, globalZ, box).func_177230_c())) continue;
                        this.func_175811_a(world, Blocks.field_201941_jj.func_176223_P(), globalX, globalY, globalZ, box);
                        carvingMask.set(mask);
                        continue;
                    }
                    float radialXDistShell = ((float)globalX - caveStartX + 0.5f) / (this.xRadius + 1.2f);
                    float radialYDistShell = (y - caveStartY - 0.5f) / (this.yRadius + 1.2f);
                    float radialZDistShell = ((float)globalZ - caveStartZ + 0.5f) / (this.zRadius + 1.2f);
                    float radialDistShell = radialXDistShell * radialXDistShell + radialYDistShell * radialYDistShell + radialZDistShell * radialZDistShell;
                    if (!((double)radialDistShell < 1.0) || carvingMask.get(mask) || BLOCK_BLACKLIST.contains((state = this.func_175807_a((IBlockReader)world, globalX, globalY, globalZ, box)).func_177230_c()) || state.func_185904_a() == Material.field_151579_a || !state.func_196958_f() && state.func_204520_s().func_206886_c() == Fluids.field_204541_a && !(decoRand.nextFloat() < 0.8f)) continue;
                    this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), globalX, globalY, globalZ, box);
                }
            }
        }
        BlockPos chestPos = new BlockPos((int)caveStartX, (int)caveStartY - (int)this.yRadius + 1, (int)caveStartZ);
        this.placeSphereRandomized(world, box, chestPos, 2.0f, (Random)decoRand, 0.5f, WOOL_SELECTOR, false);
        this.func_175811_a(world, Blocks.field_196556_aL.func_176223_P(), chestPos.func_177958_n() + 1, chestPos.func_177956_o(), chestPos.func_177952_p(), box);
        this.func_175811_a(world, Blocks.field_196556_aL.func_176223_P(), chestPos.func_177958_n() - 1, chestPos.func_177956_o(), chestPos.func_177952_p(), box);
        this.func_175811_a(world, Blocks.field_196556_aL.func_176223_P(), chestPos.func_177958_n(), chestPos.func_177956_o(), chestPos.func_177952_p() + 1, box);
        this.func_175811_a(world, Blocks.field_196556_aL.func_176223_P(), chestPos.func_177958_n(), chestPos.func_177956_o(), chestPos.func_177952_p() - 1, box);
        this.func_175811_a(world, Blocks.field_196556_aL.func_176223_P(), chestPos.func_177958_n(), chestPos.func_177956_o() - 1, chestPos.func_177952_p(), box);
        this.func_175811_a(world, Blocks.field_196556_aL.func_176223_P(), chestPos.func_177958_n(), chestPos.func_177956_o() + 1, chestPos.func_177952_p(), box);
        this.placeSphereRandomized(world, box, chestPos.func_177958_n(), chestPos.func_177956_o(), chestPos.func_177952_p(), 2.0f, (Random)decoRand, 0.4f, COBWEB_SELECTOR, true);
        if (random.nextFloat() < 0.6f) {
            this.func_186167_a(world, box, random, chestPos.func_177958_n(), chestPos.func_177956_o(), chestPos.func_177952_p(), new ResourceLocation("betterdungeons", "spider_dungeon/chests/egg_room"));
        } else if (box.func_175898_b((Vector3i)chestPos)) {
            this.func_175811_a(world, Blocks.field_150474_ac.func_176223_P(), chestPos.func_177958_n(), chestPos.func_177956_o(), chestPos.func_177952_p(), box);
            TileEntity spawnerTileEntity = world.func_175625_s(chestPos);
            if (spawnerTileEntity instanceof MobSpawnerTileEntity) {
                ((MobSpawnerTileEntity)spawnerTileEntity).func_145881_a().func_200876_a(EntityType.field_200748_an);
            } else {
                BetterDungeons.LOGGER.warn("Expected spider spawner entity at {}, but found none!", (Object)chestPos);
            }
        }
        this.decorateCave(world, (Random)decoRand, chunkPos, box, carvingMask);
        return true;
    }
}

