/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.world.processor.zombie_dungeon;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModProcessors;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import java.util.HashSet;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;

@MethodsReturnNonnullByDefault
public class ZombieMainStairsProcessor
extends StructureProcessor {
    public static final ZombieMainStairsProcessor INSTANCE = new ZombieMainStairsProcessor();
    public static final Codec<ZombieMainStairsProcessor> CODEC = Codec.unit(() -> INSTANCE);
    private static final BlockSetSelector STAIR_SELECTOR = new BlockSetSelector(Blocks.field_196659_cl.func_176223_P()).addBlock(Blocks.field_222411_kZ.func_176223_P(), 0.4f).addBlock(Blocks.field_196646_bz.func_176223_P(), 0.1f).addBlock(Blocks.field_222450_ln.func_176223_P(), 0.1f).addBlock(Blocks.field_201941_jj.func_176223_P(), 0.1f).addBlock(Blocks.field_150347_e.func_176223_P(), 0.1f).addBlock(Blocks.field_150341_Y.func_176223_P(), 0.1f);
    private static final BlockSetSelector COBBLE_SELECTOR = new BlockSetSelector(Blocks.field_150347_e.func_176223_P()).addBlock(Blocks.field_150341_Y.func_176223_P(), 0.3f);

    @ParametersAreNonnullByDefault
    public Template.BlockInfo process(IWorldReader world, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, Template.BlockInfo blockInfoLocal, Template.BlockInfo blockInfoGlobal, PlacementSettings structurePlacementData, @Nullable Template template) {
        if (blockInfoGlobal.field_186243_b.func_177230_c() == Blocks.field_235357_mP_) {
            BlockState lanternBlock;
            int middleSurfaceHeight;
            Direction facing;
            switch (structurePlacementData.func_186215_c()) {
                case CLOCKWISE_90: {
                    facing = Direction.EAST;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    facing = Direction.WEST;
                    break;
                }
                case CLOCKWISE_180: {
                    facing = Direction.SOUTH;
                    break;
                }
                default: {
                    facing = Direction.NORTH;
                }
            }
            int maxLength = (Integer)BDConfig.zombieDungeons.zombieDungeonMaxSurfaceStaircaseLength.get();
            BlockPos maxSurfacePos = blockInfoGlobal.field_186242_a.func_177967_a(facing, maxLength).func_177967_a(Direction.UP, maxLength);
            int surfaceHeight = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, blockInfoGlobal.field_186242_a.func_177967_a(facing, maxLength)).func_177956_o();
            if (surfaceHeight >= maxSurfacePos.func_177956_o()) {
                blockInfoGlobal = new Template.BlockInfo(blockInfoGlobal.field_186242_a, Blocks.field_201941_jj.func_176223_P(), blockInfoGlobal.field_186244_c);
                return blockInfoGlobal;
            }
            Random random = structurePlacementData.func_189947_a(blockInfoGlobal.field_186242_a);
            BlockPos.Mutable leftPos = new BlockPos((Vector3i)blockInfoGlobal.field_186242_a.func_177972_a(facing.func_176735_f())).func_239590_i_();
            BlockPos.Mutable middlePos = new BlockPos((Vector3i)blockInfoGlobal.field_186242_a).func_239590_i_();
            BlockPos.Mutable rightPos = new BlockPos((Vector3i)blockInfoGlobal.field_186242_a.func_177972_a(facing.func_176746_e())).func_239590_i_();
            BlockPos.Mutable temp = new BlockPos.Mutable();
            for (int i = 0; i < maxLength && (middleSurfaceHeight = world.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, (BlockPos)middlePos).func_177956_o()) >= middlePos.func_177956_o(); ++i) {
                int y;
                BlockState tempBlock = STAIR_SELECTOR.get(random);
                if (!world.func_180495_p((BlockPos)leftPos).func_196958_f()) {
                    if (world.func_180495_p(leftPos.func_177972_a(facing)).func_185904_a().func_76224_d()) {
                        this.setBlockState(world, Blocks.field_150347_e.func_176223_P(), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    } else {
                        this.setBlockState(world, tempBlock, (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!world.func_180495_p((BlockPos)middlePos).func_196958_f()) {
                    if (world.func_180495_p(middlePos.func_177972_a(facing)).func_185904_a().func_76224_d()) {
                        this.setBlockState(world, Blocks.field_150347_e.func_176223_P(), (BlockPos)middlePos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    } else {
                        this.setBlockState(world, tempBlock, (BlockPos)middlePos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    }
                }
                tempBlock = STAIR_SELECTOR.get(random);
                if (!world.func_180495_p((BlockPos)rightPos).func_196958_f()) {
                    if (world.func_180495_p(rightPos.func_177972_a(facing)).func_185904_a().func_76224_d()) {
                        this.setBlockState(world, Blocks.field_150347_e.func_176223_P(), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    } else {
                        this.setBlockState(world, tempBlock, (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    }
                }
                for (int y2 = middlePos.func_177956_o() + 1; y2 <= middlePos.func_177956_o() + 3; ++y2) {
                    temp.func_181079_c(leftPos.func_177958_n(), y2, leftPos.func_177952_p());
                    this.setBlockState(world, Blocks.field_201941_jj.func_176223_P(), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    temp.func_181079_c(middlePos.func_177958_n(), y2, middlePos.func_177952_p());
                    this.setBlockState(world, Blocks.field_201941_jj.func_176223_P(), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    temp.func_181079_c(rightPos.func_177958_n(), y2, rightPos.func_177952_p());
                    this.setBlockState(world, Blocks.field_201941_jj.func_176223_P(), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                }
                float cobbleChance = (float)(maxLength - i) / (float)maxLength;
                cobbleChance = Math.max(cobbleChance, 0.25f);
                HashSet replaceableBlocks = Sets.newHashSet((Object[])new BlockState[]{world.func_226691_t_((BlockPos)leftPos).func_242440_e().func_242502_e().func_204108_a(), world.func_226691_t_((BlockPos)leftPos).func_242440_e().func_242502_e().func_204109_b(), world.func_226691_t_((BlockPos)middlePos).func_242440_e().func_242502_e().func_204108_a(), world.func_226691_t_((BlockPos)middlePos).func_242440_e().func_242502_e().func_204109_b(), world.func_226691_t_((BlockPos)rightPos).func_242440_e().func_242502_e().func_204108_a(), world.func_226691_t_((BlockPos)rightPos).func_242440_e().func_242502_e().func_204109_b(), world.func_226691_t_(leftPos.func_177972_a(facing.func_176735_f())).func_242440_e().func_242502_e().func_204108_a(), world.func_226691_t_(leftPos.func_177972_a(facing.func_176735_f())).func_242440_e().func_242502_e().func_204109_b(), world.func_226691_t_(rightPos.func_177972_a(facing.func_176746_e())).func_242440_e().func_242502_e().func_204108_a(), world.func_226691_t_(rightPos.func_177972_a(facing.func_176746_e())).func_242440_e().func_242502_e().func_204109_b()});
                HashSet replaceableMaterials = Sets.newHashSet((Object[])new Material[]{Material.field_151576_e, Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151588_w});
                temp.func_181079_c(leftPos.func_177958_n(), leftPos.func_177956_o() + 4, leftPos.func_177952_p());
                tempBlock = world.func_180495_p((BlockPos)temp);
                if (tempBlock.func_185904_a().func_76224_d() || random.nextFloat() < cobbleChance && (replaceableMaterials.contains(tempBlock.func_185904_a()) || replaceableBlocks.contains(tempBlock))) {
                    this.setBlockState(world, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                }
                temp.func_181079_c(middlePos.func_177958_n(), middlePos.func_177956_o() + 4, middlePos.func_177952_p());
                tempBlock = world.func_180495_p((BlockPos)temp);
                if (tempBlock.func_185904_a().func_76224_d() || random.nextFloat() < cobbleChance && (replaceableMaterials.contains(tempBlock.func_185904_a()) || replaceableBlocks.contains(tempBlock))) {
                    this.setBlockState(world, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                }
                temp.func_181079_c(rightPos.func_177958_n(), rightPos.func_177956_o() + 4, rightPos.func_177952_p());
                tempBlock = world.func_180495_p((BlockPos)temp);
                if (tempBlock.func_185904_a().func_76224_d() || random.nextFloat() < cobbleChance && (replaceableMaterials.contains(tempBlock.func_185904_a()) || replaceableBlocks.contains(tempBlock))) {
                    this.setBlockState(world, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                }
                temp.func_189533_g((Vector3i)leftPos.func_177972_a(facing.func_176735_f()));
                for (y = 0; y <= 4; ++y) {
                    tempBlock = world.func_180495_p((BlockPos)temp);
                    if (tempBlock.func_185904_a().func_76224_d() || random.nextFloat() < cobbleChance && (replaceableMaterials.contains(tempBlock.func_185904_a()) || replaceableBlocks.contains(tempBlock))) {
                        this.setBlockState(world, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    }
                    temp.func_189536_c(Direction.UP);
                }
                temp.func_189533_g((Vector3i)rightPos.func_177972_a(facing.func_176746_e()));
                for (y = 0; y <= 4; ++y) {
                    tempBlock = world.func_180495_p((BlockPos)temp);
                    if (tempBlock.func_185904_a().func_76224_d() || random.nextFloat() < cobbleChance && (replaceableMaterials.contains(tempBlock.func_185904_a()) || replaceableBlocks.contains(tempBlock))) {
                        this.setBlockState(world, COBBLE_SELECTOR.get(random), (BlockPos)temp, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
                    }
                    temp.func_189536_c(Direction.UP);
                }
                leftPos.func_189536_c(facing).func_189536_c(Direction.UP);
                middlePos.func_189536_c(facing).func_189536_c(Direction.UP);
                rightPos.func_189536_c(facing).func_189536_c(Direction.UP);
            }
            leftPos.func_189536_c(facing.func_176734_d()).func_189536_c(Direction.DOWN);
            middlePos.func_189536_c(facing.func_176734_d()).func_189536_c(Direction.DOWN);
            rightPos.func_189536_c(facing.func_176734_d()).func_189536_c(Direction.DOWN);
            BlockSetSelector tombSelector = new BlockSetSelector(Blocks.field_150347_e.func_176223_P()).addBlock(Blocks.field_150341_Y.func_176223_P(), 0.3f).addBlock(world.func_226691_t_((BlockPos)middlePos).func_242440_e().func_242502_e().func_204109_b(), 0.3f);
            this.setBlockState(world, Blocks.field_222401_hJ.func_176223_P(), leftPos.func_177967_a(Direction.UP, 2), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_222401_hJ.func_176223_P(), middlePos.func_177967_a(Direction.UP, 2), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_222401_hJ.func_176223_P(), rightPos.func_177967_a(Direction.UP, 2), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_196579_bG.func_176223_P(), leftPos.func_177967_a(Direction.UP, 3), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_196579_bG.func_176223_P(), middlePos.func_177967_a(Direction.UP, 3), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_196579_bG.func_176223_P(), rightPos.func_177967_a(Direction.UP, 3), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            BlockState blockState = lanternBlock = (Boolean)BDConfig.general.enableNetherBlocks.get() != false ? (BlockState)Blocks.field_235366_md_.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)) : (BlockState)Blocks.field_222432_lU.func_176223_P().func_206870_a((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true));
            if (random.nextFloat() < 0.25f) {
                this.setBlockState(world, lanternBlock, leftPos.func_177967_a(Direction.UP, 1), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            } else if (random.nextFloat() < 0.25f) {
                this.setBlockState(world, lanternBlock, rightPos.func_177967_a(Direction.UP, 1), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            }
            leftPos.func_189536_c(facing.func_176735_f());
            rightPos.func_189536_c(facing.func_176746_e());
            this.setColumn(world, tombSelector, leftPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setColumn(world, tombSelector, rightPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setBlockState(world, Blocks.field_196657_h.func_176223_P(), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_196657_h.func_176223_P(), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockState(world, Blocks.field_196657_h.func_176223_P(), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_196657_h.func_176223_P(), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockState(world, Blocks.field_196579_bG.func_176223_P(), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, Blocks.field_196579_bG.func_176223_P(), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockStateRandom(world, Blocks.field_196579_bG.func_176223_P(), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            this.setBlockStateRandom(world, Blocks.field_196579_bG.func_176223_P(), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            leftPos.func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(facing.func_176734_d());
            rightPos.func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(facing.func_176734_d());
            this.setColumn(world, tombSelector, leftPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setColumn(world, tombSelector, rightPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setBlockState(world, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockState(world, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockStateRandom(world, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            this.setBlockStateRandom(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            leftPos.func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(facing.func_176734_d());
            rightPos.func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(facing.func_176734_d());
            this.setColumn(world, tombSelector, leftPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setColumn(world, tombSelector, rightPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setBlockState(world, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            this.setBlockState(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockStateRandom(world, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            this.setBlockState(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockStateRandom(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            leftPos.func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(facing.func_176734_d());
            rightPos.func_189536_c(Direction.DOWN).func_189536_c(Direction.DOWN).func_189536_c(facing.func_176734_d());
            this.setColumn(world, tombSelector, leftPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setColumn(world, tombSelector, rightPos.func_177972_a(Direction.DOWN), structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random);
            this.setBlockStateRandom(world, tombSelector.get(random), (BlockPos)leftPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            this.setBlockState(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c());
            leftPos.func_189536_c(Direction.UP);
            rightPos.func_189536_c(Direction.UP);
            this.setBlockStateRandom(world, tombSelector.get(random), (BlockPos)rightPos, structurePlacementData.func_186212_b(), structurePlacementData.func_186215_c(), random, 0.5f);
            blockInfoGlobal = new Template.BlockInfo(blockInfoGlobal.field_186242_a, STAIR_SELECTOR.get(random), blockInfoGlobal.field_186244_c);
        }
        return blockInfoGlobal;
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return BDModProcessors.ZOMBIE_MAIN_STAIRS_PROCESSOR;
    }

    private void setBlockState(IWorldReader world, BlockState blockState, BlockPos pos, Mirror mirror, Rotation rotation) {
        if (mirror != Mirror.NONE) {
            blockState = blockState.func_185902_a(mirror);
        }
        if (rotation != Rotation.NONE) {
            blockState = blockState.func_185907_a(rotation);
        }
        world.func_217349_x(pos).func_177436_a(pos, blockState, false);
    }

    private void setBlockStateRandom(IWorldReader world, BlockState blockState, BlockPos pos, Mirror mirror, Rotation rotation, Random random, float chance) {
        if (random.nextFloat() < chance) {
            this.setBlockState(world, blockState, pos, mirror, rotation);
        }
    }

    private void setColumn(IWorldReader world, BlockSetSelector selector, BlockPos pos, Mirror mirror, Rotation rotation, Random random) {
        ChunkPos currentChunkPos = new ChunkPos(pos);
        IChunk currentChunk = world.func_212866_a_(currentChunkPos.field_77276_a, currentChunkPos.field_77275_b);
        BlockPos.Mutable mutable = pos.func_239590_i_();
        BlockState currBlock = world.func_180495_p((BlockPos)mutable);
        while (mutable.func_177956_o() > 0 && (currBlock.func_185904_a() == Material.field_151579_a || currBlock.func_185904_a() == Material.field_151586_h || currBlock.func_185904_a() == Material.field_151587_i)) {
            currentChunk.func_177436_a((BlockPos)mutable, selector.get(random), false);
            mutable.func_189536_c(Direction.DOWN);
            currBlock = world.func_180495_p((BlockPos)mutable);
        }
    }
}

