/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.init;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.skeleton_dungeon.SkeletonDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.small_dungeon.SmallDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.SpiderDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon.ZombieDungeonStructure;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class BDModConfig {
    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, BDConfig.SPEC, "betterdungeons-forge-1_16.toml");
        FMLJavaModLoadingContext.get().getModEventBus().addListener(BDModConfig::configChanged);
    }

    private static void configChanged(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == BDConfig.SPEC) {
            int separation;
            SmallDungeonStructure.whitelistedDimensions = BDModConfig.createDimensionWhitelist(BDConfig.smallDungeons.whitelistedDimensions, SmallDungeonStructure.whitelistedDimensions);
            SpiderDungeonStructure.whitelistedDimensions = BDModConfig.createDimensionWhitelist(BDConfig.spiderDungeons.whitelistedDimensions, SpiderDungeonStructure.whitelistedDimensions);
            SkeletonDungeonStructure.whitelistedDimensions = BDModConfig.createDimensionWhitelist(BDConfig.skeletonDungeons.whitelistedDimensions, SkeletonDungeonStructure.whitelistedDimensions);
            ZombieDungeonStructure.whitelistedDimensions = BDModConfig.createDimensionWhitelist(BDConfig.zombieDungeons.whitelistedDimensions, ZombieDungeonStructure.whitelistedDimensions);
            SmallDungeonStructure.blacklistedBiomes = BDModConfig.createBiomeBlacklist(BDConfig.smallDungeons.blacklistedBiomes, SmallDungeonStructure.blacklistedBiomes);
            SpiderDungeonStructure.blacklistedBiomes = BDModConfig.createBiomeBlacklist(BDConfig.spiderDungeons.blacklistedBiomes, SpiderDungeonStructure.blacklistedBiomes);
            SkeletonDungeonStructure.blacklistedBiomes = BDModConfig.createBiomeBlacklist(BDConfig.skeletonDungeons.blacklistedBiomes, SkeletonDungeonStructure.blacklistedBiomes);
            ZombieDungeonStructure.blacklistedBiomes = BDModConfig.createBiomeBlacklist(BDConfig.zombieDungeons.blacklistedBiomes, ZombieDungeonStructure.blacklistedBiomes);
            int spacing = (Integer)BDConfig.smallDungeons.smallDungeonSeparationDistance.get();
            if (spacing < (separation = ((Integer)BDConfig.smallDungeons.smallDungeonDistanceVariation.get()).intValue())) {
                BetterDungeons.LOGGER.error("Small Dungeon Average Separation Distance cannot be less than Small Dungeon Separation Distance Variation!");
                BetterDungeons.LOGGER.error("Found: {} and {}", (Object)spacing, (Object)separation);
                BetterDungeons.LOGGER.error("Using default values instead...");
                BDConfig.smallDungeons.smallDungeonSeparationDistance.set((Object)10);
                BDConfig.smallDungeons.smallDungeonDistanceVariation.set((Object)6);
            }
        }
    }

    private static List<String> createDimensionWhitelist(ForgeConfigSpec.ConfigValue<String> dimWhitelistConfig, List<String> defaultList) {
        String rawStringofList = (String)dimWhitelistConfig.get();
        int strLen = rawStringofList.length();
        if (strLen < 2 || rawStringofList.charAt(0) != '[' || rawStringofList.charAt(strLen - 1) != ']') {
            BetterDungeons.LOGGER.error("INVALID VALUE FOR SETTING 'Whitelisted Dimensions'. Using [minecraft:overworld] instead...");
            return defaultList;
        }
        return Lists.newArrayList((Object[])rawStringofList.substring(1, strLen - 1).split(",\\s*"));
    }

    private static List<String> createBiomeBlacklist(ForgeConfigSpec.ConfigValue<String> biomeBlacklistConfig, List<String> defaultList) {
        String rawStringofList = (String)biomeBlacklistConfig.get();
        int strLen = rawStringofList.length();
        if (strLen < 2 || rawStringofList.charAt(0) != '[' || rawStringofList.charAt(strLen - 1) != ']') {
            BetterDungeons.LOGGER.error("INVALID VALUE FOR SETTING 'Blacklisted Biomes'. Using default instead...");
            return defaultList;
        }
        return Lists.newArrayList((Object[])rawStringofList.substring(1, strLen - 1).split(",\\s*"));
    }
}

