/*
 * Decompiled with CFR 0.152.
 */
package com.lclc98.pokehaancraftables.item;

import com.lclc98.pokehaancraftables.PokehaanCraftables;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.StatueEvent;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.data.PixelmonPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreenPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.statueEditor.UpdateClientEditingStatuePacket;
import com.pixelmonmod.pixelmon.entities.pixelmon.StatueEntity;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.Event;

public class CustomChiselItem
extends Item {
    public CustomChiselItem() {
        super(new Item.Properties().func_200916_a(PokehaanCraftables.TABS).func_200917_a(1));
        this.setRegistryName("chisel");
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Direction side = context.func_196000_l();
        if (side != Direction.UP) {
            return ActionResultType.FAIL;
        }
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Vector3d hitVec = context.func_221532_j();
        if (!world.field_72995_K) {
            if (!CustomChiselItem.checkPermission((ServerPlayerEntity)player)) {
                return ActionResultType.FAIL;
            }
            StatueEntity statue = new StatueEntity(world);
            Species pokemon = player.func_225608_bj_() && player.func_184812_l_() ? PixelmonSpecies.getRandomSpecies() : (Species)PixelmonSpecies.BULBASAUR.getValueUnsafe();
            statue.setPokemon(PokemonFactory.create((Species)pokemon));
            statue.func_70107_b(hitVec.field_72450_a, (double)(pos.func_177956_o() + 1), hitVec.field_72449_c);
            StatueEvent.CreateStatue createStatueEvent = new StatueEvent.CreateStatue((ServerPlayerEntity)player, (ServerWorld)world, pos, statue);
            if (Pixelmon.EVENT_BUS.post((Event)createStatueEvent)) {
                return ActionResultType.FAIL;
            }
            statue = createStatueEvent.getStatue();
            statue.field_70177_z = statue.field_70759_as = player.field_70177_z + 180.0f;
            world.func_217376_c((Entity)statue);
            NetworkHelper.sendPacket((PixelmonPacket)new UpdateClientEditingStatuePacket(statue.func_110124_au()), (ServerPlayerEntity)((ServerPlayerEntity)player));
            OpenScreenPacket.open((PlayerEntity)player, (EnumGuiScreen)EnumGuiScreen.StatueEditor, (int[])new int[]{statue.func_145782_y()});
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (entity instanceof StatueEntity && !player.field_70170_p.field_72995_K && !Pixelmon.EVENT_BUS.post((Event)new StatueEvent.DestroyStatue((ServerPlayerEntity)player, (StatueEntity)entity))) {
            entity.func_70106_y();
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public ITextComponent func_200295_i(ItemStack p_200295_1_) {
        return new TranslationTextComponent("item.pixelmon.chisel");
    }

    public boolean func_77636_d(ItemStack p_77636_1_) {
        return true;
    }

    public static boolean checkPermission(ServerPlayerEntity editingPlayer) {
        if (PixelmonConfigProxy.getGeneral().isAllowChisels()) {
            return true;
        }
        ChatHandler.sendChat((Entity)editingPlayer, (String)"gui.chisel.notallowedserver", (Object[])new Object[0]);
        return false;
    }
}

