/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.MovingPistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.PistonTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;

public class PistonBlock
extends DirectionalBlock {
    public static final BooleanProperty field_176320_b = BlockStateProperties.field_208181_h;
    protected static final VoxelShape field_185648_b = Block.func_208617_a(0.0, 0.0, 0.0, 12.0, 16.0, 16.0);
    protected static final VoxelShape field_185649_c = Block.func_208617_a(4.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185650_d = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 12.0);
    protected static final VoxelShape field_185651_e = Block.func_208617_a(0.0, 0.0, 4.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185652_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0);
    protected static final VoxelShape field_185653_g = Block.func_208617_a(0.0, 4.0, 0.0, 16.0, 16.0, 16.0);
    private final boolean field_150082_a;

    public PistonBlock(boolean p_i48281_1_, AbstractBlock.Properties p_i48281_2_) {
        super(p_i48281_2_);
        this.func_180632_j((BlockState)((Object)((BlockState)((Object)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_176387_N, (Comparable)((Object)Direction.NORTH)))).func_206870_a((Property)field_176320_b, Boolean.valueOf(false))));
        this.field_150082_a = p_i48281_1_;
    }

    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        if (((Boolean)p_220053_1_.func_177229_b((Property)field_176320_b)).booleanValue()) {
            switch ((Direction)((Object)p_220053_1_.func_177229_b((Property)field_176387_N))) {
                case DOWN: {
                    return field_185653_g;
                }
                default: {
                    return field_185652_f;
                }
                case NORTH: {
                    return field_185651_e;
                }
                case SOUTH: {
                    return field_185650_d;
                }
                case WEST: {
                    return field_185649_c;
                }
                case EAST: 
            }
            return field_185648_b;
        }
        return VoxelShapes.func_197868_b();
    }

    public void func_180633_a(World p_180633_1_, BlockPos p_180633_2_, BlockState p_180633_3_, LivingEntity p_180633_4_, ItemStack p_180633_5_) {
        if (!p_180633_1_.field_72995_K) {
            this.func_176316_e(p_180633_1_, p_180633_2_, p_180633_3_);
        }
    }

    public void func_220069_a(BlockState p_220069_1_, World p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (!p_220069_2_.field_72995_K) {
            this.func_176316_e(p_220069_2_, p_220069_3_, p_220069_1_);
        }
    }

    public void func_220082_b(BlockState p_220082_1_, World p_220082_2_, BlockPos p_220082_3_, BlockState p_220082_4_, boolean p_220082_5_) {
        if (!p_220082_4_.func_203425_a(p_220082_1_.func_177230_c()) && !p_220082_2_.field_72995_K && p_220082_2_.func_175625_s(p_220082_3_) == null) {
            this.func_176316_e(p_220082_2_, p_220082_3_, p_220082_1_);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext p_196258_1_) {
        return (BlockState)((Object)((BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)((Object)p_196258_1_.func_196010_d().func_176734_d())))).func_206870_a((Property)field_176320_b, Boolean.valueOf(false)));
    }

    private void func_176316_e(World p_176316_1_, BlockPos p_176316_2_, BlockState p_176316_3_) {
        Direction direction = (Direction)((Object)p_176316_3_.func_177229_b((Property)field_176387_N));
        boolean flag = this.func_176318_b(p_176316_1_, p_176316_2_, direction);
        if (flag && !((Boolean)p_176316_3_.func_177229_b((Property)field_176320_b)).booleanValue()) {
            if (new PistonBlockStructureHelper(p_176316_1_, p_176316_2_, direction, true).func_177253_a()) {
                p_176316_1_.func_175641_c(p_176316_2_, (Block)((Object)this), 0, direction.func_176745_a());
            }
        } else if (!flag && ((Boolean)p_176316_3_.func_177229_b((Property)field_176320_b)).booleanValue()) {
            PistonTileEntity pistontileentity;
            TileEntity tileentity;
            BlockPos blockpos = p_176316_2_.func_177967_a(direction, 2);
            BlockState blockstate = p_176316_1_.func_180495_p(blockpos);
            int i = 1;
            if (blockstate.func_203425_a(Blocks.field_196603_bb) && blockstate.func_177229_b((Property)field_176387_N) == direction && (tileentity = p_176316_1_.func_175625_s(blockpos)) instanceof PistonTileEntity && (pistontileentity = (PistonTileEntity)tileentity).func_145868_b() && (pistontileentity.func_145860_a(0.0f) < 0.5f || p_176316_1_.func_82737_E() == pistontileentity.func_211146_k() || ((ServerWorld)p_176316_1_).func_211158_j_())) {
                i = 2;
            }
            p_176316_1_.func_175641_c(p_176316_2_, (Block)((Object)this), i, direction.func_176745_a());
        }
    }

    private boolean func_176318_b(World p_176318_1_, BlockPos p_176318_2_, Direction p_176318_3_) {
        for (Direction direction : Direction.values()) {
            if (direction == p_176318_3_ || !p_176318_1_.func_175709_b(p_176318_2_.func_177972_a(direction), direction)) continue;
            return true;
        }
        if (p_176318_1_.func_175709_b(p_176318_2_, Direction.DOWN)) {
            return true;
        }
        BlockPos blockpos = p_176318_2_.func_177984_a();
        for (Direction direction1 : Direction.values()) {
            if (direction1 == Direction.DOWN || !p_176318_1_.func_175709_b(blockpos.func_177972_a(direction1), direction1)) continue;
            return true;
        }
        return false;
    }

    public boolean func_189539_a(BlockState p_189539_1_, World p_189539_2_, BlockPos p_189539_3_, int p_189539_4_, int p_189539_5_) {
        Direction direction = (Direction)((Object)p_189539_1_.func_177229_b((Property)field_176387_N));
        if (!p_189539_2_.field_72995_K) {
            boolean flag = this.func_176318_b(p_189539_2_, p_189539_3_, direction);
            if (flag && (p_189539_4_ == 1 || p_189539_4_ == 2)) {
                p_189539_2_.func_180501_a(p_189539_3_, (BlockState)((Object)p_189539_1_.func_206870_a((Property)field_176320_b, Boolean.valueOf(true))), 2);
                return false;
            }
            if (!flag && p_189539_4_ == 0) {
                return false;
            }
        }
        if (p_189539_4_ == 0) {
            if (ForgeEventFactory.onPistonMovePre((World)p_189539_2_, (BlockPos)p_189539_3_, (Direction)direction, (boolean)true)) {
                return false;
            }
            if (!this.func_176319_a(p_189539_2_, p_189539_3_, direction, true)) {
                return false;
            }
            p_189539_2_.func_180501_a(p_189539_3_, (BlockState)((Object)p_189539_1_.func_206870_a((Property)field_176320_b, Boolean.valueOf(true))), 67);
            p_189539_2_.func_184133_a(null, p_189539_3_, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 0.5f, p_189539_2_.field_73012_v.nextFloat() * 0.25f + 0.6f);
        } else if (p_189539_4_ == 1 || p_189539_4_ == 2) {
            if (ForgeEventFactory.onPistonMovePre((World)p_189539_2_, (BlockPos)p_189539_3_, (Direction)direction, (boolean)false)) {
                return false;
            }
            TileEntity tileentity1 = p_189539_2_.func_175625_s(p_189539_3_.func_177972_a(direction));
            if (tileentity1 instanceof PistonTileEntity) {
                ((PistonTileEntity)tileentity1).func_145866_f();
            }
            BlockState blockstate = (BlockState)((Object)((BlockState)((Object)Blocks.field_196603_bb.func_176223_P().func_206870_a((Property)MovingPistonBlock.field_196344_a, (Comparable)((Object)direction)))).func_206870_a((Property)MovingPistonBlock.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT)));
            p_189539_2_.func_180501_a(p_189539_3_, blockstate, 20);
            p_189539_2_.func_175690_a(p_189539_3_, MovingPistonBlock.func_196343_a((BlockState)((Object)this.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)((Object)Direction.func_82600_a(p_189539_5_ & 7)))), direction, false, true));
            p_189539_2_.func_230547_a_(p_189539_3_, blockstate.func_177230_c());
            blockstate.func_235734_a_(p_189539_2_, p_189539_3_, 2);
            if (this.field_150082_a) {
                PistonTileEntity pistontileentity;
                TileEntity tileentity;
                BlockPos blockpos = p_189539_3_.func_177982_a(direction.func_82601_c() * 2, direction.func_96559_d() * 2, direction.func_82599_e() * 2);
                BlockState blockstate1 = p_189539_2_.func_180495_p(blockpos);
                boolean flag1 = false;
                if (blockstate1.func_203425_a(Blocks.field_196603_bb) && (tileentity = p_189539_2_.func_175625_s(blockpos)) instanceof PistonTileEntity && (pistontileentity = (PistonTileEntity)tileentity).func_212363_d() == direction && pistontileentity.func_145868_b()) {
                    pistontileentity.func_145866_f();
                    flag1 = true;
                }
                if (!flag1) {
                    if (p_189539_4_ != 1 || blockstate1.func_196958_f() || !PistonBlock.func_185646_a(blockstate1, p_189539_2_, blockpos, direction.func_176734_d(), false, direction) || blockstate1.func_185905_o() != PushReaction.NORMAL && !blockstate1.func_203425_a(Blocks.field_150331_J) && !blockstate1.func_203425_a(Blocks.field_150320_F)) {
                        p_189539_2_.func_217377_a(p_189539_3_.func_177972_a(direction), false);
                    } else {
                        this.func_176319_a(p_189539_2_, p_189539_3_, direction, false);
                    }
                }
            } else {
                p_189539_2_.func_217377_a(p_189539_3_.func_177972_a(direction), false);
            }
            p_189539_2_.func_184133_a(null, p_189539_3_, SoundEvents.field_187712_dQ, SoundCategory.BLOCKS, 0.5f, p_189539_2_.field_73012_v.nextFloat() * 0.15f + 0.6f);
        }
        ForgeEventFactory.onPistonMovePost((World)p_189539_2_, (BlockPos)p_189539_3_, (Direction)direction, (p_189539_4_ == 0 ? 1 : 0) != 0);
        return true;
    }

    public static boolean func_185646_a(BlockState p_185646_0_, World p_185646_1_, BlockPos p_185646_2_, Direction p_185646_3_, boolean p_185646_4_, Direction p_185646_5_) {
        if (p_185646_2_.func_177956_o() >= 0 && p_185646_2_.func_177956_o() <= p_185646_1_.func_217301_I() - 1 && p_185646_1_.func_175723_af().func_177746_a(p_185646_2_)) {
            if (p_185646_0_.func_196958_f()) {
                return true;
            }
            if (!(p_185646_0_.func_203425_a(Blocks.field_150343_Z) || p_185646_0_.func_203425_a(Blocks.field_235399_ni_) || p_185646_0_.func_203425_a(Blocks.field_235400_nj_))) {
                if (p_185646_3_ == Direction.DOWN && p_185646_2_.func_177956_o() == 0) {
                    return false;
                }
                if (p_185646_3_ == Direction.UP && p_185646_2_.func_177956_o() == p_185646_1_.func_217301_I() - 1) {
                    return false;
                }
                if (!p_185646_0_.func_203425_a(Blocks.field_150331_J) && !p_185646_0_.func_203425_a(Blocks.field_150320_F)) {
                    if (p_185646_0_.func_185887_b((IBlockReader)((Object)p_185646_1_), p_185646_2_) == -1.0f) {
                        return false;
                    }
                    switch (p_185646_0_.func_185905_o()) {
                        case BLOCK: {
                            return false;
                        }
                        case DESTROY: {
                            return p_185646_4_;
                        }
                        case PUSH_ONLY: {
                            return p_185646_3_ == p_185646_5_;
                        }
                    }
                } else if (((Boolean)p_185646_0_.func_177229_b((Property)field_176320_b)).booleanValue()) {
                    return false;
                }
                return !p_185646_0_.hasTileEntity();
            }
            return false;
        }
        return false;
    }

    private boolean func_176319_a(World p_176319_1_, BlockPos p_176319_2_, Direction p_176319_3_, boolean p_176319_4_) {
        PistonBlockStructureHelper pistonblockstructurehelper;
        BlockPos blockpos = p_176319_2_.func_177972_a(p_176319_3_);
        if (!p_176319_4_ && p_176319_1_.func_180495_p(blockpos).func_203425_a(Blocks.field_150332_K)) {
            p_176319_1_.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(pistonblockstructurehelper = new PistonBlockStructureHelper(p_176319_1_, p_176319_2_, p_176319_3_, p_176319_4_)).func_177253_a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPos> list = pistonblockstructurehelper.func_177254_c();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos1 = list.get(i);
            BlockState blockstate = p_176319_1_.func_180495_p(blockpos1);
            list1.add(blockstate);
            map.put(blockpos1, blockstate);
        }
        List<BlockPos> list2 = pistonblockstructurehelper.func_177252_d();
        BlockState[] ablockstate = new BlockState[list.size() + list2.size()];
        Direction direction = p_176319_4_ ? p_176319_3_ : p_176319_3_.func_176734_d();
        int j = 0;
        for (int k = list2.size() - 1; k >= 0; --k) {
            BlockPos blockpos2 = list2.get(k);
            BlockState blockState = p_176319_1_.func_180495_p(blockpos2);
            TileEntity tileentity = blockState.hasTileEntity() ? p_176319_1_.func_175625_s(blockpos2) : null;
            PistonBlock.func_220059_a((BlockState)blockState, (IWorld)p_176319_1_, (BlockPos)blockpos2, (TileEntity)tileentity);
            p_176319_1_.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 18);
            ablockstate[j++] = blockState;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            BlockState blockState = p_176319_1_.func_180495_p(blockpos3);
            blockpos3 = blockpos3.func_177972_a(direction);
            map.remove(blockpos3);
            p_176319_1_.func_180501_a(blockpos3, (BlockState)((Object)Blocks.field_196603_bb.func_176223_P().func_206870_a((Property)field_176387_N, (Comparable)((Object)p_176319_3_))), 68);
            p_176319_1_.func_175690_a(blockpos3, MovingPistonBlock.func_196343_a((BlockState)((Object)list1.get(l)), p_176319_3_, p_176319_4_, false));
            ablockstate[j++] = blockState;
        }
        if (p_176319_4_) {
            PistonType pistontype = this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT;
            BlockState blockstate4 = (BlockState)((Object)((BlockState)((Object)Blocks.field_150332_K.func_176223_P().func_206870_a((Property)PistonHeadBlock.field_176387_N, (Comparable)((Object)p_176319_3_)))).func_206870_a((Property)PistonHeadBlock.field_176325_b, (Comparable)pistontype));
            BlockState blockState = (BlockState)((Object)((BlockState)((Object)Blocks.field_196603_bb.func_176223_P().func_206870_a((Property)MovingPistonBlock.field_196344_a, (Comparable)((Object)p_176319_3_)))).func_206870_a((Property)MovingPistonBlock.field_196345_b, (Comparable)(this.field_150082_a ? PistonType.STICKY : PistonType.DEFAULT)));
            map.remove(blockpos);
            p_176319_1_.func_180501_a(blockpos, blockState, 68);
            p_176319_1_.func_175690_a(blockpos, MovingPistonBlock.func_196343_a(blockstate4, p_176319_3_, true, true));
        }
        BlockState blockstate3 = Blocks.field_150350_a.func_176223_P();
        for (BlockPos blockPos : map.keySet()) {
            p_176319_1_.func_180501_a(blockPos, blockstate3, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPos blockpos5 = (BlockPos)entry.getKey();
            BlockState blockstate2 = (BlockState)((Object)entry.getValue());
            blockstate2.func_196948_b(p_176319_1_, blockpos5, 2);
            blockstate3.func_235734_a_(p_176319_1_, blockpos5, 2);
            blockstate3.func_196948_b(p_176319_1_, blockpos5, 2);
        }
        j = 0;
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            BlockState blockState = ablockstate[j++];
            BlockPos blockpos6 = list2.get(i1);
            blockState.func_196948_b(p_176319_1_, blockpos6, 2);
            p_176319_1_.func_195593_d(blockpos6, blockState.func_177230_c());
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            p_176319_1_.func_195593_d(list.get(j1), ablockstate[j++].func_177230_c());
        }
        if (p_176319_4_) {
            p_176319_1_.func_195593_d(blockpos, Blocks.field_150332_K);
        }
        return true;
    }

    public BlockState func_185499_a(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)((Object)p_185499_1_.func_206870_a((Property)field_176387_N, (Comparable)((Object)p_185499_2_.func_185831_a((Direction)((Object)p_185499_1_.func_177229_b((Property)field_176387_N))))));
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        return (Boolean)state.func_177229_b((Property)field_176320_b) != false ? state : super.rotate(state, world, pos, direction);
    }

    public BlockState func_185471_a(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.func_185907_a(p_185471_2_.func_185800_a((Direction)((Object)p_185471_1_.func_177229_b((Property)field_176387_N))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{field_176387_N, field_176320_b});
    }

    public boolean func_220074_n(BlockState p_220074_1_) {
        return (Boolean)p_220074_1_.func_177229_b((Property)field_176320_b);
    }

    public boolean func_196266_a(BlockState p_196266_1_, IBlockReader p_196266_2_, BlockPos p_196266_3_, PathType p_196266_4_) {
        return false;
    }
}

