/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedpipes.network.pipe.transport.ItemTransportProps;
import com.refinedmods.refinedpipes.tile.ItemPipeTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Quaternion;

public class ItemPipeTileEntityRenderer
extends TileEntityRenderer<ItemPipeTileEntity> {
    public ItemPipeTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(ItemPipeTileEntity tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferType, int combinedLight, int combinedOverlay) {
        for (ItemTransportProps prop : tile.getProps()) {
            Direction dir = prop.getDirection();
            double pipeLength = 1.0;
            if (prop.isFirstPipe()) {
                pipeLength = 1.25;
            }
            if (prop.isLastPipe()) {
                pipeLength = 0.25;
            }
            double maxTicksInPipe = (double)prop.getMaxTicksInPipe() * pipeLength;
            double v = ((double)prop.getProgress() + (double)partialTicks) / maxTicksInPipe * pipeLength;
            if (prop.isFirstPipe() && v < 0.25) {
                dir = prop.getInitialDirection();
            }
            if (prop.isFirstPipe()) {
                v -= 0.25;
            }
            if (v > 0.25 && tile.func_145831_w().func_175623_d(tile.func_174877_v().func_177972_a(prop.getDirection()))) continue;
            v = Math.min(1.0, v);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5 + (double)dir.func_82601_c() * v, 0.5 + (double)dir.func_96559_d() * v, 0.5 + (double)dir.func_82599_e() * v);
            matrixStack.func_227863_a_(new Quaternion(0.0f, (float)((double)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 25.0 % (Math.PI * 2) + (double)partialTicks / 25.0), 0.0f, false));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(prop.getStack(), ItemCameraTransforms.TransformType.FIXED, combinedLight, combinedOverlay, matrixStack, bufferType);
            matrixStack.func_227865_b_();
        }
    }
}

