/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.transport.callback;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.pipe.transport.callback.TransportCallback;
import com.refinedmods.refinedpipes.util.DirectionUtil;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemInsertTransportCallback
implements TransportCallback {
    private static final Logger LOGGER = LogManager.getLogger(ItemInsertTransportCallback.class);
    public static final ResourceLocation ID = new ResourceLocation("refinedpipes", "item_insert");
    private final BlockPos itemHandlerPosition;
    private final Direction incomingDirection;
    private final ItemStack toInsert;

    public ItemInsertTransportCallback(BlockPos itemHandlerPosition, Direction incomingDirection, ItemStack toInsert) {
        this.itemHandlerPosition = itemHandlerPosition;
        this.incomingDirection = incomingDirection;
        this.toInsert = toInsert;
    }

    @Override
    public void call(Network network, World world, BlockPos currentPos, TransportCallback cancelCallback) {
        TileEntity tile = world.func_175625_s(this.itemHandlerPosition);
        if (tile == null) {
            LOGGER.warn("Destination item handler is gone at " + this.itemHandlerPosition);
            cancelCallback.call(network, world, currentPos, cancelCallback);
            return;
        }
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.incomingDirection.func_176734_d()).orElse(null);
        if (itemHandler == null) {
            LOGGER.warn("Destination item handler is no longer exposing a capability at " + this.itemHandlerPosition);
            cancelCallback.call(network, world, currentPos, cancelCallback);
            return;
        }
        if (ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.toInsert, (boolean)true).func_190926_b()) {
            ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)this.toInsert, (boolean)false);
        } else {
            cancelCallback.call(network, world, currentPos, cancelCallback);
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Nullable
    public static ItemInsertTransportCallback of(CompoundNBT tag) {
        BlockPos itemHandlerPosition = BlockPos.func_218283_e((long)tag.func_74763_f("ihpos"));
        ItemStack toInsert = ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("s"));
        Direction incomingDirection = DirectionUtil.safeGet((byte)tag.func_74762_e("incdir"));
        if (toInsert.func_190926_b()) {
            LOGGER.warn("Item no longer exists");
            return null;
        }
        return new ItemInsertTransportCallback(itemHandlerPosition, incomingDirection, toInsert);
    }

    @Override
    public CompoundNBT writeToNbt(CompoundNBT tag) {
        tag.func_74772_a("ihpos", this.itemHandlerPosition.func_218275_a());
        tag.func_218657_a("s", (INBT)this.toInsert.func_77955_b(new CompoundNBT()));
        tag.func_74768_a("incdir", this.incomingDirection.ordinal());
        return tag;
    }
}

