/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.pipe.attachment.extractor;

import com.refinedmods.refinedpipes.RefinedPipes;
import com.refinedmods.refinedpipes.RefinedPipesItems;
import com.refinedmods.refinedpipes.config.ServerConfig;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public enum ExtractorAttachmentType {
    BASIC(1),
    IMPROVED(2),
    ADVANCED(3),
    ELITE(4),
    ULTIMATE(5);

    private final int tier;

    private ExtractorAttachmentType(int tier) {
        this.tier = tier;
    }

    public int getTier() {
        return this.tier;
    }

    int getItemTickInterval() {
        return this.getConfig().getItemTickInterval();
    }

    int getFluidTickInterval() {
        return this.getConfig().getFluidTickInterval();
    }

    public int getItemsToExtract() {
        return this.getConfig().getItemsToExtract();
    }

    int getFluidsToExtract() {
        return this.getConfig().getFluidsToExtract();
    }

    public int getFilterSlots() {
        return this.getConfig().getFilterSlots();
    }

    public boolean getCanSetRedstoneMode() {
        return this.getConfig().getCanSetRedstoneMode();
    }

    public boolean getCanSetWhitelistBlacklist() {
        return this.getConfig().getCanSetWhitelistBlacklist();
    }

    public boolean getCanSetRoutingMode() {
        return this.getConfig().getCanSetRoutingMode();
    }

    public boolean getCanSetExactMode() {
        return this.getConfig().getCanSetExactMode();
    }

    private ServerConfig.ExtractorAttachment getConfig() {
        switch (this) {
            case BASIC: {
                return RefinedPipes.SERVER_CONFIG.getBasicExtractorAttachment();
            }
            case IMPROVED: {
                return RefinedPipes.SERVER_CONFIG.getImprovedExtractorAttachment();
            }
            case ADVANCED: {
                return RefinedPipes.SERVER_CONFIG.getAdvancedExtractorAttachment();
            }
            case ELITE: {
                return RefinedPipes.SERVER_CONFIG.getEliteExtractorAttachment();
            }
            case ULTIMATE: {
                return RefinedPipes.SERVER_CONFIG.getUltimateExtractorAttachment();
            }
        }
        throw new RuntimeException("?");
    }

    public ResourceLocation getId() {
        switch (this) {
            case BASIC: {
                return new ResourceLocation("refinedpipes", "basic_extractor");
            }
            case IMPROVED: {
                return new ResourceLocation("refinedpipes", "improved_extractor");
            }
            case ADVANCED: {
                return new ResourceLocation("refinedpipes", "advanced_extractor");
            }
            case ELITE: {
                return new ResourceLocation("refinedpipes", "elite_extractor");
            }
            case ULTIMATE: {
                return new ResourceLocation("refinedpipes", "ultimate_extractor");
            }
        }
        throw new RuntimeException("?");
    }

    ResourceLocation getItemId() {
        switch (this) {
            case BASIC: {
                return new ResourceLocation("refinedpipes", "basic_extractor_attachment");
            }
            case IMPROVED: {
                return new ResourceLocation("refinedpipes", "improved_extractor_attachment");
            }
            case ADVANCED: {
                return new ResourceLocation("refinedpipes", "advanced_extractor_attachment");
            }
            case ELITE: {
                return new ResourceLocation("refinedpipes", "elite_extractor_attachment");
            }
            case ULTIMATE: {
                return new ResourceLocation("refinedpipes", "ultimate_extractor_attachment");
            }
        }
        throw new RuntimeException("?");
    }

    Item getItem() {
        switch (this) {
            case BASIC: {
                return RefinedPipesItems.BASIC_EXTRACTOR_ATTACHMENT;
            }
            case IMPROVED: {
                return RefinedPipesItems.IMPROVED_EXTRACTOR_ATTACHMENT;
            }
            case ADVANCED: {
                return RefinedPipesItems.ADVANCED_EXTRACTOR_ATTACHMENT;
            }
            case ELITE: {
                return RefinedPipesItems.ELITE_EXTRACTOR_ATTACHMENT;
            }
            case ULTIMATE: {
                return RefinedPipesItems.ULTIMATE_EXTRACTOR_ATTACHMENT;
            }
        }
        throw new RuntimeException("?");
    }

    ResourceLocation getModelLocation() {
        switch (this) {
            case BASIC: {
                return new ResourceLocation("refinedpipes", "block/pipe/attachment/extractor/basic");
            }
            case IMPROVED: {
                return new ResourceLocation("refinedpipes", "block/pipe/attachment/extractor/improved");
            }
            case ADVANCED: {
                return new ResourceLocation("refinedpipes", "block/pipe/attachment/extractor/advanced");
            }
            case ELITE: {
                return new ResourceLocation("refinedpipes", "block/pipe/attachment/extractor/elite");
            }
            case ULTIMATE: {
                return new ResourceLocation("refinedpipes", "block/pipe/attachment/extractor/ultimate");
            }
        }
        throw new RuntimeException("?");
    }

    public static ExtractorAttachmentType get(byte b) {
        ExtractorAttachmentType[] v = ExtractorAttachmentType.values();
        if (b < 0 || b >= v.length) {
            return BASIC;
        }
        return v[b];
    }
}

