/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedpipes.network.graph;

import com.refinedmods.refinedpipes.network.Network;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScanner;
import com.refinedmods.refinedpipes.network.graph.NetworkGraphScannerResult;
import com.refinedmods.refinedpipes.network.pipe.Destination;
import com.refinedmods.refinedpipes.network.pipe.DestinationType;
import com.refinedmods.refinedpipes.network.pipe.Pipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NetworkGraph {
    private final Network network;
    private Set<Pipe> pipes = new HashSet<Pipe>();
    private Map<DestinationType, List<Destination>> destinations = new HashMap<DestinationType, List<Destination>>();

    public NetworkGraph(Network network) {
        this.network = network;
    }

    public NetworkGraphScannerResult scan(World originWorld, BlockPos originPos) {
        NetworkGraphScanner scanner = new NetworkGraphScanner(this.pipes, this.network.getType());
        NetworkGraphScannerResult result = scanner.scanAt(originWorld, originPos);
        this.pipes = result.getFoundPipes();
        result.getNewPipes().forEach(p -> p.joinNetwork(this.network));
        result.getRemovedPipes().forEach(Pipe::leaveNetwork);
        this.destinations.clear();
        for (Destination destination : result.getDestinations()) {
            this.destinations.computeIfAbsent(destination.getType(), type -> new ArrayList()).add(destination);
        }
        return result;
    }

    public Set<Pipe> getPipes() {
        return this.pipes;
    }

    public List<Destination> getDestinations(DestinationType type) {
        return this.destinations.getOrDefault((Object)type, Collections.emptyList());
    }
}

