/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.aquapatch.patch;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import de.waterdu.aquapatch.util.Config;
import de.waterdu.aquapatch.util.Patch;
import de.waterdu.atlantis.util.concurrency.AtlantisThreadPool;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="aquapatch", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FixedSpawningHeightmap {
    private static final String CAN_SEE_SKY_KEY = "HeightMapChunkKey";
    private static final AtlantisThreadPool EXECUTOR_SERVICE = AtlantisThreadPool.createNewThreadPool((String)"AquaPatch", (int)1, (boolean)true);
    private static final Map<String, HeightmapWrapper> SEES_SKY_HEIGHTMAPS = Maps.newConcurrentMap();

    public static boolean canSeeSky(BlockPos pos, World world) {
        int height = FixedSpawningHeightmap.getHeight(pos, world);
        return height <= pos.func_177956_o() + 1;
    }

    private static int getHeight(BlockPos pos, World world) {
        int height;
        Chunk chunk = world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        ChunkPos chunkPos = chunk.func_76632_l();
        String key = FixedSpawningHeightmap.getKey(world, chunkPos);
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        HeightmapWrapper heightmap = SEES_SKY_HEIGHTMAPS.get(key);
        if (heightmap != null && (height = heightmap.access().func_202273_a(x, z)) != 0) {
            return height;
        }
        if (heightmap == null) {
            heightmap = new HeightmapWrapper((IChunk)chunk, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
        }
        height = FixedSpawningHeightmap.calculateHeight(heightmap, chunk, pos.func_239590_i_());
        heightmap.direct().func_202272_a(x, z, height);
        SEES_SKY_HEIGHTMAPS.put(key, heightmap);
        return height;
    }

    private static int calculateHeight(HeightmapWrapper heightmap, Chunk chunk, BlockPos.Mutable pos) {
        for (int y = chunk.func_76625_h() + 16; y >= 0; --y) {
            pos.func_185336_p(y);
            BlockState state = chunk.func_180495_p((BlockPos)pos);
            if (!heightmap.direct().field_222693_d.test(state)) continue;
            return y;
        }
        return 0;
    }

    @SubscribeEvent
    public static void blockUpdate(BlockEvent.NeighborNotifyEvent event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        BlockPos pos = event.getPos();
        Chunk chunk = world.func_212866_a_(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        String key = FixedSpawningHeightmap.getKey((World)world, chunk.func_76632_l());
        HeightmapWrapper heightmap = SEES_SKY_HEIGHTMAPS.get(key);
        if (heightmap != null) {
            heightmap.access().func_202270_a(x, pos.func_177956_o(), z, event.getState());
        } else {
            heightmap = new HeightmapWrapper((IChunk)chunk, Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
            int height = FixedSpawningHeightmap.calculateHeight(heightmap, chunk, pos.func_239590_i_());
            heightmap.direct().func_202272_a(x, z, height);
            SEES_SKY_HEIGHTMAPS.put(key, heightmap);
        }
    }

    @SubscribeEvent
    public static void loadSpawningHeightmap(ChunkDataEvent.Load event) {
        if (event.getStatus() != ChunkStatus.Type.LEVELCHUNK) {
            return;
        }
        if (event.getData().func_74764_b("CanSeeSkyHeightMap") && event.getData().func_74764_b(CAN_SEE_SKY_KEY)) {
            HeightmapWrapper heightmap = new HeightmapWrapper(event.getChunk(), Heightmap.Type.MOTION_BLOCKING_NO_LEAVES);
            heightmap.direct().func_202268_a(event.getData().func_197645_o("CanSeeSkyHeightMap"));
            String key = event.getData().func_74779_i(CAN_SEE_SKY_KEY);
            SEES_SKY_HEIGHTMAPS.put(key, heightmap);
        }
    }

    @SubscribeEvent
    public static void saveSpawningHeightmap(ChunkDataEvent.Save event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        String key = FixedSpawningHeightmap.getKey((World)world, event.getChunk().func_76632_l());
        if (SEES_SKY_HEIGHTMAPS.containsKey(key)) {
            HeightmapWrapper heightmap = SEES_SKY_HEIGHTMAPS.remove(key);
            event.getData().func_197644_a("CanSeeSkyHeightMap", heightmap.direct().func_202269_a());
            event.getData().func_74778_a(CAN_SEE_SKY_KEY, key);
        }
    }

    @SubscribeEvent
    public static void unloadChunk(ChunkEvent.Unload event) {
        if (!(event.getWorld() instanceof ServerWorld)) {
            return;
        }
        ServerWorld world = (ServerWorld)event.getWorld();
        String key = FixedSpawningHeightmap.getKey((World)world, event.getChunk().func_76632_l());
        SEES_SKY_HEIGHTMAPS.remove(key);
    }

    private static String getKey(World world, ChunkPos pos) {
        String dimensionKey = world.func_234923_W_().func_240901_a_().toString();
        String chunkKey = pos.toString();
        return dimensionKey + ": " + chunkKey;
    }

    public static void shutdown() {
        EXECUTOR_SERVICE.getPool().shutdownNow();
    }

    static {
        EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
            if (Config.settings().isPatchEnabled(Patch.SPAWNING_HEIGHTMAP_SHRINK)) {
                HashSet<String> toRemove = new HashSet<String>();
                for (Map.Entry<String, HeightmapWrapper> entry : SEES_SKY_HEIGHTMAPS.entrySet()) {
                    if (!entry.getValue().inactive()) continue;
                    toRemove.add(entry.getKey());
                }
                for (String key : toRemove) {
                    SEES_SKY_HEIGHTMAPS.remove(key);
                }
            }
        }, 60L, 30L, TimeUnit.SECONDS);
    }

    private static class HeightmapWrapper {
        private static final long ONE_MINUTE_IN_NANOS = 60000000000L;
        private final Heightmap heightmap;
        private long lastAccess;

        public HeightmapWrapper(IChunk chunk, Heightmap.Type type) {
            this.heightmap = new Heightmap(chunk, type);
            this.heightmap.field_222693_d = blockState -> !BetterSpawnerConfig.doesBlockSeeSky((BlockState)blockState);
            this.lastAccess = System.nanoTime();
        }

        public Heightmap access() {
            this.lastAccess = System.nanoTime();
            return this.direct();
        }

        public Heightmap direct() {
            return this.heightmap;
        }

        public boolean inactive() {
            return System.nanoTime() - this.lastAccess > 60000000000L;
        }
    }
}

