/*
 * Decompiled with CFR 0.152.
 */
package de.waterdu.aquapatch.file;

import com.google.common.collect.Maps;
import de.waterdu.aquapatch.util.Patch;
import de.waterdu.atlantis.file.auto.AtlantisConfig;
import de.waterdu.atlantis.file.auto.LoadOrder;
import de.waterdu.atlantis.file.datatypes.Configuration;
import java.util.Map;

@AtlantisConfig(modID="aquapatch", path="patches.json", loadOrder=LoadOrder.FIRST)
public class Settings
implements Configuration {
    private Map<Patch, Boolean> patches = Maps.newHashMap();

    public Settings() {
        for (Patch patch : Patch.values()) {
            this.patches.put(patch, true);
        }
    }

    public boolean isPatchEnabled(Patch patch) {
        return this.patches.computeIfAbsent(patch, Patch::enabledByDefault);
    }

    public int countEnabledPatches() {
        int count = 0;
        for (boolean enabled : this.patches.values()) {
            if (!enabled) continue;
            ++count;
        }
        return count;
    }

    public Map<Patch, Boolean> getPatches() {
        return this.patches;
    }

    public void setPatches(Map<Patch, Boolean> patches) {
        this.patches = patches;
    }
}

