/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.util;

import com.google.common.collect.Sets;
import corgiaoc.byg.util.MLBlockTags;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;

public class BlockHelper {
    public static final BooleanProperty ROOTS = BooleanProperty.func_177716_a((String)"roots");
    public static final int FLAG_UPDATE_BLOCK = 1;
    public static final int FLAG_SEND_CLIENT_CHANGES = 2;
    public static final int FLAG_NO_RERENDER = 4;
    public static final int FORSE_RERENDER = 8;
    public static final int FLAG_IGNORE_OBSERVERS = 16;
    public static final int SET_SILENT = 19;
    public static final int SET_OBSERV = 3;
    public static final Direction[] HORIZONTAL_DIRECTIONS = BlockHelper.makeHorizontal();
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();
    protected static final BlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final BlockState WATER = Blocks.field_150355_j.func_176223_P();

    public static int upRay(IWorldReader world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.func_175623_d(pos.func_177981_b(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRay(IWorldReader world, BlockPos pos, int maxDist) {
        int length = 0;
        for (int j = 1; j < maxDist && world.func_175623_d(pos.func_177979_c(j)); ++j) {
            ++length;
        }
        return length;
    }

    public static int downRayRep(IWorldReader world, BlockPos pos, int maxDist) {
        POS.func_189533_g((Vector3i)pos);
        for (int j = 1; j < maxDist && world.func_180495_p((BlockPos)POS).func_185904_a().func_76222_j(); ++j) {
            POS.func_185336_p(POS.func_177956_o() - 1);
        }
        return pos.func_177956_o() - POS.func_177956_o();
    }

    public static Direction[] makeHorizontal() {
        return new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    }

    public static Direction randomHorizontal(Random random) {
        return HORIZONTAL_DIRECTIONS[random.nextInt(4)];
    }

    public static Direction randomDirection(Random random) {
        return DIRECTIONS[random.nextInt(6)];
    }

    public static BlockState rotateHorizontal(BlockState state, Rotation rotation, DirectionProperty facing) {
        return (BlockState)state.func_206870_a((Property)facing, (Comparable)rotation.func_185831_a((Direction)state.func_177229_b((Property)facing)));
    }

    public static BlockState mirrorHorizontal(BlockState state, Mirror mirror, DirectionProperty facing) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)facing)));
    }

    public static Direction getRandomHorizontalDirection(Random rand) {
        return HORIZONTAL_DIRECTIONS[rand.nextInt(4)];
    }

    public static void setWithoutUpdate(IWorldWriter world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 19);
    }

    public static void setWithUpdate(IWorldWriter world, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, state, 3);
    }

    public static void setWithUpdate(IWorldWriter world, BlockPos pos, Block block) {
        world.func_180501_a(pos, block.func_176223_P(), 3);
    }

    public static void setWithoutUpdate(IWorldWriter world, BlockPos pos, Block block) {
        world.func_180501_a(pos, block.func_176223_P(), 19);
    }

    public static void fixBlocks(IWorld world, BlockPos start, BlockPos end) {
        HashSet doubleCheck = Sets.newHashSet();
        for (int x = start.func_177958_n(); x <= end.func_177958_n(); ++x) {
            POS.func_223471_o(x);
            for (int z = start.func_177952_p(); z <= end.func_177952_p(); ++z) {
                POS.func_223472_q(z);
                block2: for (int y = start.func_177956_o(); y <= end.func_177956_o(); ++y) {
                    POS.func_185336_p(y);
                    BlockState state = world.func_180495_p((BlockPos)POS);
                    if (!state.func_204520_s().func_206888_e()) {
                        if (!state.func_196955_c((IWorldReader)world, (BlockPos)POS)) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, WATER);
                            POS.func_185336_p(POS.func_177956_o() - 1);
                            state = world.func_180495_p((BlockPos)POS);
                            while (!state.func_196955_c((IWorldReader)world, (BlockPos)POS)) {
                                state = state.func_204520_s().func_206888_e() ? AIR : WATER;
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, state);
                                POS.func_185336_p(POS.func_177956_o() - 1);
                                state = world.func_180495_p((BlockPos)POS);
                            }
                        }
                        POS.func_185336_p(y - 1);
                        if (world.func_175623_d((BlockPos)POS)) {
                            POS.func_185336_p(y);
                            while (!world.func_204610_c((BlockPos)POS).func_206888_e()) {
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, AIR);
                                POS.func_185336_p(POS.func_177956_o() + 1);
                            }
                            continue;
                        }
                        for (Direction dir : HORIZONTAL_DIRECTIONS) {
                            if (!world.func_175623_d(POS.func_177972_a(dir))) continue;
                            world.func_205219_F_().func_205360_a((BlockPos)POS, (Object)state.func_204520_s().func_206886_c(), 0);
                            continue block2;
                        }
                        continue;
                    }
                    if (state.func_196955_c((IWorldReader)world, (BlockPos)POS)) continue;
                    if (state.func_203425_a(Blocks.field_185765_cR)) {
                        HashSet ends = Sets.newHashSet();
                        HashSet add = Sets.newHashSet();
                        ends.add(POS.func_185334_h());
                        for (int i = 0; i < 64 && !ends.isEmpty(); ++i) {
                            ends.forEach(pos -> {
                                BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, AIR);
                                for (Direction dir : HORIZONTAL_DIRECTIONS) {
                                    BlockPos p = pos.func_177972_a(dir);
                                    BlockState st = world.func_180495_p(p);
                                    if (!st.func_203425_a(Blocks.field_185765_cR) && !st.func_203425_a(Blocks.field_185766_cS) || st.func_196955_c((IWorldReader)world, p)) continue;
                                    add.add(p);
                                }
                                BlockPos p = pos.func_177984_a();
                                BlockState st = world.func_180495_p(p);
                                if ((st.func_203425_a(Blocks.field_185765_cR) || st.func_203425_a(Blocks.field_185766_cS)) && !st.func_196955_c((IWorldReader)world, p)) {
                                    add.add(p);
                                }
                            });
                            ends.clear();
                            ends.addAll(add);
                            add.clear();
                        }
                        continue;
                    }
                    if (state.func_177230_c() instanceof VineBlock) {
                        while (world.func_180495_p((BlockPos)POS).func_177230_c() instanceof VineBlock) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, AIR);
                            POS.func_185336_p(POS.func_177956_o() - 1);
                        }
                        continue;
                    }
                    if (!(state.func_177230_c() instanceof FallingBlock)) continue;
                    BlockState falling = state;
                    POS.func_185336_p(POS.func_177956_o() - 1);
                    state = world.func_180495_p((BlockPos)POS);
                    int ray = BlockHelper.downRayRep((IWorldReader)world, POS.func_185334_h(), 64);
                    if (ray > 32) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, Blocks.field_150377_bs.func_176223_P());
                        if (!world.func_201674_k().nextBoolean()) continue;
                        POS.func_185336_p(POS.func_177956_o() - 1);
                        state = world.func_180495_p((BlockPos)POS);
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, Blocks.field_150377_bs.func_176223_P());
                        continue;
                    }
                    POS.func_185336_p(y);
                    BlockState replacement = AIR;
                    for (Direction dir : HORIZONTAL_DIRECTIONS) {
                        state = world.func_180495_p(POS.func_177972_a(dir));
                        if (state.func_204520_s().func_206888_e()) continue;
                        replacement = state;
                        break;
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, replacement);
                    POS.func_185336_p(y - ray);
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, falling);
                }
            }
        }
        doubleCheck.forEach(pos -> {
            if (!world.func_180495_p(pos).func_196955_c((IWorldReader)world, pos)) {
                BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, AIR);
            }
        });
    }

    private static BlockState getAirOrFluid(BlockState state) {
        return state.func_204520_s().func_206888_e() ? AIR : state.func_204520_s().func_206883_i();
    }

    public static boolean isEndNylium(Block block) {
        return block.func_203417_a((ITag)BlockTags.field_232873_an_) && block.func_203417_a(MLBlockTags.END_STONES);
    }

    public static boolean isEndNylium(BlockState state) {
        return BlockHelper.isEndNylium(state.func_177230_c());
    }
}

