/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class HangingColumnWithBaseConfig
implements IFeatureConfig {
    public static final Codec<HangingColumnWithBaseConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("base_block_provider").forGetter(config -> config.baseBlockProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("block_provider").forGetter(config -> config.blockProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("end_block_provider").forGetter(config -> config.endBlockProvider), (App)Codec.INT.fieldOf("min_length").forGetter(config -> config.minLength), (App)Codec.INT.fieldOf("max_length").forGetter(config -> config.maxLength), (App)BlockState.field_235877_b_.listOf().fieldOf("whitelist").forGetter(config -> config.whitelist.stream().map(Block::func_176223_P).collect(Collectors.toList()))).apply((Applicative)codecRecorder, HangingColumnWithBaseConfig::new));
    private final BlockStateProvider baseBlockProvider;
    private final BlockStateProvider blockProvider;
    private final BlockStateProvider endBlockProvider;
    private final int minLength;
    private final int maxLength;
    private final Set<Block> whitelist;

    HangingColumnWithBaseConfig(BlockStateProvider baseBlockProvider, BlockStateProvider blockProvider, BlockStateProvider endBlockProvider, int minLength, int maxLength, List<BlockState> whitelist) {
        this.baseBlockProvider = baseBlockProvider;
        this.blockProvider = blockProvider;
        this.endBlockProvider = endBlockProvider;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.whitelist = whitelist.stream().map(AbstractBlock.AbstractBlockState::func_177230_c).collect(Collectors.toSet());
    }

    public BlockStateProvider getBaseBlockProvider() {
        return this.baseBlockProvider;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public BlockStateProvider getEndBlockProvider() {
        return this.endBlockProvider;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxPossibleLength() {
        int returnValue = this.minLength - this.maxLength;
        if (returnValue <= 0) {
            returnValue = 1;
        }
        return returnValue;
    }

    public Set<Block> getWhitelist() {
        return this.whitelist;
    }

    public static class Builder {
        private BlockStateProvider baseBlockProvider = new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
        private BlockStateProvider blockProvider = new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());
        private BlockStateProvider endBlockProvider = new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P());
        private List<Block> whitelist = ImmutableList.of((Object)Blocks.field_196658_i);
        private int minLength = 1;
        private int maxLength = 9;

        public Builder setBaseBlock(Block block) {
            this.baseBlockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBaseBlock(BlockState state) {
            this.baseBlockProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBaseBlock(BlockStateProvider provider) {
            this.baseBlockProvider = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(Block block) {
            this.blockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockState state) {
            this.blockProvider = state != null ? new SimpleBlockStateProvider(state) : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setBlock(BlockStateProvider provider) {
            this.blockProvider = provider != null ? provider : new SimpleBlockStateProvider(Blocks.field_150348_b.func_176223_P());
            return this;
        }

        public Builder setEndBlock(Block block) {
            this.endBlockProvider = block != null ? new SimpleBlockStateProvider(block.func_176223_P()) : this.blockProvider;
            return this;
        }

        public Builder setEndBlock(BlockState state) {
            this.endBlockProvider = state != null ? new SimpleBlockStateProvider(state) : this.blockProvider;
            return this;
        }

        public Builder setEndBlock(BlockStateProvider provider) {
            this.endBlockProvider = provider != null ? provider : this.blockProvider;
            return this;
        }

        public Builder setMinLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder setMaxLength(int maxPossibleHeight) {
            this.maxLength = maxPossibleHeight != 0 ? maxPossibleHeight + 1 : 1;
            return this;
        }

        public Builder setWhitelist(ImmutableList<Block> whitelist) {
            this.whitelist = whitelist;
            return this;
        }

        public Builder copy(HangingColumnWithBaseConfig config) {
            this.baseBlockProvider = config.baseBlockProvider;
            this.blockProvider = config.blockProvider;
            this.endBlockProvider = config.endBlockProvider;
            this.minLength = config.minLength;
            this.maxLength = config.maxLength;
            this.whitelist = ImmutableList.copyOf((Collection)config.whitelist);
            return this;
        }

        public HangingColumnWithBaseConfig build() {
            return new HangingColumnWithBaseConfig(this.baseBlockProvider, this.blockProvider, this.endBlockProvider, this.minLength, this.maxLength, this.whitelist.stream().map(Block::func_176223_P).collect(Collectors.toList()));
        }
    }
}

