/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.NoisySphereConfig;
import corgiaoc.byg.util.noise.fastnoise.FastNoise;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class NoisyCaveSphereWater
extends Feature<NoisySphereConfig> {
    public static FastNoise fastNoise;
    protected static long seed;

    public NoisyCaveSphereWater(Codec<NoisySphereConfig> configCodec) {
        super(configCodec);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random random, BlockPos position, NoisySphereConfig config) {
        NoisyCaveSphereWater.setSeed(world.func_72905_C());
        BlockPos.Mutable mutable = new BlockPos.Mutable().func_189533_g((Vector3i)position);
        BlockPos.Mutable mutable2 = new BlockPos.Mutable().func_189533_g((Vector3i)mutable);
        int stackHeight = random.nextInt(config.getMaxPossibleHeight()) + config.getMinHeight();
        int xRadius = config.getRandomXRadius(random);
        int yRadius = config.getRandomYRadius(random);
        int zRadius = config.getRandomZRadius(random);
        for (int stackIDX = 0; stackIDX < stackHeight; ++stackIDX) {
            for (int x = -xRadius; x <= xRadius; ++x) {
                for (int z = -zRadius; z <= zRadius; ++z) {
                    for (int y = -yRadius; y <= 0; ++y) {
                        mutable.func_185336_p(world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n() + x, mutable.func_177952_p() + z));
                        mutable2.func_189533_g((Vector3i)mutable).func_196234_d(x, y, z);
                        IChunk chunk = world.func_217349_x((BlockPos)mutable2);
                        double equationResult = Math.pow(x, 2.0) / Math.pow(xRadius, 2.0) + Math.pow(y, 2.0) / Math.pow(yRadius, 2.0) + Math.pow(z, 2.0) / Math.pow(zRadius, 2.0);
                        double threshold = 1.0 + 0.7 * (double)fastNoise.GetNoise(mutable2.func_177958_n(), mutable2.func_177956_o(), mutable2.func_177952_p());
                        if (equationResult >= threshold || !world.func_180495_p((BlockPos)mutable2).func_200132_m()) continue;
                        int bitIndex = mutable2.func_177958_n() & 0xF | (mutable2.func_177952_p() & 0xF) << 4 | mutable2.func_177956_o() << 8;
                        world.func_180501_a((BlockPos)mutable2, Blocks.field_150355_j.func_176223_P(), 2);
                        world.func_205219_F_().func_205360_a((BlockPos)mutable2, (Object)Fluids.field_204546_a, 0);
                    }
                    xRadius = (int)((double)xRadius / config.getRadiusDivisorPerStack());
                    yRadius = (int)((double)yRadius / config.getRadiusDivisorPerStack());
                    zRadius = (int)((double)zRadius / config.getRadiusDivisorPerStack());
                }
            }
        }
        return true;
    }

    public static void setSeed(long worldSeed) {
        if (seed != worldSeed || fastNoise == null) {
            fastNoise = new FastNoise((int)worldSeed);
            fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
            fastNoise.SetFrequency(0.09f);
            seed = worldSeed;
        }
    }
}

