/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.biome;

import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.OverworldPrimaryBiomeData;
import corgiaoc.byg.mixin.access.BiomeAccess;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import corgiaoc.byg.mixin.access.WeightedListEntryAccess;
import corgiaoc.byg.util.MLClimate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeAmbience;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;

public class BYGBiome {
    public static final List<BYGBiome> BYG_BIOMES = new ArrayList<BYGBiome>();
    private final Biome biome;
    public static final Map<ResourceLocation, WeightedList<ResourceLocation>> BIOME_TO_HILLS_LIST = new HashMap<ResourceLocation, WeightedList<ResourceLocation>>();
    public static final Map<ResourceLocation, ResourceLocation> BIOME_TO_BEACH_LIST = new HashMap<ResourceLocation, ResourceLocation>();
    public static final Map<ResourceLocation, ResourceLocation> BIOME_TO_EDGE_LIST = new HashMap<ResourceLocation, ResourceLocation>();
    public static final Map<ResourceLocation, ResourceLocation> BIOME_TO_RIVER_LIST = new HashMap<ResourceLocation, ResourceLocation>();

    public BYGBiome(Biome.Climate climate, Biome.Category category, float depth, float scale, BiomeAmbience effects, BiomeGenerationSettings biomeGenerationSettings, MobSpawnInfo mobSpawnInfo) {
        this.biome = BiomeAccess.create(climate, category, depth, scale, effects, biomeGenerationSettings, mobSpawnInfo);
        BYG_BIOMES.add(this);
    }

    public BYGBiome(Biome.Builder builder) {
        this.biome = builder.func_242455_a();
        BYG_BIOMES.add(this);
    }

    public BYGBiome(Biome biome) {
        this.biome = biome;
        BYG_BIOMES.add(this);
    }

    public Biome getBiome() {
        return this.biome;
    }

    public Biome getRiver() {
        return (Biome)WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76781_i);
    }

    public WeightedList<Biome> getHills() {
        return new WeightedList();
    }

    @Nullable
    public Biome getEdge() {
        return null;
    }

    @Nullable
    public Biome getBeach() {
        return (Biome)WorldGenRegistries.field_243657_i.func_243576_d(Biomes.field_76787_r);
    }

    public String[] getBiomeDictionary() {
        return new String[]{"OVERWORLD"};
    }

    public MLClimate getClimate() {
        return MLClimate.WARM;
    }

    public int getWeight() {
        return 5;
    }

    public static BiomeDataHolders.OverworldPrimaryBiomeDataHolder extractDefaultHolder() {
        HashMap<ResourceLocation, OverworldPrimaryBiomeData> biomeData = new HashMap<ResourceLocation, OverworldPrimaryBiomeData>();
        for (BYGBiome bygBiome : BYG_BIOMES) {
            WeightedList weightedListByLocation = new WeightedList();
            for (WeightedList.Entry entry : ((WeightedListAccess)bygBiome.getHills()).getEntries()) {
                weightedListByLocation.func_226313_a_((Object)WorldGenRegistries.field_243657_i.func_177774_c(entry.func_220647_b()), ((WeightedListEntryAccess)entry).getWeight());
            }
            biomeData.put(WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getBiome()), new OverworldPrimaryBiomeData(bygBiome.getClimate(), bygBiome.getWeight(), Arrays.asList(bygBiome.getBiomeDictionary()), (WeightedList<ResourceLocation>)weightedListByLocation, bygBiome.getEdge() != null ? WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getEdge()) : new ResourceLocation(""), WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getBeach()), WorldGenRegistries.field_243657_i.func_177774_c((Object)bygBiome.getRiver())));
        }
        return new BiomeDataHolders.OverworldPrimaryBiomeDataHolder((Map<ResourceLocation, OverworldPrimaryBiomeData>)biomeData);
    }

    public RegistryKey<Biome> getKey() {
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)Objects.requireNonNull(WorldGenRegistries.field_243657_i.func_177774_c((Object)this.biome)));
    }
}

