/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.particle.DeceleratingParticle;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;

public class BoricFlameParticle
extends DeceleratingParticle
implements IParticleData {
    public BoricFlameParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z, motionX, motionY, motionZ);
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217602_b;
    }

    public void func_187110_a(double motionX, double motionY, double motionZ) {
        this.func_187108_a(this.func_187116_l().func_72317_d(motionX, motionY, motionZ));
        this.func_187118_j();
    }

    public float func_217561_b(float size) {
        float f = ((float)this.field_70546_d + size) / (float)this.field_70547_e;
        return this.field_70544_f * (1.0f - f * f * 0.5f);
    }

    public int func_189214_a(float color) {
        float f = ((float)this.field_70546_d + color) / (float)this.field_70547_e;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_189214_a(color);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public ParticleType<?> func_197554_b() {
        return null;
    }

    public void func_197553_a(PacketBuffer p_197553_1_) {
    }

    public String func_197555_a() {
        return null;
    }

    public static class BoricParticleData
    implements IParticleData {
        public static final BoricParticleData BORIC = new BoricParticleData(0.0f, 1.0f, 0.2f, 1.0f);
        public static final Codec<BoricParticleData> CODEC = RecordCodecBuilder.create(p_239803_0_ -> p_239803_0_.group((App)Codec.FLOAT.fieldOf("r").forGetter(p_239807_0_ -> Float.valueOf(p_239807_0_.red)), (App)Codec.FLOAT.fieldOf("g").forGetter(p_239806_0_ -> Float.valueOf(p_239806_0_.green)), (App)Codec.FLOAT.fieldOf("b").forGetter(p_239805_0_ -> Float.valueOf(p_239805_0_.blue)), (App)Codec.FLOAT.fieldOf("scale").forGetter(p_239804_0_ -> Float.valueOf(p_239804_0_.alpha))).apply((Applicative)p_239803_0_, BoricParticleData::new));
        public static final IParticleData.IDeserializer<BoricParticleData> DESERIALIZER = new IParticleData.IDeserializer<BoricParticleData>(){

            public BoricParticleData fromCommand(ParticleType<BoricParticleData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                float red = (float)reader.readDouble();
                reader.expect(' ');
                float green = (float)reader.readDouble();
                reader.expect(' ');
                float blue = (float)reader.readDouble();
                reader.expect(' ');
                float alpha = (float)reader.readDouble();
                return new BoricParticleData(red, green, blue, alpha);
            }

            public BoricParticleData fromNetwork(ParticleType<BoricParticleData> particleTypeIn, PacketBuffer buffer) {
                return new BoricParticleData(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
            }
        };
        private final float red;
        private final float green;
        private final float blue;
        private final float alpha;

        public BoricParticleData(float redIn, float greenIn, float blueIn, float alphaIn) {
            this.red = redIn;
            this.green = greenIn;
            this.blue = blueIn;
            this.alpha = MathHelper.func_76131_a((float)alphaIn, (float)0.01f, (float)4.0f);
        }

        public ParticleType<?> func_197554_b() {
            return null;
        }

        public void func_197553_a(PacketBuffer buffer) {
            buffer.writeFloat(this.red);
            buffer.writeFloat(this.green);
            buffer.writeFloat(this.blue);
            buffer.writeFloat(this.alpha);
        }

        public String func_197555_a() {
            return String.format(Locale.ROOT, "%s %.2f %.2f %.2f %.2f", Registry.field_212632_u.func_177774_c(this.func_197554_b()), Float.valueOf(this.red), Float.valueOf(this.green), Float.valueOf(this.blue), Float.valueOf(this.alpha));
        }
    }

    public static class Factory
    implements IParticleFactory<BoricParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteIn) {
            this.spriteSet = spriteIn;
        }

        public Particle createParticle(BoricParticleData particle, ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
            BoricFlameParticle flameparticle = new BoricFlameParticle(world, x, y, z, motionX, motionY, motionZ);
            flameparticle.func_217568_a(this.spriteSet);
            return flameparticle;
        }
    }
}

