/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.data.WorldData;
import journeymap.client.log.JMLogger;
import journeymap.client.properties.FullMapProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollPane;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.LocationFormat;
import journeymap.client.ui.waypoint.WaypointManager;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.util.Strings;

public class WaypointEditor
extends JmUI {
    private final TextureImpl wpTexture;
    private final TextureImpl colorPickTexture;
    private final Waypoint originalWaypoint;
    private final boolean isNew;
    String labelName = Constants.getString("jm.waypoint.name");
    String locationTitle = Constants.getString("jm.waypoint.location");
    String colorTitle = Constants.getString("jm.waypoint.color");
    String dimensionsTitle = Constants.getString("jm.waypoint.dimensions");
    String labelX = Constants.getString("jm.waypoint.x");
    String labelY = Constants.getString("jm.waypoint.y");
    String labelZ = Constants.getString("jm.waypoint.z");
    String labelR = Constants.getString("jm.waypoint.red_abbreviated");
    String labelG = Constants.getString("jm.waypoint.green_abbreviated");
    String labelB = Constants.getString("jm.waypoint.blue_abbreviated");
    String currentLocation = "";
    LocationFormat.LocationFormatKeys locationFormatKeys;
    private Button buttonRandomize;
    private OnOffButton buttonEnable;
    private Button buttonRemove;
    private Button buttonReset;
    private Button buttonSave;
    private Button buttonClose;
    private TextBox fieldName;
    private TextBox fieldR;
    private TextBox fieldG;
    private TextBox fieldB;
    private TextBox fieldX;
    private TextBox fieldY;
    private TextBox fieldZ;
    private ArrayList<TextBox> fieldList = new ArrayList();
    private ArrayList<DimensionButton> dimButtonList = new ArrayList();
    private ScrollPane dimScrollPane;
    private Integer currentColor;
    private Rectangle2D.Double colorPickRect;
    private BufferedImage colorPickImg;
    private String colorPickTooltip;
    private Waypoint editedWaypoint;
    private ButtonList bottomButtons;
    private float partialTicks;
    private boolean openedWithHotKey = true;

    public WaypointEditor(Waypoint waypoint, boolean isNew, JmUI returnDisplay) {
        super(Constants.getString(isNew ? "jm.waypoint.new_title" : "jm.waypoint.edit_title"), returnDisplay);
        String tooltip;
        this.originalWaypoint = waypoint;
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.isNew = isNew;
        this.wpTexture = waypoint.getTexture();
        this.colorPickTooltip = tooltip = Constants.birthdayMessage();
        this.colorPickTexture = tooltip == null ? TextureCache.getTexture(TextureCache.ColorPicker) : TextureCache.getTexture(TextureCache.ColorPicker2);
        try {
            this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, this.colorPickTexture.getWidth(), this.colorPickTexture.getHeight());
            this.colorPickImg = this.colorPickTexture.getImage();
            Minecraft.func_71410_x().field_195559_v.func_197967_a(true);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor ctor: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
        if (returnDisplay != null && !(returnDisplay instanceof Fullscreen)) {
            this.openedWithHotKey = false;
        }
    }

    @Override
    public void func_231160_c_() {
        try {
            this.setRenderBottomBar(true);
            FullMapProperties fullMapProperties = JourneymapClient.getInstance().getFullMapProperties();
            LocationFormat locationFormat = new LocationFormat();
            this.locationFormatKeys = locationFormat.getFormatKeys(fullMapProperties.locationFormat.get());
            String pos = this.locationFormatKeys.format(fullMapProperties.locationFormatVerbose.get(), MathHelper.func_76128_c((double)this.field_230706_i_.field_71439_g.func_226277_ct_()), MathHelper.func_76128_c((double)this.field_230706_i_.field_71439_g.func_226281_cx_()), MathHelper.func_76128_c((double)this.field_230706_i_.field_71439_g.func_174813_aQ().field_72338_b), MathHelper.func_76141_d((float)this.field_230706_i_.field_71439_g.field_70162_ai));
            this.currentLocation = Constants.getString("jm.waypoint.current_location", " " + pos);
            if (this.fieldList.isEmpty()) {
                FontRenderer fr = this.getFontRenderer();
                this.fieldName = new TextBox(this.originalWaypoint.getName(), fr, 160, 20);
                if (this.isNew) {
                    this.fieldName.func_146195_b(true);
                    this.fieldName.func_146202_e();
                    this.fieldName.func_146199_i(0);
                }
                this.fieldList.add(this.fieldName);
                int width9chars = this.getFontRenderer().func_78256_a("-30000000") + 10;
                int width3chars = this.getFontRenderer().func_78256_a("255") + 10;
                int h = 20;
                this.fieldX = new TextBox(this.originalWaypoint.getX(), fr, width9chars, h, true, true);
                this.fieldX.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldX);
                this.fieldZ = new TextBox(this.originalWaypoint.getZ(), fr, width9chars, h, true, true);
                this.fieldZ.setClamp(-30000000, 30000000);
                this.fieldList.add(this.fieldZ);
                int y = this.originalWaypoint.getY();
                this.fieldY = new TextBox(y < 0 ? "" : Integer.valueOf(y), fr, width3chars, h, true, true);
                this.fieldY.setClamp(0, this.field_230706_i_.field_71441_e.func_217301_I() - 1);
                this.fieldY.setMinLength(1);
                this.fieldList.add(this.fieldY);
                this.fieldR = new TextBox("", fr, width3chars, h, true, false);
                this.fieldR.setClamp(0, 255);
                this.fieldR.func_146203_f(3);
                this.fieldList.add(this.fieldR);
                this.fieldG = new TextBox("", fr, width3chars, h, true, false);
                this.fieldG.setClamp(0, 255);
                this.fieldG.func_146203_f(3);
                this.fieldList.add(this.fieldG);
                this.fieldB = new TextBox("", fr, width3chars, h, true, false);
                this.fieldB.setClamp(0, 255);
                this.fieldB.func_146203_f(3);
                this.fieldList.add(this.fieldB);
                Collection<String> wpDims = this.originalWaypoint.getDimensions();
                for (WorldData.DimensionProvider provider : WorldData.getDimensionProviders(WaypointStore.INSTANCE.getLoadedDimensions())) {
                    String dimName = WorldData.getSafeDimensionName(provider);
                    String dimId = provider.getDimensionId();
                    try {
                        dimName = provider.getName();
                    }
                    catch (Exception e) {
                        JMLogger.logOnce("Can't get dimension name from provider: ", e);
                    }
                    DimensionButton button2 = new DimensionButton(dimId, dimName, wpDims.contains(dimId));
                    button2.setDefaultStyle(false);
                    this.dimButtonList.add(button2);
                }
                this.dimScrollPane = new ScrollPane(this, this.field_230706_i_, 0, 0, this.dimButtonList, this.dimButtonList.get(0).func_238483_d_(), 4);
                this.dimScrollPane.func_230943_a_(false);
            }
            if (this.field_230710_m_.isEmpty()) {
                String on = Constants.getString("jm.common.on");
                String off = Constants.getString("jm.common.off");
                String enableOn = Constants.getString("jm.waypoint.enable", on);
                String enableOff = Constants.getString("jm.waypoint.enable", off);
                this.buttonRandomize = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.waypoint.randomize"), button -> this.setRandomColor()));
                this.buttonEnable = (OnOffButton)this.func_230480_a_((Widget)new OnOffButton(enableOn, enableOff, true, button -> this.buttonEnable.toggle()));
                this.buttonEnable.setToggled(this.originalWaypoint.isEnable());
                this.buttonRemove = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.waypoint.remove"), button -> this.remove()));
                this.buttonRemove.setEnabled(!this.isNew);
                this.buttonReset = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.waypoint.reset"), button -> this.resetForm()));
                this.buttonSave = (Button)this.func_230480_a_((Widget)new Button(Constants.getString("jm.waypoint.save"), button -> this.save()));
                String closeLabel = this.isNew ? "jm.waypoint.cancel" : "jm.common.close";
                this.buttonClose = (Button)this.func_230480_a_((Widget)new Button(Constants.getString(closeLabel), button -> this.refreshAndClose(this.originalWaypoint)));
                this.field_230710_m_.add(this.buttonEnable);
                this.field_230710_m_.add(this.buttonRandomize);
                this.field_230710_m_.add(this.buttonRemove);
                this.field_230710_m_.add(this.buttonReset);
                this.field_230710_m_.add(this.buttonSave);
                this.field_230710_m_.add(this.buttonClose);
                this.buttonEnable.setDefaultStyle(false);
                this.buttonRandomize.setDefaultStyle(false);
                this.buttonRemove.setDefaultStyle(false);
                this.buttonReset.setDefaultStyle(false);
                this.buttonSave.setDefaultStyle(false);
                this.buttonClose.setDefaultStyle(false);
                this.bottomButtons = new ButtonList(this.buttonRemove, this.buttonSave, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.setFormColor(this.originalWaypoint.getIconColor());
                this.validate();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(MatrixStack mStack) {
        try {
            this.func_231160_c_();
            FontRenderer fr = this.getFontRenderer();
            int vpad = 5;
            int hgap = fr.func_78256_a("X") * 3;
            int vgap = this.fieldX.func_238483_d_() + 5;
            int startY = Math.max(30, (this.field_230709_l_ - 200) / 2);
            int dcw = fr.func_78256_a(this.dimensionsTitle);
            dcw = 8 + Math.max(dcw, this.dimScrollPane.getFitWidth(fr));
            int leftWidth = hgap * 2 + this.fieldX.func_230998_h_() + this.fieldY.func_230998_h_() + this.fieldZ.func_230998_h_();
            int rightWidth = dcw;
            int totalWidth = leftWidth + 10 + rightWidth;
            int leftX = (this.field_230708_k_ - totalWidth) / 2;
            int leftXEnd = leftX + leftWidth;
            int rightX = leftXEnd + 10;
            int rightXEnd = rightX + rightWidth;
            int leftRowY = startY;
            this.drawLabel(mStack, this.labelName, leftX, leftRowY);
            this.fieldName.func_230991_b_(leftWidth);
            this.fieldName.func_212952_l(leftX);
            this.fieldName.setY(leftRowY += 12);
            this.fieldName.func_230430_a_(mStack, leftX, leftRowY, this.partialTicks);
            this.drawLabel(mStack, this.locationTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(mStack, this.labelX, this.fieldX, leftX, leftRowY += 12);
            this.drawLabelAndField(mStack, this.labelZ, this.fieldZ, this.fieldX.getX() + this.fieldX.func_230998_h_() + hgap, leftRowY);
            this.drawLabelAndField(mStack, this.labelY, this.fieldY, this.fieldZ.getX() + this.fieldZ.func_230998_h_() + hgap, leftRowY);
            this.drawLabel(mStack, this.colorTitle, leftX, leftRowY += vgap + 5);
            this.drawLabelAndField(mStack, this.labelR, this.fieldR, leftX, leftRowY += 12);
            this.drawLabelAndField(mStack, this.labelG, this.fieldG, this.fieldR.getX() + this.fieldR.func_230998_h_() + hgap, leftRowY);
            this.drawLabelAndField(mStack, this.labelB, this.fieldB, this.fieldG.getX() + this.fieldG.func_230998_h_() + hgap, leftRowY);
            this.buttonRandomize.func_230991_b_(4 + Math.max(this.fieldB.getX() + this.fieldB.func_230998_h_() - this.fieldR.getX(), 10 + fr.func_78256_a(this.buttonRandomize.func_230458_i_().getString())));
            this.buttonRandomize.setPosition(this.fieldR.getX() - 2, leftRowY += vgap);
            int cpY = this.fieldB.getY();
            int cpSize = this.buttonRandomize.getY() + this.buttonRandomize.func_238483_d_() - cpY - 2;
            int cpHAreaX = this.fieldB.getX() + this.fieldB.func_230998_h_();
            int cpHArea = this.fieldName.getX() + this.fieldName.func_230998_h_() - cpHAreaX;
            int cpX = cpHAreaX + (cpHArea - cpSize);
            this.drawColorPicker(mStack, cpX, cpY, cpSize);
            int iconX = cpHAreaX + (cpX - cpHAreaX) / 2 - this.wpTexture.getWidth() / 2 + 1;
            int iconY = this.buttonRandomize.getY() - 2;
            this.drawWaypoint(mStack, iconX, iconY);
            this.buttonEnable.fitWidth(fr);
            this.buttonEnable.func_230991_b_(Math.max(leftWidth / 2, this.buttonEnable.func_230998_h_()));
            this.buttonEnable.setPosition(leftX - 2, leftRowY += vgap);
            this.buttonReset.func_230991_b_(leftWidth - this.buttonEnable.func_230998_h_() - 2);
            this.buttonReset.setPosition(leftXEnd - this.buttonReset.func_230998_h_() + 2, leftRowY);
            int rightRow = startY;
            this.drawLabel(mStack, this.dimensionsTitle, rightX, rightRow);
            int scrollHeight = this.buttonReset.getY() + this.buttonReset.func_238483_d_() - 2 - (rightRow += 12);
            this.dimScrollPane.setDimensions(dcw, scrollHeight, 0, 0, rightX, rightRow);
            int totalRow = Math.max(leftRowY + vgap, rightRow + vgap);
            this.bottomButtons.layoutFilledHorizontal(fr, leftX - 2, totalRow, rightXEnd + 2, 4, true);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack mStack, int x, int y, float partialTicks) {
        try {
            this.partialTicks = partialTicks;
            this.func_238651_a_(mStack, 0);
            super.renderBottomBar(mStack);
            this.validate();
            this.layoutButtons(mStack);
            this.dimScrollPane.func_230430_a_(mStack, x, y, partialTicks);
            DrawUtil.drawLabel(mStack, (ITextComponent)Constants.getStringTextComponent(this.currentLocation), this.field_230708_k_ / 2, this.field_230709_l_, DrawUtil.HAlign.Center, DrawUtil.VAlign.Above, 0, 1.0f, 0xC0C0C0, 1.0f, 1.0, true);
            for (int k = 0; k < this.field_230710_m_.size(); ++k) {
                net.minecraft.client.gui.widget.button.Button guibutton = (net.minecraft.client.gui.widget.button.Button)this.field_230710_m_.get(k);
                guibutton.func_230430_a_(mStack, x, y, 0.0f);
            }
            if (this.colorPickTooltip != null && this.colorPickRect.contains(x, y)) {
                StringTextComponent tooltip = Constants.getStringTextComponent(this.colorPickTooltip);
                this.renderWrappedToolTip(mStack, this.getFontRenderer().func_238425_b_((ITextProperties)tooltip, 200), x, y, this.getFontRenderer());
                RenderHelper.func_74518_a();
            }
            this.drawTitle(mStack);
            this.drawLogo(mStack);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during WaypointEditor layout: " + LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    protected void drawWaypoint(MatrixStack mStack, int x, int y) {
        DrawUtil.drawColoredImage(mStack, this.wpTexture, this.currentColor, 1.0f, x, y - this.wpTexture.getHeight() / 2, 0.0);
    }

    protected void drawColorPicker(MatrixStack mStack, int x, int y, float size) {
        int sizeI = (int)size;
        WaypointEditor.func_238467_a_((MatrixStack)mStack, (int)(x - 1), (int)(y - 1), (int)(x + sizeI + 1), (int)(y + sizeI + 1), (int)-6250336);
        if (this.colorPickRect.width != (double)size) {
            Image image = this.colorPickTexture.getImage().getScaledInstance(sizeI, sizeI, 2);
            this.colorPickImg = new BufferedImage(sizeI, sizeI, 1);
            Graphics2D g = this.colorPickImg.createGraphics();
            g.drawImage(image, 0, 0, sizeI, sizeI, null);
            g.dispose();
        }
        this.colorPickRect.setRect(x, y, size, size);
        float scale = size / (float)this.colorPickTexture.getWidth();
        DrawUtil.drawImage(mStack, this.colorPickTexture, x, y, false, scale, 0.0);
    }

    protected void drawLabelAndField(MatrixStack mStack, String label, TextBox field, int x, int y) {
        field.func_212952_l(x);
        field.setY(y);
        FontRenderer fr = this.getFontRenderer();
        int width = fr.func_78256_a(label) + 4;
        WaypointEditor.func_238476_c_((MatrixStack)mStack, (FontRenderer)this.getFontRenderer(), (String)label, (int)(x - width), (int)(y + (field.func_238483_d_() - 8) / 2), (int)Color.cyan.getRGB());
        field.func_230430_a_(mStack, x, y, this.partialTicks);
    }

    protected void drawLabel(MatrixStack mStack, String label, int x, int y) {
        WaypointEditor.func_238476_c_((MatrixStack)mStack, (FontRenderer)this.getFontRenderer(), (String)label, (int)x, (int)y, (int)Color.cyan.getRGB());
    }

    @Override
    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
            case 257: {
                this.save();
                return true;
            }
            case 258: {
                this.validate();
                this.onTab();
                return true;
            }
        }
        for (TextFieldWidget textFieldWidget : this.fieldList) {
            textFieldWidget.func_231046_a_(keyCode, scanCode, modifiers);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.openedWithHotKey && this.isNew) {
            this.openedWithHotKey = false;
            return true;
        }
        for (TextFieldWidget textFieldWidget : this.fieldList) {
            textFieldWidget.func_231042_a_(typedChar, keyCode);
        }
        this.updateWaypointFromForm();
        this.validate();
        return true;
    }

    @Override
    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.dimScrollPane.func_231048_c_(mouseX, mouseY, mouseButton);
        for (TextFieldWidget textFieldWidget : this.fieldList) {
            textFieldWidget.func_231048_c_(mouseX, mouseY, mouseButton);
        }
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        for (TextFieldWidget textFieldWidget : this.fieldList) {
            textFieldWidget.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
        }
        this.checkColorPicker(mouseX, mouseY);
        this.dimScrollPane.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.func_231045_a_(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean func_231043_a_(double x, double y, double scroll) {
        this.dimScrollPane.func_231043_a_(x, y, scroll);
        return super.func_231043_a_(x, y, scroll);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            for (TextFieldWidget textFieldWidget : this.fieldList) {
                textFieldWidget.func_231044_a_(mouseX, mouseY, mouseButton);
            }
            this.checkColorPicker(mouseX, mouseY);
            this.dimScrollPane.func_231044_a_(mouseX, mouseY, mouseButton);
            Button button = this.dimScrollPane.mouseClicked((int)mouseX, (int)mouseY, mouseButton);
            if (button != null) {
                this.actionPerformed(button);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            this.setFormColor(this.colorPickImg.getRGB(x, y));
        }
    }

    protected void setFormColor(Integer color) {
        this.currentColor = color;
        int[] c = RGB.ints(color);
        this.fieldR.func_146180_a(Integer.toString(c[0]));
        this.fieldG.func_146180_a(Integer.toString(c[1]));
        this.fieldB.func_146180_a(Integer.toString(c[2]));
        this.updateWaypointFromForm();
    }

    protected void actionPerformed(net.minecraft.client.gui.widget.button.Button guibutton) {
        if (this.dimButtonList.contains(guibutton)) {
            DimensionButton dimButton = (DimensionButton)guibutton;
            dimButton.toggle();
            this.updateWaypointFromForm();
        }
    }

    protected void setRandomColor() {
        this.editedWaypoint.setRandomColor();
        this.setFormColor(this.editedWaypoint.getIconColor());
    }

    protected void onTab() {
        boolean focusNext = false;
        boolean foundFocus = false;
        for (TextBox field : this.fieldList) {
            if (focusNext) {
                field.func_146195_b(true);
                foundFocus = true;
                break;
            }
            if (!field.func_230999_j_()) continue;
            field.func_146195_b(false);
            field.clamp();
            focusNext = true;
        }
        if (!foundFocus) {
            this.fieldList.get(0).func_146195_b(true);
        }
    }

    protected boolean validate() {
        boolean valid = true;
        if (this.fieldName != null) {
            boolean bl = valid = this.fieldName.hasMinLength() && Strings.isNotEmpty((CharSequence)this.fieldName.func_146179_b());
        }
        if (valid && this.fieldY != null) {
            valid = this.fieldY.hasMinLength();
        }
        if (this.buttonSave != null) {
            this.buttonSave.setEnabled(valid && (this.isNew || !this.originalWaypoint.equals(this.editedWaypoint)));
        }
        return valid;
    }

    protected void remove() {
        WaypointStore.INSTANCE.remove(this.originalWaypoint, true);
        this.refreshAndClose(null);
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        this.updateWaypointFromForm();
        WaypointStore.INSTANCE.remove(this.originalWaypoint, false);
        WaypointStore.INSTANCE.save(this.editedWaypoint, this.isNew);
        this.refreshAndClose(this.editedWaypoint);
    }

    protected void resetForm() {
        this.editedWaypoint = new Waypoint(this.originalWaypoint);
        this.dimButtonList.clear();
        this.fieldList.clear();
        this.field_230710_m_.clear();
        this.func_231160_c_();
        this.validate();
    }

    protected void updateWaypointFromForm() {
        this.currentColor = RGB.toInteger(this.getSafeColorInt(this.fieldR), this.getSafeColorInt(this.fieldG), this.getSafeColorInt(this.fieldB));
        this.editedWaypoint.setColor(this.currentColor);
        this.fieldName.func_146193_g(this.editedWaypoint.getSafeColor());
        ArrayList<String> dims = new ArrayList<String>();
        for (DimensionButton db : this.dimButtonList) {
            if (!db.getToggled().booleanValue()) continue;
            dims.add(db.dimension);
        }
        this.editedWaypoint.setDimensions(dims);
        this.editedWaypoint.setEnable(this.buttonEnable.getToggled());
        this.editedWaypoint.setName(this.fieldName.func_146179_b());
        this.editedWaypoint.setLocation(this.getSafeCoordInt(this.fieldX), this.getSafeCoordInt(this.fieldY), this.getSafeCoordInt(this.fieldZ), DimensionHelper.getDimKeyName((Entity)this.field_230706_i_.field_71439_g));
    }

    protected int getSafeColorInt(TextBox field) {
        field.clamp();
        String text = field.func_146179_b();
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return Math.max(0, Math.min(255, val));
    }

    protected int getSafeCoordInt(TextBox field) {
        String text = field.func_146179_b();
        if (text == null || text.isEmpty() || text.equals("-")) {
            return 0;
        }
        int val = 0;
        try {
            val = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    protected void refreshAndClose(Waypoint focusWaypoint) {
        if (returnDisplayStack != null && returnDisplayStack.peek() != null && returnDisplayStack.peek() instanceof WaypointManager) {
            ((WaypointManager)((Object)returnDisplayStack.peek())).setFocusWaypoint(focusWaypoint);
        }
        Fullscreen.state().requireRefresh();
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open((Screen)returnDisplayStack.pop());
        }
    }

    class DimensionButton
    extends OnOffButton {
        public final String dimension;

        DimensionButton(String dimension, String dimensionName, boolean toggled) {
            super(String.format("%s: %s", dimensionName, Constants.getString("jm.common.on")), String.format("%s: %s", dimensionName, Constants.getString("jm.common.off")), toggled, Button.emptyPressable());
            this.dimension = dimension;
            this.setToggled(toggled);
        }
    }
}

