/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public enum FlowerBlockProxy implements IBlockColorProxy
{
    INSTANCE;

    boolean enabled = true;
    private final BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        Integer color;
        if (blockMD.getBlock() instanceof FlowerBlock && (color = this.getFlowerColor(blockMD.getBlockState())) != null) {
            return color;
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        if (blockMD.getBlock() instanceof FlowerBlock) {
            return blockMD.getTextureColor();
        }
        if (blockMD.getBlock() instanceof FlowerPotBlock && JourneymapClient.getInstance().getCoreProperties().mapPlants.get().booleanValue()) {
            try {
                BlockState blockState = blockMD.getBlockState();
                ItemStack iStack = ((FlowerPotBlock)blockState.func_177230_c()).func_185473_a((IBlockReader)chunkMD.getWorld(), blockPos, blockState);
                if (iStack != null) {
                    BlockState contentBlockState = Block.func_149634_a((Item)iStack.func_77973_b()).func_176223_P();
                    return BlockMD.get(contentBlockState).getTextureColor();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error checking FlowerPot: " + e, (Object)LogFormatter.toPartialString(e));
                this.enabled = false;
            }
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().getBlockColor(chunkMD, blockMD, blockPos);
    }

    private Integer getFlowerColor(BlockState blockState) {
        Block block;
        if (blockState.func_177230_c() instanceof FlowerBlock && (block = blockState.func_177230_c()) != null) {
            switch (block.getRegistryName().func_110623_a()) {
                case "poppy": {
                    return 9962502;
                }
                case "blue_orchid": {
                    return 1998518;
                }
                case "allium": {
                    return 8735158;
                }
                case "azure_bluet": {
                    return 10330535;
                }
                case "red_tulip": {
                    return 9962502;
                }
                case "orange_tulip": {
                    return 10704922;
                }
                case "white_tulip": {
                    return 0xB0B0B0;
                }
                case "pink_tulip": {
                    return 11573936;
                }
                case "oxeye_daisy": {
                    return 0xB3B3B3;
                }
                case "dandelion": {
                    return 11514881;
                }
                case "cornflower": {
                    return 3361970;
                }
                case "lily_of_the_valley": {
                    return 0xFFFFFF;
                }
                case "wither_rose": {
                    return 0x191919;
                }
            }
            return 0;
        }
        return null;
    }
}

