/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.forge.event;

import java.util.Collection;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.event.forge.PopupMenuEvent;
import journeymap.client.api.model.IFullscreen;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.forge.event.EventHandlerManager;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.Waypoint;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PopupMenuEventHandler
implements EventHandlerManager.EventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onFullscreenPopupMenu(PopupMenuEvent.FullscreenPopupMenuEvent event) {
        try {
            if (!event.isCanceled()) {
                ModPopupMenu menu = event.getPopupMenu();
                if (CmdTeleportWaypoint.isPermitted(Minecraft.func_71410_x())) {
                    menu.addMenuItem(Constants.getString("jm.waypoint.teleport"), this.doTeleport(event.getFullscreen()));
                }
                if (JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) {
                    menu.createSubItemList(Constants.getString("jm.waypoint.waypoints")).addMenuItem(Constants.getString("key.journeymap.create_waypoint"), this.createWaypoint(event.getFullscreen(), false)).addMenuItem(Constants.getString("jm.waypoint.create_temp_waypoint"), this.createWaypoint(event.getFullscreen(), true)).addMenuItem(Constants.getString("jm.waypoint.show_all"), b -> WaypointStore.INSTANCE.getAll().forEach(wp -> wp.setEnable(true).setDirty())).addMenuItem(Constants.getString("jm.waypoint.hide_all"), b -> WaypointStore.INSTANCE.getAll().forEach(wp -> wp.setEnable(false).setDirty()));
                }
                menu.addMenuItem(Constants.getString("key.journeymap.fullscreen.menu.chat_position"), this.chatAtPos(event.getFullscreen()));
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error handling PopupMenuEvent.FullscreenPopupMenuEvent", (Throwable)e);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onWaypointPopupMenu(PopupMenuEvent.WaypointPopupMenuEvent event) {
        try {
            if (!event.isCanceled() && JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) {
                ModPopupMenu menu = event.getPopupMenu();
                Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
                Waypoint waypoint = waypoints.stream().filter(wp -> event.getWaypoint().getId().equals(wp.getId())).findAny().orElse(null);
                if (waypoint != null) {
                    if (CmdTeleportWaypoint.isPermitted(Minecraft.func_71410_x()) && CmdTeleportWaypoint.isPermitted(Minecraft.func_71410_x())) {
                        menu.addMenuItem(Constants.getString("jm.waypoint.teleport"), blockPos -> new CmdTeleportWaypoint(waypoint).run());
                    }
                    menu.addMenuItem(Constants.getString("jm.waypoint.edit"), blockPos -> UIManager.INSTANCE.openWaypointEditor(waypoint, false, (Fullscreen)event.getFullscreen()));
                    menu.addMenuItem(Constants.getString("jm.waypoint.disable"), blockPos -> {
                        waypoint.setEnable(false).setDirty();
                        WaypointStore.INSTANCE.save(waypoint, false);
                    });
                    menu.addMenuItem(Constants.getString("jm.waypoint.remove"), blockPos -> WaypointStore.INSTANCE.remove(waypoint, true));
                }
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error handling PopupMenuEvent.FullscreenPopupMenuEvent", (Throwable)e);
        }
    }

    private ModPopupMenu.Action chatAtPos(IFullscreen fullscreen) {
        return blockPos -> {
            Waypoint waypoint = Waypoint.at(blockPos, Waypoint.Type.Normal, fullscreen.getMinecraft().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString());
            ((Fullscreen)fullscreen).chatOpenedFromEvent = true;
            ((Fullscreen)fullscreen).openChat(waypoint.toChatString());
        };
    }

    private ModPopupMenu.Action createWaypoint(IFullscreen fullscreen, boolean temp) {
        return blockPos -> {
            int y = blockPos.func_177956_o();
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, ((Fullscreen)fullscreen).getMapType());
            if (regionData != null) {
                regionData.getTopY(blockPos);
            }
            BlockPos pos = new BlockPos(blockPos.func_177958_n(), y + 1, blockPos.func_177952_p());
            Waypoint waypoint = Waypoint.at(pos, Waypoint.Type.Normal, fullscreen.getMinecraft().field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().toString());
            if (temp) {
                waypoint.setOrigin("temp");
                waypoint.setName(Constants.getString("jm.waypoint.temp") + waypoint.getName());
                waypoint.updateId();
                WaypointStore.INSTANCE.save(waypoint, true);
            } else {
                UIManager.INSTANCE.openWaypointEditor(waypoint, true, (Fullscreen)fullscreen);
            }
        };
    }

    private ModPopupMenu.Action doTeleport(IFullscreen fullscreen) {
        return blockPos -> {
            int y = blockPos.func_177956_o();
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, ((Fullscreen)fullscreen).getMapType());
            if (regionData != null) {
                y = regionData.getTopY(blockPos);
            }
            BlockPos pos = new BlockPos(blockPos.func_177958_n(), y + 1, blockPos.func_177952_p());
            CmdTeleportWaypoint.teleport(pos, (RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
        };
    }
}

