/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.api.impl;

import journeymap.client.api.model.IBlockInfo;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class BlockInfo
implements IBlockInfo {
    private BlockPos blockPos;
    private Block block;
    private BlockState blockState;
    private Biome biome;
    private Chunk chunk;
    private ChunkPos chunkPos;
    private Integer regionX;
    private Integer regionZ;

    private BlockInfo(Builder builder) {
        this.blockPos = builder.blockPos;
        this.block = builder.block;
        this.blockState = builder.blockState;
        this.biome = builder.biome;
        this.chunk = builder.chunk;
        this.chunkPos = builder.chunkPos;
        this.regionX = builder.regionX;
        this.regionZ = builder.regionZ;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    @Override
    public Integer getRegionX() {
        return this.regionX;
    }

    @Override
    public Integer getRegionZ() {
        return this.regionZ;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BlockPos blockPos;
        private Block block;
        private BlockState blockState;
        private Biome biome;
        private Chunk chunk;
        private ChunkPos chunkPos;
        private Integer regionX;
        private Integer regionZ;

        public BlockInfo build() {
            return new BlockInfo(this);
        }

        public Builder withBlockPos(BlockPos blockPos) {
            this.blockPos = blockPos;
            return this;
        }

        public Builder withBlock(Block block) {
            this.block = block;
            return this;
        }

        public Builder withBlockState(BlockState blockState) {
            this.blockState = blockState;
            return this;
        }

        public Builder withBiome(Biome biome) {
            this.biome = biome;
            return this;
        }

        public Builder withChunk(Chunk chunk) {
            this.chunk = chunk;
            return this;
        }

        public Builder withChunkPos(ChunkPos chunkPos) {
            this.chunkPos = chunkPos;
            return this;
        }

        public Builder withRegionX(Integer regionX) {
            this.regionX = regionX;
            return this;
        }

        public Builder withRegionZ(Integer regionZ) {
            this.regionZ = regionZ;
            return this;
        }
    }
}

