/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.function.Supplier;
import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class PacketRequestDataFromServer {
    protected BlockPos pos;
    private RegistryKey<World> type;
    protected String command;
    protected TypedMap params;
    private boolean dummy;

    public PacketRequestDataFromServer(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.type = LevelTools.getId(buf.func_192575_l());
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        this.params = TypedMapTools.readArguments(buf);
        this.dummy = buf.readBoolean();
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_192572_a(this.type.func_240901_a_());
        buf.func_180714_a(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        buf.writeBoolean(this.dummy);
    }

    public PacketRequestDataFromServer(RegistryKey<World> type, BlockPos pos, String command, TypedMap params, boolean dummy) {
        this.type = type;
        this.pos = pos;
        this.command = command;
        this.params = params;
        this.dummy = dummy;
    }

    public PacketRequestDataFromServer(RegistryKey<World> type, BlockPos pos, ICommand command, TypedMap params, boolean dummy) {
        this.type = type;
        this.pos = pos;
        this.command = command.getName();
        this.params = params;
        this.dummy = dummy;
    }

    public void handle(SimpleChannel channel, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            ServerWorld world = LevelTools.getLevel(ctx.getSender().func_130014_f_(), this.type);
            if (world.func_175667_e(this.pos)) {
                TypedMap result;
                TileEntity te = world.func_175625_s(this.pos);
                if (te instanceof GenericTileEntity && (result = ((GenericTileEntity)te).executeServerCommandWR(this.command, (PlayerEntity)ctx.getSender(), this.params)) != null) {
                    PacketDataFromServer msg = new PacketDataFromServer(this.dummy ? null : this.pos, this.command, result);
                    channel.sendTo((Object)msg, ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        });
        ctx.setPacketHandled(true);
    }
}

