/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.deferred;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.SpawnEggItem;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.registration.ItemProperties;
import slimeknights.mantle.registration.deferred.DeferredRegisterWrapper;

public class EntityTypeDeferredRegister
extends DeferredRegisterWrapper<EntityType<?>> {
    private final DeferredRegister<Item> itemRegistry;

    public EntityTypeDeferredRegister(String modID) {
        super(ForgeRegistries.ENTITIES, modID);
        this.itemRegistry = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modID);
    }

    @Override
    public void register(IEventBus bus) {
        super.register(bus);
        this.itemRegistry.register(bus);
    }

    public <T extends Entity> RegistryObject<EntityType<T>> register(String name, Supplier<EntityType.Builder<T>> sup) {
        return this.register.register(name, () -> ((EntityType.Builder)sup.get()).func_206830_a(this.resourceName(name)));
    }

    public <T extends Entity> RegistryObject<EntityType<T>> registerWithEgg(String name, Supplier<EntityType.Builder<T>> sup, int primary, int secondary) {
        Lazy lazy = Lazy.of(() -> ((EntityType.Builder)sup.get()).func_206830_a(this.resourceName(name)));
        this.itemRegistry.register(name + "_spawn_egg", () -> new SpawnEggItem((EntityType)lazy.get(), primary, secondary, ItemProperties.EGG_PROPS));
        return this.register.register(name, (Supplier)lazy);
    }
}

