/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.inventory;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3f;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.util.JsonHelper;

public class ModelItem {
    private static final ModelItem EMPTY = new ModelItem(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0.0f, 0.0f);
    private final Vector3f center;
    private final float size;
    private final float x;
    private final float y;
    private final ItemCameraTransforms.TransformType transform;
    private Vector3f centerScaled;
    private Float sizeScaled;

    public ModelItem(Vector3f center, float size, float x, float y) {
        this(center, size, x, y, ItemCameraTransforms.TransformType.NONE);
    }

    public ModelItem(Vector3f center, float size, float x, float y, ItemCameraTransforms.TransformType transform) {
        this.center = center;
        this.size = size;
        this.x = x;
        this.y = y;
        this.transform = transform;
    }

    public Vector3f getCenterScaled() {
        if (this.centerScaled == null) {
            this.centerScaled = this.center.func_229195_e_();
            this.centerScaled.func_195898_a(0.0625f);
        }
        return this.centerScaled;
    }

    public float getSizeScaled() {
        if (this.sizeScaled == null) {
            this.sizeScaled = Float.valueOf(this.size / 16.0f);
        }
        return this.sizeScaled.floatValue();
    }

    public boolean isHidden() {
        return this.size == 0.0f;
    }

    private static ItemCameraTransforms.TransformType parseTransformType(JsonObject json, String key) {
        String name;
        switch (name = JSONUtils.func_151219_a((JsonObject)json, (String)key, (String)"none")) {
            case "none": {
                return ItemCameraTransforms.TransformType.NONE;
            }
            case "head": {
                return ItemCameraTransforms.TransformType.HEAD;
            }
            case "gui": {
                return ItemCameraTransforms.TransformType.GUI;
            }
            case "ground": {
                return ItemCameraTransforms.TransformType.GROUND;
            }
            case "fixed": {
                return ItemCameraTransforms.TransformType.FIXED;
            }
            case "thirdperson_righthand": {
                return ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            case "thirdperson_lefthand": {
                return ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND;
            }
            case "firstperson_righthand": {
                return ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND;
            }
            case "firstperson_lefthand": {
                return ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
            }
        }
        throw new JsonSyntaxException("Unknown transform type " + name);
    }

    public static ModelItem fromJson(JsonObject json) {
        float size = JSONUtils.func_151217_k((JsonObject)json, (String)"size");
        if (size == 0.0f) {
            return EMPTY;
        }
        Vector3f center = ModelHelper.arrayToVector(json, "center");
        float x = ModelHelper.getRotation(json, "x");
        float y = ModelHelper.getRotation(json, "y");
        ItemCameraTransforms.TransformType transformType = ModelItem.parseTransformType(json, "transform");
        return new ModelItem(center, size, x, y, transformType);
    }

    public static List<ModelItem> listFromJson(JsonObject parent, String key) {
        return JsonHelper.parseList(parent, key, ModelItem::fromJson);
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getSize() {
        return this.size;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public ItemCameraTransforms.TransformType getTransform() {
        return this.transform;
    }
}

