/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.registration.ModelFluidAttributes;

public class FluidTextureModel
implements IModelGeometry<FluidTextureModel> {
    public static Loader LOADER = new Loader();
    private final int color;

    private static boolean isMissing(RenderMaterial material) {
        return MissingTextureSprite.func_195675_b().equals((Object)material.func_229313_b_());
    }

    private static void getTexture(IModelConfiguration owner, String name, Collection<RenderMaterial> textures, Set<Pair<String, String>> missingTextureErrors) {
        RenderMaterial material = owner.resolveTexture(name);
        if (FluidTextureModel.isMissing(material)) {
            missingTextureErrors.add((Pair<String, String>)Pair.of((Object)name, (Object)owner.getModelName()));
        }
        textures.add(material);
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet<RenderMaterial> textures = new HashSet<RenderMaterial>();
        FluidTextureModel.getTexture(owner, "still", textures, missingTextureErrors);
        FluidTextureModel.getTexture(owner, "flowing", textures, missingTextureErrors);
        RenderMaterial overlay = owner.resolveTexture("overlay");
        if (!FluidTextureModel.isMissing(overlay)) {
            textures.add(overlay);
        }
        return textures;
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        RenderMaterial still = owner.resolveTexture("still");
        RenderMaterial flowing = owner.resolveTexture("flowing");
        RenderMaterial overlay = owner.resolveTexture("overlay");
        ResourceLocation overlayLocation = FluidTextureModel.isMissing(overlay) ? null : overlay.func_229313_b_();
        IBakedModel baked = new SimpleBakedModel.Builder(owner, overrides).func_177646_a(spriteGetter.apply(still)).func_177645_b();
        return new BakedModel(baked, still.func_229313_b_(), flowing.func_229313_b_(), overlayLocation, this.color);
    }

    public FluidTextureModel(int color) {
        this.color = color;
    }

    private static class Loader
    implements IModelLoader<FluidTextureModel>,
    ModelFluidAttributes.IFluidModelProvider {
        private final Map<Fluid, BakedModel> modelCache = new HashMap<Fluid, BakedModel>();

        private Loader() {
        }

        @Nullable
        private BakedModel getFluidModel(Fluid fluid) {
            return ModelHelper.getBakedModel(fluid.func_207188_f().func_206883_i(), BakedModel.class);
        }

        @Nullable
        private BakedModel getCachedModel(Fluid fluid) {
            return this.modelCache.computeIfAbsent(fluid, this::getFluidModel);
        }

        @Override
        @Nullable
        public ResourceLocation getStillTexture(Fluid fluid) {
            BakedModel model = this.getCachedModel(fluid);
            return model == null ? null : model.getStill();
        }

        @Override
        @Nullable
        public ResourceLocation getFlowingTexture(Fluid fluid) {
            BakedModel model = this.getCachedModel(fluid);
            return model == null ? null : model.getFlowing();
        }

        @Override
        @Nullable
        public ResourceLocation getOverlayTexture(Fluid fluid) {
            BakedModel model = this.getCachedModel(fluid);
            return model == null ? null : model.getOverlay();
        }

        @Override
        public int getColor(Fluid fluid) {
            BakedModel model = this.getCachedModel(fluid);
            return model == null ? -1 : model.getColor();
        }

        public void func_195410_a(IResourceManager resourceManager) {
            this.modelCache.clear();
        }

        public FluidTextureModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            int color = -1;
            if (modelContents.has("color")) {
                String colorString = JSONUtils.func_151200_h((JsonObject)modelContents, (String)"color");
                int length = colorString.length();
                if (colorString.charAt(0) == '-' || length != 6 && length != 8) {
                    throw new JsonSyntaxException("Invalid color '" + colorString + "'");
                }
                try {
                    color = (int)Long.parseLong(colorString, 16);
                    if (length == 6) {
                        color |= 0xFF000000;
                    }
                }
                catch (NumberFormatException e) {
                    throw new JsonSyntaxException("Invalid color '" + colorString + "'");
                }
            }
            return new FluidTextureModel(color);
        }
    }

    private static class BakedModel
    extends BakedModelWrapper<IBakedModel> {
        private final ResourceLocation still;
        private final ResourceLocation flowing;
        private final ResourceLocation overlay;
        private final int color;

        public BakedModel(IBakedModel originalModel, ResourceLocation still, ResourceLocation flowing, @Nullable ResourceLocation overlay, int color) {
            super(originalModel);
            this.still = still;
            this.flowing = flowing;
            this.overlay = overlay;
            this.color = color;
        }

        public ResourceLocation getStill() {
            return this.still;
        }

        public ResourceLocation getFlowing() {
            return this.flowing;
        }

        public ResourceLocation getOverlay() {
            return this.overlay;
        }

        public int getColor() {
            return this.color;
        }
    }
}

