/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.machine;

import cofh.lib.client.audio.ConditionalSound;
import cofh.lib.inventory.IItemStackAccess;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.lib.util.helpers.AugmentableHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.thermal.core.item.SlotSealItem;
import cofh.thermal.core.util.managers.machine.PulverizerRecipeManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.init.TExpSounds;
import cofh.thermal.expansion.inventory.container.machine.MachinePulverizerContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.MachineTileProcess;
import cofh.thermal.lib.util.recipes.IMachineInventory;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;

public class MachinePulverizerTile
extends MachineTileProcess {
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && PulverizerRecipeManager.instance().validRecipe(item));
    protected ItemStorageCoFH catalystSlot = new ItemStorageCoFH(item -> item.func_77973_b() instanceof SlotSealItem || PulverizerRecipeManager.instance().validCatalyst(item));
    protected boolean cyclicProcessingFeature = false;

    public MachinePulverizerTile() {
        super(TExpReferences.MACHINE_PULVERIZER_TILE);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlot(this.catalystSlot, StorageGroup.CATALYST);
        this.inventory.addSlots(StorageGroup.OUTPUT, 4);
        this.inventory.addSlot(this.chargeSlot, StorageGroup.INTERNAL);
        this.addAugmentSlots(ThermalConfig.machineAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return PulverizerRecipeManager.instance().getBasePower();
    }

    protected boolean cacheRecipe() {
        this.curRecipe = PulverizerRecipeManager.instance().getRecipe((IThermalInventory)this);
        this.curCatalyst = PulverizerRecipeManager.instance().getCatalyst((IItemStackAccess)this.catalystSlot);
        if (this.curRecipe != null) {
            this.itemInputCounts = this.curRecipe.getInputItemCounts((IMachineInventory)this);
        }
        return this.curRecipe != null;
    }

    protected void resolveInputs() {
        int decrement;
        this.inputSlot.modify(-((Integer)this.itemInputCounts.get(0)).intValue());
        if (this.cyclicProcessingFeature && !this.catalystSlot.isEmpty() && !this.catalystSlot.isFull()) {
            ItemStack catalyst = this.catalystSlot.getItemStack();
            for (ItemStorageCoFH slot : this.outputSlots()) {
                if (!ItemHelper.itemsEqualWithTags((ItemStack)slot.getItemStack(), (ItemStack)catalyst)) continue;
                slot.modify(-1);
                this.catalystSlot.modify(1);
                break;
            }
        }
        int n = decrement = this.itemInputCounts.size() > 1 ? (Integer)this.itemInputCounts.get(1) : 0;
        if (decrement > 0) {
            if (this.catalystSlot.getItemStack().func_77984_f()) {
                if (this.catalystSlot.getItemStack().func_96631_a(decrement, MathHelper.RANDOM, null)) {
                    this.catalystSlot.modify(-1);
                }
            } else {
                this.catalystSlot.modify(-decrement);
            }
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new MachinePulverizerContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    protected Object getSound() {
        return new ConditionalSound(TExpSounds.SOUND_MACHINE_PULVERIZER, SoundCategory.AMBIENT, (TileEntity)this, () -> !this.field_145846_f && this.isActive);
    }

    protected boolean validateInputs() {
        if (!this.cacheRecipe()) {
            return false;
        }
        return this.inputSlot.getCount() >= (Integer)this.itemInputCounts.get(0);
    }

    protected void resetAttributes() {
        super.resetAttributes();
        this.cyclicProcessingFeature = false;
    }

    protected void setAttributesFromAugment(CompoundNBT augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.cyclicProcessingFeature |= AugmentableHelper.getAttributeMod((CompoundNBT)augmentData, (String)"CycProc") > 0.0f;
    }
}

