/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.expansion.tileentity.dynamo;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.util.StorageGroup;
import cofh.thermal.core.util.managers.dynamo.GourmandFuelManager;
import cofh.thermal.expansion.init.TExpReferences;
import cofh.thermal.expansion.inventory.container.dynamo.DynamoGourmandContainer;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.tileentity.DynamoTileBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;

public class DynamoGourmandTile
extends DynamoTileBase {
    protected ItemStorageCoFH fuelSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && GourmandFuelManager.instance().validFuel(item));

    public DynamoGourmandTile() {
        super(TExpReferences.DYNAMO_GOURMAND_TILE);
        this.inventory.addSlot(this.fuelSlot, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalConfig.dynamoAugments);
        this.initHandlers();
    }

    protected int getBaseProcessTick() {
        return GourmandFuelManager.instance().getBasePower();
    }

    protected boolean canProcessStart() {
        return GourmandFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) > 0;
    }

    protected void processStart() {
        this.fuelMax = Math.round((float)GourmandFuelManager.instance().getEnergy(this.fuelSlot.getItemStack()) * this.energyMod);
        this.fuel += this.fuelMax;
        this.fuelSlot.consume(1);
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DynamoGourmandContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }
}

