/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.waila;

import bletch.pixelmoninformation.core.ModCommonConfig;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.api.pokemon.stats.IVStore;
import com.pixelmonmod.pixelmon.client.storage.ClientPlayerPokedex;
import com.pixelmonmod.pixelmon.entities.npcs.IndexedNPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import java.util.ArrayList;
import java.util.List;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.TooltipPosition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PixelmonEntityWaila
implements IEntityComponentProvider,
IServerDataProvider<Entity> {
    public static final PixelmonEntityWaila INSTANCE = new PixelmonEntityWaila();
    private static String NBT_TAG_EVSTORE = "pokemon_evstore";
    private static String NBT_TAG_IVSTORE = "pokemon_ivstore";
    private static String NBT_TAG_NATURE = "pokemon_nature";
    private static String NBT_TAG_NPCNAME = "npc_name";

    public void appendHead(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!ModCommonConfig.INSTANCE.wailaShowEntityInformation()) {
            return;
        }
        Entity entity = accessor.getEntity();
        CompoundNBT data = accessor.getServerData();
        if (entity instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)entity;
            Pokemon pokemon = pixelmon.getPokemon();
            String output = "";
            Object bossTier = pixelmon.getBossTier();
            if (bossTier.isBoss()) {
                switch (bossTier.getID()) {
                    case "common": {
                        output = output + TextFormatting.GRAY;
                        break;
                    }
                    case "uncommon": {
                        output = output + TextFormatting.GREEN;
                        break;
                    }
                    case "rare": {
                        output = output + TextFormatting.BLUE;
                        break;
                    }
                    case "epic": {
                        output = output + TextFormatting.DARK_PURPLE;
                        break;
                    }
                    case "legendary": {
                        output = output + TextFormatting.GOLD;
                        break;
                    }
                    case "ultimate": {
                        output = output + TextFormatting.AQUA;
                        break;
                    }
                    case "haunted": {
                        output = output + TextFormatting.LIGHT_PURPLE;
                        break;
                    }
                    case "drowned": {
                        output = output + TextFormatting.DARK_AQUA;
                        break;
                    }
                    default: {
                        output = output + TextFormatting.WHITE;
                    }
                }
                output = output + new TranslationTextComponent(bossTier.getName()).getString();
                output = output + " ";
            }
            output = output + TextFormatting.WHITE;
            output = output + pixelmon.getLocalizedName();
            if (pokemon != null) {
                String nickName = pokemon.getFormattedNickname().getString();
                if (!StringUtils.isNullOrWhitespace(nickName).booleanValue()) {
                    output = output + " ";
                    output = output + TextFormatting.ITALIC;
                    output = output + "(" + nickName + ")";
                }
                switch (pokemon.getGender()) {
                    case FEMALE: {
                        output = output + " ";
                        output = output + TextUtils.SYMBOL_FEMALE;
                        break;
                    }
                    case MALE: {
                        output = output + " ";
                        output = output + TextUtils.SYMBOL_MALE;
                        break;
                    }
                }
            }
            if (tooltip.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + output.trim()));
            } else {
                tooltip.set(0, (ITextComponent)new StringTextComponent(TextFormatting.RESET + output.trim()));
            }
        }
        if (entity instanceof NPCEntity) {
            String npcText;
            String output = "";
            if (data.func_74764_b(NBT_TAG_NPCNAME) && !StringUtils.isNullOrWhitespace(npcText = data.func_74779_i(NBT_TAG_NPCNAME)).booleanValue()) {
                output = output + TextFormatting.WHITE + npcText;
                output = output + " ";
            }
            if (entity instanceof NPCTrainer) {
                NPCTrainer npc = (NPCTrainer)entity;
                BossTier bossTier = npc.getBossTier();
                if (bossTier.isBoss()) {
                    switch (bossTier.getID()) {
                        case "common": {
                            output = output + TextFormatting.GRAY;
                            break;
                        }
                        case "uncommon": {
                            output = output + TextFormatting.GREEN;
                            break;
                        }
                        case "rare": {
                            output = output + TextFormatting.BLUE;
                            break;
                        }
                        case "epic": {
                            output = output + TextFormatting.DARK_PURPLE;
                            break;
                        }
                        case "legendary": {
                            output = output + TextFormatting.GOLD;
                            break;
                        }
                        case "ultimate": {
                            output = output + TextFormatting.AQUA;
                            break;
                        }
                        case "haunted": {
                            output = output + TextFormatting.LIGHT_PURPLE;
                            break;
                        }
                        case "drowned": {
                            output = output + TextFormatting.DARK_AQUA;
                            break;
                        }
                        default: {
                            output = output + TextFormatting.WHITE;
                        }
                    }
                    output = output + new TranslationTextComponent(bossTier.getName()).getString();
                    output = output + " ";
                }
                String npcLevel = npc.getSubTitleText() + " " + npc.getTrainerLevel();
                output = output + TextFormatting.WHITE;
                output = output + "(" + npcLevel.trim() + ")";
            }
            if (tooltip.isEmpty()) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RESET + output.trim()));
            } else {
                tooltip.set(0, (ITextComponent)new StringTextComponent(TextFormatting.RESET + output.trim()));
            }
        }
    }

    public void appendBody(List<ITextComponent> tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!ModCommonConfig.INSTANCE.wailaShowEntityInformation() || ModCommonConfig.INSTANCE.wailaUseCrouchKey() && !accessor.getPlayer().func_213453_ef()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Entity entity = accessor.getEntity();
        CompoundNBT data = accessor.getServerData();
        if (entity instanceof PixelmonEntity) {
            List<String> outputLines;
            String output2;
            int percentage;
            int maxTotal;
            int value;
            int total;
            BattleStatsType[] statTypes;
            EVStore store;
            String delimiter;
            String output;
            Object translateKey;
            List<String> outputLines2;
            String output3;
            PixelmonEntity pixelmon = (PixelmonEntity)entity;
            Pokemon pokemon = pixelmon.getPokemon();
            Species pokemonSpecies = pixelmon.getSpecies();
            Stats stats = pokemon.getForm();
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonDescription() && !StringUtils.isNullOrWhitespace(output3 = pokemonSpecies.getDescTranslation().getString()).booleanValue() && (outputLines2 = StringUtils.split(output3, minecraft, 4)) != null && !outputLines2.isEmpty()) {
                outputLines2.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l)));
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonOwner()) {
                translateKey = "gui.pokemon.owner";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pixelmon.hasOwner() && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String ownerName = pixelmon.getOwner().func_200200_C_().getString();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + ownerName));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonLevel()) {
                translateKey = "gui.pokemon.level";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    int level = pixelmon.getLvl().getPokemonLevel();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + level));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonPokedexNumber()) {
                translateKey = "gui.pokemon.dexnum";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemonSpecies != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String dexNumber = pokemonSpecies.getFormattedDex();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + dexNumber));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonGeneration()) {
                translateKey = "gui.pokemon.generation";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemonSpecies != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    int generation = pokemonSpecies.getGeneration();
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + generation));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonEVs()) {
                translateKey = "gui.pokemon.evstats";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String evStats = "";
                    delimiter = "";
                    store = null;
                    if (data.func_74764_b(NBT_TAG_EVSTORE)) {
                        store = new EVStore();
                        store.readFromNBT(data.func_74775_l(NBT_TAG_EVSTORE));
                    } else {
                        store = pokemon.getEVs();
                    }
                    statTypes = BattleStatsType.getEVIVStatValues();
                    total = 0;
                    for (BattleStatsType type : statTypes) {
                        value = store.getStat(type);
                        total += value;
                        evStats = evStats + delimiter;
                        evStats = evStats + type.getLocalizedName();
                        evStats = evStats + " (" + value + ")";
                        delimiter = ", ";
                    }
                    maxTotal = 510;
                    percentage = (int)(100.0 / (double)maxTotal * (double)total);
                    output2 = TextFormatting.DARK_AQUA + output + " " + TextFormatting.YELLOW + total + "/" + maxTotal + " (" + percentage + "%) " + TextFormatting.WHITE + "- " + evStats;
                    outputLines = StringUtils.split(output2, minecraft, 4);
                    if (outputLines != null && !outputLines.isEmpty()) {
                        outputLines.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l)));
                    }
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonIVs()) {
                translateKey = "gui.pokemon.ivstats";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String ivStats = "";
                    delimiter = "";
                    store = null;
                    if (data.func_74764_b(NBT_TAG_IVSTORE)) {
                        store = new IVStore();
                        store.readFromNBT(data.func_74775_l(NBT_TAG_IVSTORE));
                    } else {
                        store = pokemon.getIVs();
                    }
                    statTypes = BattleStatsType.getEVIVStatValues();
                    total = 0;
                    for (BattleStatsType type : statTypes) {
                        value = store.getStat(type);
                        total += value;
                        ivStats = ivStats + delimiter;
                        ivStats = ivStats + type.getTranslatedName().getString();
                        ivStats = ivStats + " (" + value + ")";
                        delimiter = ", ";
                    }
                    maxTotal = 31 * statTypes.length;
                    percentage = (int)(100.0 / (double)maxTotal * (double)total);
                    output2 = TextFormatting.DARK_AQUA + output + " " + TextFormatting.YELLOW + total + "/" + maxTotal + " (" + percentage + "%) " + TextFormatting.WHITE + "- " + ivStats;
                    outputLines = StringUtils.split(output2, minecraft, 4);
                    if (outputLines != null && !outputLines.isEmpty()) {
                        outputLines.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l)));
                    }
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonEVYield()) {
                translateKey = "gui.pokemon.evyield";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (stats != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String evYield = "";
                    delimiter = "";
                    BattleStatsType[] statValues = BattleStatsType.getEVIVStatValues();
                    EVYields evYields = stats.getEVYields();
                    for (int i = 0; i < statValues.length; ++i) {
                        int evYieldValue = evYields.getYield(statValues[i]);
                        if (evYieldValue <= 0) continue;
                        evYield = evYield + delimiter;
                        evYield = evYield + statValues[i].getTranslatedName().getString();
                        evYield = evYield + " (" + evYieldValue + ")";
                        delimiter = ", ";
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + evYield));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonNatureInformation()) {
                translateKey = "gui.pokemon.nature";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String natureName = "";
                    Nature nature = null;
                    nature = data.func_74764_b(NBT_TAG_NATURE) ? Nature.getNatureFromIndex((int)data.func_74762_e(NBT_TAG_NATURE)) : pokemon.getNature();
                    if (nature != null) {
                        natureName = natureName + nature.getTranslatedName().getString();
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + natureName));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonGrowthInformation()) {
                translateKey = "gui.pokemon.growth";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String growthName = "";
                    EnumGrowth growth = pokemon.getGrowth();
                    if (growth != null) {
                        growthName = growthName + growth.getTranslatedName().getString();
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + growthName));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonTypeInformation()) {
                translateKey = "gui.pokemon.type";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (stats != null && I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String types = "";
                    delimiter = "";
                    for (Element type : stats.getTypes()) {
                        types = types + delimiter;
                        types = types + type.getTranslatedName().getString();
                        delimiter = ", ";
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + types));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonTypeMatchupInformation() && stats != null) {
                for (Element type : stats.getTypes()) {
                    String typeName = type.getTranslatedName().getString();
                    String typeValue = type.name().toLowerCase();
                    String output4 = "";
                    String translateKey2 = "";
                    translateKey2 = "pokemontype." + typeValue + ".strong";
                    output4 = new TranslationTextComponent(translateKey2).getString();
                    if (I18n.func_188566_a((String)translateKey2) && !StringUtils.isNullOrWhitespace(output4).booleanValue()) {
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + typeName + ": " + output4));
                    }
                    translateKey2 = "pokemontype." + typeValue + ".weak";
                    output4 = new TranslationTextComponent(translateKey2).getString();
                    if (I18n.func_188566_a((String)translateKey2) && !StringUtils.isNullOrWhitespace(output4).booleanValue()) {
                        tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + typeName + ": " + output4));
                    }
                    translateKey2 = "pokemontype." + typeValue + ".bad";
                    output4 = new TranslationTextComponent(translateKey2).getString();
                    if (!I18n.func_188566_a((String)translateKey2) || StringUtils.isNullOrWhitespace(output4).booleanValue()) continue;
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + typeName + ": " + output4));
                }
            }
            if (ModCommonConfig.INSTANCE.wailaEntityShowPokemonCaught()) {
                translateKey = "gui.pokemon.caught";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue()) {
                    String caughtStatus = TextUtils.SYMBOL_UNKNOWN;
                    ClientPlayerPokedex pokedex = PixelmonUtils.getClientPokedex();
                    if (pokedex != null) {
                        caughtStatus = pokedex.hasCaught(pokemonSpecies) ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS;
                    }
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + caughtStatus));
                }
            }
        }
    }

    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, Entity entity) {
        PixelmonEntity pixelmon;
        Pokemon pokemon;
        if (entity instanceof PixelmonEntity && (pokemon = (pixelmon = (PixelmonEntity)entity).getPokemon()) != null) {
            CompoundNBT evTag = new CompoundNBT();
            EVStore evStore = pokemon.getEVs();
            evStore.writeToNBT(evTag);
            CompoundNBT ivTag = new CompoundNBT();
            IVStore ivStore = pokemon.getIVs();
            ivStore.writeToNBT(ivTag);
            Nature nature = pokemon.getNature();
            data.func_218657_a(NBT_TAG_EVSTORE, (INBT)evTag);
            data.func_218657_a(NBT_TAG_IVSTORE, (INBT)ivTag);
            data.func_74768_a(NBT_TAG_NATURE, nature.ordinal());
        }
        if (entity instanceof NPCEntity) {
            NPCFisherman entityNPC;
            String langCode = player.getLanguage();
            String npcName = "";
            if (entity instanceof NPCFisherman) {
                entityNPC = (NPCFisherman)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (entity instanceof NPCNurseJoy) {
                entityNPC = (NPCNurseJoy)entity;
                String nameKey = entityNPC.getTextureIndex() == 1 ? "gui.nursejoy.name" : "gui.doctorjohn.name";
                npcName = new TranslationTextComponent(nameKey).getString();
            }
            if (entity instanceof NPCQuestGiver) {
                entityNPC = (NPCQuestGiver)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (entity instanceof NPCRelearner) {
                entityNPC = (NPCRelearner)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (entity instanceof NPCShopkeeper) {
                entityNPC = (NPCShopkeeper)entity;
                npcName = entityNPC.getShopkeeperName(langCode);
            }
            if (entity instanceof NPCTrader) {
                entityNPC = (NPCTrader)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (entity instanceof NPCTrainer) {
                entityNPC = (NPCTrainer)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (entity instanceof NPCTutor) {
                entityNPC = (NPCTutor)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (StringUtils.isNullOrWhitespace(npcName).booleanValue() && entity instanceof NPCChatting) {
                entityNPC = (NPCChatting)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (StringUtils.isNullOrWhitespace(npcName).booleanValue() && entity instanceof IndexedNPCEntity) {
                entityNPC = (IndexedNPCEntity)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (!StringUtils.isNullOrWhitespace(npcName).booleanValue()) {
                data.func_74778_a(NBT_TAG_NPCNAME, npcName);
            }
        }
    }

    public void register(IRegistrar registrar) {
        ArrayList<String> processed = new ArrayList<String>();
        ArrayList entityClasses = new ArrayList();
        entityClasses.addAll(PixelmonUtils.getPixelmonEntityClasses());
        for (int i = entityClasses.size() - 1; i >= 0; --i) {
            if (!entityClasses.contains(((Class)entityClasses.get(i)).getSuperclass())) continue;
            entityClasses.remove(i);
        }
        for (Class clazz : entityClasses) {
            String key = clazz.getTypeName();
            if (processed.contains(key)) continue;
            processed.add(key);
            registrar.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.HEAD, clazz);
            registrar.registerComponentProvider((IEntityComponentProvider)this, TooltipPosition.BODY, clazz);
            registrar.registerEntityDataProvider((IServerDataProvider)this, clazz);
        }
    }
}

