/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.waila;

import bletch.pixelmoninformation.core.ModCommonConfig;
import bletch.pixelmoninformation.utils.PixelmonUtils;
import bletch.pixelmoninformation.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.TooltipPosition;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class PixelmonBlockWaila
implements IComponentProvider,
IServerDataProvider<TileEntity> {
    public static final PixelmonBlockWaila INSTANCE = new PixelmonBlockWaila();
    private static final String NBT_TAG_TILEENTITY = "tileentity";

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        List<String> outputLines;
        String output;
        String translateKey;
        if (!ModCommonConfig.INSTANCE.wailaShowBlockInformation() || ModCommonConfig.INSTANCE.wailaUseCrouchKey() && !accessor.getPlayer().func_213453_ef()) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Block block = accessor.getBlock();
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return;
        }
        String resourceDomain = registryName.func_110624_b();
        if (resourceDomain == null || !resourceDomain.equalsIgnoreCase("pixelmon")) {
            return;
        }
        if (ModCommonConfig.INSTANCE.wailaBlocksShowTooltip()) {
            translateKey = registryName.func_110623_a() + ".ptooltip";
            output = new TranslationTextComponent(translateKey).getString();
            if (I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue() && (outputLines = StringUtils.split(output, minecraft, 4)) != null && !outputLines.isEmpty()) {
                outputLines.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l)));
            }
        }
        if (ModCommonConfig.INSTANCE.wailaBlocksShowInformation()) {
            translateKey = registryName.func_110623_a() + ".pinformation";
            output = new TranslationTextComponent(translateKey).getString();
            if (I18n.func_188566_a((String)translateKey) && !StringUtils.isNullOrWhitespace(output).booleanValue() && (outputLines = StringUtils.split(output, minecraft, 4)) != null && !outputLines.isEmpty()) {
                outputLines.forEach(l -> tooltip.add((ITextComponent)new StringTextComponent(l)));
            }
        }
    }

    public void appendServerData(CompoundNBT data, ServerPlayerEntity player, World world, TileEntity tileEntity) {
        if (tileEntity != null) {
            data.func_218657_a(NBT_TAG_TILEENTITY, (INBT)tileEntity.getTileData());
        }
    }

    public void register(IRegistrar registrar) {
        ArrayList<String> processed = new ArrayList<String>();
        ArrayList blockClasses = new ArrayList();
        blockClasses.addAll(PixelmonUtils.getPixelmonBlockClasses());
        for (int i = blockClasses.size() - 1; i >= 0; --i) {
            if (!blockClasses.contains(((Class)blockClasses.get(i)).getSuperclass())) continue;
            blockClasses.remove(i);
        }
        for (Class clazz : blockClasses) {
            String key = clazz.getTypeName();
            if (processed.contains(key)) continue;
            processed.add(key);
            registrar.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, clazz);
            registrar.registerBlockDataProvider((IServerDataProvider)this, clazz);
        }
    }
}

