/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.utils;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class StringUtils {
    public static final String EMPTY = "";

    public static Boolean isNullOrWhitespace(@Nullable String value) {
        return value == null || value.trim().length() == 0;
    }

    public static List<String> split(String text, int displayWidth, FontRenderer fontRenderer, int maxLines) {
        String[] textLines;
        if (StringUtils.isNullOrWhitespace(text).booleanValue() || fontRenderer == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : textLines = text.split("\\\\n")) {
            int textWidth = fontRenderer.func_78256_a(line);
            if (textWidth > displayWidth) {
                String[] textParts = line.split(" ");
                String delimiter = EMPTY;
                String formatting = EMPTY;
                String output = EMPTY;
                for (String part : textParts) {
                    textWidth = fontRenderer.func_78256_a(output);
                    if (textWidth >= displayWidth) {
                        result.add(output);
                        output = formatting;
                        delimiter = EMPTY;
                    }
                    output = output + delimiter + part;
                    delimiter = " ";
                    if (!part.startsWith("\u00a7")) continue;
                    formatting = part.substring(0, 2);
                }
                if (StringUtils.isNullOrWhitespace(output).booleanValue()) continue;
                result.add(output);
                continue;
            }
            result.add(line);
        }
        return result;
    }

    public static List<String> split(String text, Minecraft minecraft, int maxLines) {
        if (StringUtils.isNullOrWhitespace(text).booleanValue() || minecraft == null) {
            return new ArrayList<String>();
        }
        MainWindow window = minecraft.func_228018_at_();
        int displayWidth = window.func_198107_o() / 3;
        return StringUtils.split(text, displayWidth, minecraft.field_71466_p, maxLines);
    }
}

