/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.top;

import bletch.pixelmoninformation.utils.StringUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.network.PacketBuffer;

public class WrappedTextElement
implements IElement {
    public static int ELEMENT_ID = -1;
    private String text;
    private int maxLines;
    private List<String> textLines;
    private int width;
    private int height;

    public WrappedTextElement(String text) {
        this.PopulateServerDetails(text, 4);
    }

    public WrappedTextElement(String text, int maxLines) {
        this.PopulateServerDetails(text, maxLines);
    }

    protected WrappedTextElement(String text, int maxLines, boolean isClient) {
        if (isClient) {
            this.PopulateClientDetails(text, maxLines);
        } else {
            this.PopulateServerDetails(text, maxLines);
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getID() {
        return ELEMENT_ID;
    }

    public int getWidth() {
        return this.width;
    }

    public void render(MatrixStack matrixStack, int x, int y) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int lineY = y;
        for (String line : this.textLines) {
            WrappedTextElement.renderText(minecraft, matrixStack, x, lineY, line);
            minecraft.field_71466_p.getClass();
            lineY += 9;
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.text);
        buf.writeInt(this.maxLines);
    }

    protected void PopulateClientDetails(String text, int maxLines) {
        Minecraft minecraft = Minecraft.func_71410_x();
        this.text = text;
        this.maxLines = maxLines;
        this.textLines = StringUtils.split(text, minecraft, maxLines);
        this.width = 0;
        minecraft.field_71466_p.getClass();
        this.height = Math.max(0, 9 * this.textLines.size());
        for (String line : this.textLines) {
            int lineWidth = minecraft.field_71466_p.func_78256_a(line);
            this.width = Math.max(this.width, lineWidth);
        }
    }

    protected void PopulateServerDetails(String text, int maxLines) {
        this.text = text;
        this.maxLines = maxLines;
        this.width = 0;
        this.height = 0;
        this.textLines = null;
    }

    public static int renderText(Minecraft mc, MatrixStack matrixStack, int x, int y, String txt) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 32.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableLighting();
        RenderHelper.func_227784_d_();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        int width = mc.field_71466_p.func_78256_a(txt);
        mc.field_71466_p.func_238405_a_(matrixStack, txt, (float)x, (float)y, 0xFFFFFF);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        matrixStack.func_227865_b_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        return width;
    }

    public static class Factory
    implements IElementFactory {
        public IElement createElement(PacketBuffer buf) {
            String text = buf.func_218666_n();
            int maxLines = buf.readInt();
            return new WrappedTextElement(text, maxLines, true);
        }
    }
}

