/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.top;

import bletch.pixelmoninformation.core.ModCommonConfig;
import bletch.pixelmoninformation.top.WrappedTextElement;
import bletch.pixelmoninformation.utils.ModUtils;
import bletch.pixelmoninformation.utils.StringUtils;
import bletch.pixelmoninformation.utils.TextUtils;
import com.google.common.base.Function;
import com.pixelmonmod.pixelmon.api.pokedex.PlayerPokedex;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.boss.BossTier;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.species.evs.EVYields;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.EVStore;
import com.pixelmonmod.pixelmon.entities.npcs.IndexedNPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCEntity;
import com.pixelmonmod.pixelmon.entities.npcs.NPCFisherman;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCQuestGiver;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PixelmonEntityTop {
    public static boolean show(ProbeMode mode, IProbeConfig.ConfigMode cfg) {
        return cfg == IProbeConfig.ConfigMode.NORMAL || cfg == IProbeConfig.ConfigMode.EXTENDED && mode == ProbeMode.EXTENDED;
    }

    public static class getTheOneProbe
    implements Function<ITheOneProbe, Void> {
        public static ITheOneProbe PROBE;
        public static IProbeConfig CONFIG;

        public Void apply(ITheOneProbe theOneProbe) {
            PROBE = theOneProbe;
            CONFIG = PROBE.createProbeConfig();
            if (WrappedTextElement.ELEMENT_ID == -1) {
                WrappedTextElement.ELEMENT_ID = PROBE.registerElementFactory((IElementFactory)new WrappedTextElement.Factory());
            }
            PROBE.registerEntityProvider(new IProbeInfoEntityProvider(){

                public String getID() {
                    return "pixelmoninformation:default";
                }

                public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, Entity entity, IProbeHitEntityData data) {
                    if (entity instanceof PixelmonEntity) {
                        getTheOneProbe.addPixelmonEntityInfo(mode, probeInfo, player, world, (PixelmonEntity)entity, data);
                    }
                    if (entity instanceof NPCEntity) {
                        getTheOneProbe.addNPCEntityInfo(mode, probeInfo, player, world, (NPCEntity)entity, data);
                    }
                }
            });
            PROBE.registerEntityDisplayOverride((mode, probeInfo, player, world, entity, data) -> {
                if (entity instanceof PixelmonEntity) {
                    return getTheOneProbe.overridePixelmonEntityInfo(mode, probeInfo, player, world, (PixelmonEntity)entity, data, CONFIG);
                }
                if (entity instanceof NPCEntity) {
                    return getTheOneProbe.overrideNPCEntityInfo(mode, probeInfo, player, world, (NPCEntity)entity, data, CONFIG);
                }
                return false;
            });
            return null;
        }

        private static boolean addPixelmonEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, PixelmonEntity entity, IProbeHitEntityData data) {
            int percentage;
            int maxTotal;
            int value;
            int total;
            BattleStatsType[] statTypes;
            EVStore store;
            String delimiter;
            String output;
            Object translateKey;
            String output2;
            if (entity == null) {
                return false;
            }
            if (!ModCommonConfig.INSTANCE.topShowEntityInformation() || ModCommonConfig.INSTANCE.topUseCrouchKey() && !player.func_213453_ef()) {
                return false;
            }
            PixelmonEntity pixelmon = entity;
            Pokemon pokemon = pixelmon.getPokemon();
            Species pokemonSpecies = pixelmon.getSpecies();
            Stats stats = pokemon.getForm();
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonDescription() && !StringUtils.isNullOrWhitespace(output2 = pokemonSpecies.getDescTranslation().getString()).booleanValue()) {
                probeInfo.element((IElement)new WrappedTextElement(output2));
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonOwner()) {
                translateKey = "gui.pokemon.owner";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pixelmon.hasOwner() && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String ownerName = pixelmon.getOwner().func_200200_C_().getString();
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + ownerName));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonLevel() && !StringUtils.isNullOrWhitespace(output = new TranslationTextComponent((String)(translateKey = "gui.pokemon.level")).getString()).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                int level = pixelmon.getLvl().getPokemonLevel();
                probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + level));
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonPokedexNumber()) {
                translateKey = "gui.pokemon.dexnum";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemonSpecies != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String dexNumber = pokemonSpecies.getFormattedDex();
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + dexNumber));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonGeneration()) {
                translateKey = "gui.pokemon.generation";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemonSpecies != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    int generation = pokemonSpecies.getGeneration();
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + generation));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonEVs()) {
                translateKey = "gui.pokemon.evstats";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String evStats = "";
                    delimiter = "";
                    store = pokemon.getEVs();
                    statTypes = BattleStatsType.getEVIVStatValues();
                    total = 0;
                    BattleStatsType[] battleStatsTypeArray = statTypes;
                    int n = battleStatsTypeArray.length;
                    for (int i = 0; i < n; ++i) {
                        BattleStatsType type = battleStatsTypeArray[i];
                        value = store.getStat(type);
                        total += value;
                        evStats = evStats + delimiter;
                        evStats = evStats + type.getLocalizedName();
                        evStats = evStats + " (" + value + ")";
                        delimiter = ", ";
                    }
                    maxTotal = 510;
                    percentage = (int)(100.0 / (double)maxTotal * (double)total);
                    probeInfo.element((IElement)new WrappedTextElement(TextFormatting.DARK_AQUA + output + " " + TextFormatting.YELLOW + total + "/" + maxTotal + " (" + percentage + "%) " + TextFormatting.WHITE + "- " + evStats));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonIVs()) {
                translateKey = "gui.pokemon.ivstats";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String ivStats = "";
                    delimiter = "";
                    store = pokemon.getIVs();
                    statTypes = BattleStatsType.getEVIVStatValues();
                    total = 0;
                    for (BattleStatsType type : statTypes) {
                        value = store.getStat(type);
                        total += value;
                        ivStats = ivStats + delimiter;
                        ivStats = ivStats + type.getTranslatedName().getString();
                        ivStats = ivStats + " (" + value + ")";
                        delimiter = ", ";
                    }
                    maxTotal = 31 * statTypes.length;
                    percentage = (int)(100.0 / (double)maxTotal * (double)total);
                    probeInfo.element((IElement)new WrappedTextElement(TextFormatting.DARK_AQUA + output + " " + TextFormatting.YELLOW + total + "/" + maxTotal + " (" + percentage + "%) " + TextFormatting.WHITE + "- " + ivStats));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonEVYield()) {
                translateKey = "gui.pokemon.evyield";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (stats != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String evYield = "";
                    delimiter = "";
                    BattleStatsType[] statValues = BattleStatsType.getEVIVStatValues();
                    EVYields evYields = stats.getEVYields();
                    for (int i = 0; i < statValues.length; ++i) {
                        int evYieldValue = evYields.getYield(statValues[i]);
                        if (evYieldValue <= 0) continue;
                        evYield = evYield + delimiter;
                        evYield = evYield + statValues[i].getTranslatedName().getString();
                        evYield = evYield + " (" + evYieldValue + ")";
                        delimiter = ", ";
                    }
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + evYield));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonNatureInformation()) {
                translateKey = "gui.pokemon.nature";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String natureName = "";
                    Nature nature = pokemon.getNature();
                    if (nature != null) {
                        natureName = natureName + nature.getTranslatedName().getString();
                    }
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + natureName));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonGrowthInformation()) {
                translateKey = "gui.pokemon.growth";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (pokemon != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String growthName = "";
                    EnumGrowth growth = pokemon.getGrowth();
                    if (growth != null) {
                        growthName = growthName + growth.getTranslatedName().getString();
                    }
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + growthName));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonTypeInformation()) {
                translateKey = "gui.pokemon.type";
                output = new TranslationTextComponent((String)translateKey).getString();
                if (stats != null && !StringUtils.isNullOrWhitespace(output).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                    String types = "";
                    delimiter = "";
                    for (Element type : stats.getTypes()) {
                        types = types + delimiter;
                        types = types + type.getTranslatedName().getString();
                        delimiter = ", ";
                    }
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + types));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonTypeMatchupInformation() && stats != null) {
                translateKey = stats.getTypes().iterator();
                while (translateKey.hasNext()) {
                    Element type = (Element)translateKey.next();
                    String typeName = type.getTranslatedName().getString();
                    String typeValue = type.name().toLowerCase();
                    String output3 = "";
                    String translateKey2 = "";
                    translateKey2 = "pokemontype." + typeValue + ".strong";
                    output3 = new TranslationTextComponent(translateKey2).getString();
                    if (!StringUtils.isNullOrWhitespace(output3).booleanValue() && !output3.equalsIgnoreCase(translateKey2)) {
                        probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + typeName + ": " + output3));
                    }
                    if (!StringUtils.isNullOrWhitespace(output3 = new TranslationTextComponent(translateKey2 = "pokemontype." + typeValue + ".weak").getString()).booleanValue() && !output3.equalsIgnoreCase(translateKey2)) {
                        probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + typeName + ": " + output3));
                    }
                    if (StringUtils.isNullOrWhitespace(output3 = new TranslationTextComponent(translateKey2 = "pokemontype." + typeValue + ".bad").getString()).booleanValue() || output3.equalsIgnoreCase(translateKey2)) continue;
                    probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + typeName + ": " + output3));
                }
            }
            if (ModCommonConfig.INSTANCE.topEntityShowPokemonCaught() && !StringUtils.isNullOrWhitespace(output = new TranslationTextComponent((String)(translateKey = "gui.pokemon.caught")).getString()).booleanValue() && !output.equalsIgnoreCase((String)translateKey)) {
                String caughtStatus = TextUtils.SYMBOL_UNKNOWN;
                PlayerPokedex pokedex = new PlayerPokedex(player.func_110124_au());
                if (pokedex != null) {
                    caughtStatus = pokedex.hasCaught(pokemonSpecies) ? TextUtils.SYMBOL_GREENTICK : TextUtils.SYMBOL_REDCROSS;
                }
                probeInfo.text((ITextComponent)new StringTextComponent(TextFormatting.DARK_AQUA + output + " " + TextFormatting.WHITE + caughtStatus));
            }
            return false;
        }

        private static boolean addNPCEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, NPCEntity entity, IProbeHitEntityData data) {
            return false;
        }

        private static boolean overridePixelmonEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, PixelmonEntity entity, IProbeHitEntityData data, IProbeConfig config) {
            if (entity == null) {
                return false;
            }
            if (!ModCommonConfig.INSTANCE.topShowEntityInformation()) {
                return false;
            }
            PixelmonEntity pixelmon = entity;
            Pokemon pokemon = pixelmon.getPokemon();
            String output = "";
            BossTier bossTier = pixelmon.getBossTier();
            if (bossTier.isBoss()) {
                switch (bossTier.getID()) {
                    case "common": {
                        output = output + TextFormatting.GRAY;
                        break;
                    }
                    case "uncommon": {
                        output = output + TextFormatting.GREEN;
                        break;
                    }
                    case "rare": {
                        output = output + TextFormatting.BLUE;
                        break;
                    }
                    case "epic": {
                        output = output + TextFormatting.DARK_PURPLE;
                        break;
                    }
                    case "legendary": {
                        output = output + TextFormatting.GOLD;
                        break;
                    }
                    case "ultimate": {
                        output = output + TextFormatting.AQUA;
                        break;
                    }
                    case "haunted": {
                        output = output + TextFormatting.LIGHT_PURPLE;
                        break;
                    }
                    case "drowned": {
                        output = output + TextFormatting.DARK_AQUA;
                        break;
                    }
                    default: {
                        output = output + TextFormatting.WHITE;
                    }
                }
                output = output + new TranslationTextComponent(bossTier.getName()).getString();
                output = output + " ";
            }
            output = output + TextFormatting.WHITE;
            output = output + pixelmon.getLocalizedName();
            if (pokemon != null) {
                String nickName = pokemon.getFormattedNickname().getString();
                if (!StringUtils.isNullOrWhitespace(nickName).booleanValue()) {
                    output = output + " ";
                    output = output + TextFormatting.ITALIC;
                    output = output + "(" + nickName + ")";
                }
                switch (pokemon.getGender()) {
                    case FEMALE: {
                        output = output + " ";
                        output = output + TextUtils.SYMBOL_FEMALE;
                        break;
                    }
                    case MALE: {
                        output = output + " ";
                        output = output + TextUtils.SYMBOL_MALE;
                        break;
                    }
                }
            }
            String modName = ModUtils.getModName(entity.func_200600_R());
            if (PixelmonEntityTop.show(mode, config.getShowModName())) {
                probeInfo.horizontal().entity((Entity)entity).vertical().text(output).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity((Entity)entity).text(output);
            }
            return true;
        }

        private static boolean overrideNPCEntityInfo(ProbeMode mode, IProbeInfo probeInfo, PlayerEntity player, World world, NPCEntity entity, IProbeHitEntityData data, IProbeConfig config) {
            NPCFisherman entityNPC;
            if (entity == null) {
                return false;
            }
            if (!ModCommonConfig.INSTANCE.topShowEntityInformation()) {
                return false;
            }
            String output = "";
            String langCode = "en-us";
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (serverPlayer != null) {
                langCode = serverPlayer.getLanguage();
            }
            String npcName = "";
            String npcInfo = "";
            if (entity instanceof NPCFisherman) {
                entityNPC = (NPCFisherman)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (entity instanceof NPCNurseJoy) {
                entityNPC = (NPCNurseJoy)entity;
                String nameKey = entityNPC.getTextureIndex() == 1 ? "gui.nursejoy.name" : "gui.doctorjohn.name";
                npcName = new TranslationTextComponent(nameKey).getString();
            }
            if (entity instanceof NPCQuestGiver) {
                entityNPC = (NPCQuestGiver)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (entity instanceof NPCRelearner) {
                entityNPC = (NPCRelearner)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (entity instanceof NPCShopkeeper) {
                entityNPC = (NPCShopkeeper)entity;
                npcName = entityNPC.getShopkeeperName(langCode);
            }
            if (entity instanceof NPCTrader) {
                entityNPC = (NPCTrader)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (entity instanceof NPCTrainer) {
                entityNPC = (NPCTrainer)entity;
                npcName = entityNPC.getName(langCode);
                BossTier bossTier = entityNPC.getBossTier();
                if (bossTier.isBoss()) {
                    switch (bossTier.getID()) {
                        case "common": {
                            output = output + TextFormatting.GRAY;
                            break;
                        }
                        case "uncommon": {
                            output = output + TextFormatting.GREEN;
                            break;
                        }
                        case "rare": {
                            output = output + TextFormatting.BLUE;
                            break;
                        }
                        case "epic": {
                            output = output + TextFormatting.DARK_PURPLE;
                            break;
                        }
                        case "legendary": {
                            output = output + TextFormatting.GOLD;
                            break;
                        }
                        case "ultimate": {
                            output = output + TextFormatting.AQUA;
                            break;
                        }
                        case "haunted": {
                            output = output + TextFormatting.LIGHT_PURPLE;
                            break;
                        }
                        case "drowned": {
                            output = output + TextFormatting.DARK_AQUA;
                            break;
                        }
                        default: {
                            output = output + TextFormatting.WHITE;
                        }
                    }
                    output = output + new TranslationTextComponent(bossTier.getName()).getString();
                    output = output + " ";
                }
                String npcLevel = entityNPC.getSubTitleText() + " " + entityNPC.getTrainerLevel();
                npcInfo = npcInfo + TextFormatting.WHITE;
                npcInfo = npcInfo + "(" + npcLevel.trim() + ")";
            }
            if (entity instanceof NPCTutor) {
                entityNPC = (NPCTutor)entity;
                npcName = entityNPC.getDisplayText();
            }
            if (StringUtils.isNullOrWhitespace(npcName).booleanValue() && entity instanceof NPCChatting) {
                entityNPC = (NPCChatting)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (StringUtils.isNullOrWhitespace(npcName).booleanValue() && entity instanceof IndexedNPCEntity) {
                entityNPC = (IndexedNPCEntity)entity;
                npcName = entityNPC.getName(langCode);
            }
            if (!StringUtils.isNullOrWhitespace(npcName).booleanValue()) {
                output = output + TextFormatting.WHITE;
                output = output + npcName;
                output = output + " ";
            }
            if (!StringUtils.isNullOrWhitespace(npcInfo).booleanValue()) {
                output = output + npcInfo;
                output = output + " ";
            }
            String modName = ModUtils.getModName(entity.func_200600_R());
            if (PixelmonEntityTop.show(mode, config.getShowModName())) {
                probeInfo.horizontal().entity((Entity)entity).vertical().text(output).text(CompoundText.create().style(TextStyleClass.MODNAME).text(modName));
            } else {
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity((Entity)entity).text(output);
            }
            return true;
        }
    }
}

