/*
 * Decompiled with CFR 0.152.
 */
package bletch.pixelmoninformation.core;

import bletch.pixelmoninformation.PixelmonInformation;
import bletch.pixelmoninformation.network.NetworkHandler;
import bletch.pixelmoninformation.network.SyncCommonConfigPacket;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.PacketDistributor;

public class ModCommonConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ModCommonConfig INSTANCE = new ModCommonConfig();
    public static ForgeConfigSpec CONFIG_SPEC;
    private final ForgeConfigSpec.BooleanValue wailaUseCrouchKey;
    private final ForgeConfigSpec.BooleanValue wailaShowBlockInformation;
    private final ForgeConfigSpec.BooleanValue wailaBlocksShowTooltip;
    private final ForgeConfigSpec.BooleanValue wailaBlocksShowInformation;
    private final ForgeConfigSpec.BooleanValue wailaShowEntityInformation;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonDescription;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonOwner;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonLevel;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonPokedexNumber;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonGeneration;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonEVYield;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonTypeInformation;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonNatureInformation;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonGrowthInformation;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonEVs;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonIVs;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonTypeMatchupInformation;
    private final ForgeConfigSpec.BooleanValue wailaEntityShowPokemonCaught;
    private final ForgeConfigSpec.BooleanValue topUseCrouchKey;
    private final ForgeConfigSpec.BooleanValue topShowBlockInformation;
    private final ForgeConfigSpec.BooleanValue topBlocksShowTooltip;
    private final ForgeConfigSpec.BooleanValue topBlocksShowInformation;
    private final ForgeConfigSpec.BooleanValue topShowEntityInformation;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonDescription;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonOwner;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonLevel;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonPokedexNumber;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonGeneration;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonEVYield;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonTypeInformation;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonNatureInformation;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonGrowthInformation;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonEVs;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonIVs;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonTypeMatchupInformation;
    private final ForgeConfigSpec.BooleanValue topEntityShowPokemonCaught;

    public static void initialize() {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)ModCommonConfig.getConfigPath()).sync().preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        CONFIG_SPEC.setConfig((CommentedConfig)configData);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CONFIG_SPEC);
    }

    public static Path getConfigPath() {
        return FMLPaths.CONFIGDIR.get().resolve("pixelmoninformation-common.toml").toAbsolutePath();
    }

    public static void sendConfig(PlayerEntity player) {
        try {
            byte[] configData = Files.readAllBytes(ModCommonConfig.getConfigPath());
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SyncCommonConfigPacket(configData));
        }
        catch (Exception e) {
            PixelmonInformation.LOGGER.error("pixelmoninformation: failed to send common config.");
        }
    }

    public static void setConfig(byte[] configFileData) {
        try {
            CONFIG_SPEC.setConfig((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(configFileData)));
        }
        catch (Exception e) {
            PixelmonInformation.LOGGER.error("pixelmoninformation: failed to load common config.");
        }
    }

    private ModCommonConfig() {
        BUILDER.push("waila");
        BUILDER.comment("If true, will only show information when crouching.");
        this.wailaUseCrouchKey = BUILDER.define("wailaUseCrouchKey", false);
        BUILDER.push("blocks");
        BUILDER.comment("If true, will show the block information in Waila.");
        this.wailaShowBlockInformation = BUILDER.define("wailaShowBlockInformation", true);
        BUILDER.comment("If true, will show the block tooltip in Waila.");
        this.wailaBlocksShowTooltip = BUILDER.define("wailaBlocksShowTooltip", true);
        BUILDER.comment("If true, will show the block information in Waila.");
        this.wailaBlocksShowInformation = BUILDER.define("wailaBlocksShowInformation", true);
        BUILDER.pop();
        BUILDER.push("entities");
        BUILDER.comment("If true, will show the entity information in Waila.");
        this.wailaShowEntityInformation = BUILDER.define("wailaShowEntityInformation", true);
        BUILDER.comment("If true, will show the description of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonDescription = BUILDER.define("wailaEntityShowPokemonDescription", true);
        BUILDER.comment("If true, will show the owner's name of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonOwner = BUILDER.define("wailaEntityShowPokemonOwner", true);
        BUILDER.comment("If true, will show the level of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonLevel = BUILDER.define("wailaEntityShowPokemonLevel", true);
        BUILDER.comment("If true, will show the Pok\u00c3\u00a9dex Number of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonPokedexNumber = BUILDER.define("wailaEntityShowPokemonPokedexNumber", true);
        BUILDER.comment("If true, will show the Generation of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonGeneration = BUILDER.define("wailaEntityShowPokemonGeneration", true);
        BUILDER.comment("If true, will show the EV (effort value) yield of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonEVYield = BUILDER.define("wailaEntityShowPokemonEVYield", true);
        BUILDER.comment("If true, will show the type information of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonTypeInformation = BUILDER.define("wailaEntityShowPokemonTypeInformation", true);
        BUILDER.comment("If true, will show the nature information of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonNatureInformation = BUILDER.define("wailaEntityShowPokemonNatureInformation", true);
        BUILDER.comment("If true, will show the growth information of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonGrowthInformation = BUILDER.define("wailaEntityShowPokemonGrowthInformation", true);
        BUILDER.comment("If true, will show the EV (effort value) stats of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonEVs = BUILDER.define("wailaEntityShowPokemonEVs", true);
        BUILDER.comment("If true, will show the IV (individual values) stats of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonIVs = BUILDER.define("wailaEntityShowPokemonIVs", true);
        BUILDER.comment("If true, will show the type match-up information of the pok\u00c3\u00a9mon.");
        this.wailaEntityShowPokemonTypeMatchupInformation = BUILDER.define("wailaEntityShowPokemonTypeMatchupInformation", true);
        BUILDER.comment("If true, will show if the pok\u00c3\u00a9mon has been caught.");
        this.wailaEntityShowPokemonCaught = BUILDER.define("wailaEntityShowPokemonCaught", true);
        BUILDER.pop();
        BUILDER.pop();
        BUILDER.push("theoneprobe");
        BUILDER.comment("If true, will only show information when crouching.");
        this.topUseCrouchKey = BUILDER.define("topUseCrouchKey", true);
        BUILDER.push("blocks");
        BUILDER.comment("If true, will show the block information in The One Probe.");
        this.topShowBlockInformation = BUILDER.define("topShowBlockInformation", true);
        BUILDER.comment("If true, will show the block tooltip in The One Probe.");
        this.topBlocksShowTooltip = BUILDER.define("topBlocksShowTooltip", true);
        BUILDER.comment("If true, will show the block information in The One Probe.");
        this.topBlocksShowInformation = BUILDER.define("topBlocksShowInformation", true);
        BUILDER.pop();
        BUILDER.push("entities");
        BUILDER.comment("If true, will show the entity information in The One Probe.");
        this.topShowEntityInformation = BUILDER.define("topShowEntityInformation", true);
        BUILDER.comment("If true, will show the description of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonDescription = BUILDER.define("topEntityShowPokemonDescription", true);
        BUILDER.comment("If true, will show the owner's name of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonOwner = BUILDER.define("topEntityShowPokemonOwner", true);
        BUILDER.comment("If true, will show the level of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonLevel = BUILDER.define("topEntityShowPokemonLevel", true);
        BUILDER.comment("If true, will show the Pok\u00c3\u00a9dex Number of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonPokedexNumber = BUILDER.define("topEntityShowPokemonPokedexNumber", true);
        BUILDER.comment("If true, will show the Generation of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonGeneration = BUILDER.define("topEntityShowPokemonGeneration", true);
        BUILDER.comment("If true, will show the EV (effort value) yield of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonEVYield = BUILDER.define("topEntityShowPokemonEVYield", true);
        BUILDER.comment("If true, will show the type information of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonTypeInformation = BUILDER.define("topEntityShowPokemonTypeInformation", true);
        BUILDER.comment("If true, will show the nature information of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonNatureInformation = BUILDER.define("topEntityShowPokemonNatureInformation", true);
        BUILDER.comment("If true, will show the growth information of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonGrowthInformation = BUILDER.define("topEntityShowPokemonGrowthInformation", true);
        BUILDER.comment("If true, will show the EV (effort value) stats of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonEVs = BUILDER.define("topEntityShowPokemonEVs", true);
        BUILDER.comment("If true, will show the IV (individual values) stats of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonIVs = BUILDER.define("topEntityShowPokemonIVs", true);
        BUILDER.comment("If true, will show the type match-up information of the pok\u00c3\u00a9mon.");
        this.topEntityShowPokemonTypeMatchupInformation = BUILDER.define("topEntityShowPokemonTypeMatchupInformation", true);
        BUILDER.comment("If true, will show if the pok\u00c3\u00a9mon has been caught.");
        this.topEntityShowPokemonCaught = BUILDER.define("topEntityShowPokemonCaught", true);
        BUILDER.pop();
        BUILDER.pop();
        CONFIG_SPEC = BUILDER.build();
    }

    public boolean wailaUseCrouchKey() {
        return (Boolean)this.wailaUseCrouchKey.get();
    }

    public boolean wailaShowBlockInformation() {
        return (Boolean)this.wailaShowBlockInformation.get();
    }

    public boolean wailaBlocksShowTooltip() {
        return (Boolean)this.wailaBlocksShowTooltip.get();
    }

    public boolean wailaBlocksShowInformation() {
        return (Boolean)this.wailaBlocksShowInformation.get();
    }

    public boolean wailaShowEntityInformation() {
        return (Boolean)this.wailaShowEntityInformation.get();
    }

    public boolean wailaEntityShowPokemonDescription() {
        return (Boolean)this.wailaEntityShowPokemonDescription.get();
    }

    public boolean wailaEntityShowPokemonOwner() {
        return (Boolean)this.wailaEntityShowPokemonOwner.get();
    }

    public boolean wailaEntityShowPokemonLevel() {
        return (Boolean)this.wailaEntityShowPokemonLevel.get();
    }

    public boolean wailaEntityShowPokemonPokedexNumber() {
        return (Boolean)this.wailaEntityShowPokemonPokedexNumber.get();
    }

    public boolean wailaEntityShowPokemonGeneration() {
        return (Boolean)this.wailaEntityShowPokemonGeneration.get();
    }

    public boolean wailaEntityShowPokemonEVYield() {
        return (Boolean)this.wailaEntityShowPokemonEVYield.get();
    }

    public boolean wailaEntityShowPokemonTypeInformation() {
        return (Boolean)this.wailaEntityShowPokemonTypeInformation.get();
    }

    public boolean wailaEntityShowPokemonNatureInformation() {
        return (Boolean)this.wailaEntityShowPokemonNatureInformation.get();
    }

    public boolean wailaEntityShowPokemonGrowthInformation() {
        return (Boolean)this.wailaEntityShowPokemonGrowthInformation.get();
    }

    public boolean wailaEntityShowPokemonEVs() {
        return (Boolean)this.wailaEntityShowPokemonEVs.get();
    }

    public boolean wailaEntityShowPokemonIVs() {
        return (Boolean)this.wailaEntityShowPokemonIVs.get();
    }

    public boolean wailaEntityShowPokemonTypeMatchupInformation() {
        return (Boolean)this.wailaEntityShowPokemonTypeMatchupInformation.get();
    }

    public boolean wailaEntityShowPokemonCaught() {
        return (Boolean)this.wailaEntityShowPokemonCaught.get();
    }

    public boolean topUseCrouchKey() {
        return (Boolean)this.topUseCrouchKey.get();
    }

    public boolean topShowBlockInformation() {
        return (Boolean)this.topShowBlockInformation.get();
    }

    public boolean topBlocksShowTooltip() {
        return (Boolean)this.topBlocksShowTooltip.get();
    }

    public boolean topBlocksShowInformation() {
        return (Boolean)this.topBlocksShowInformation.get();
    }

    public boolean topShowEntityInformation() {
        return (Boolean)this.topShowEntityInformation.get();
    }

    public boolean topEntityShowPokemonDescription() {
        return (Boolean)this.topEntityShowPokemonDescription.get();
    }

    public boolean topEntityShowPokemonOwner() {
        return (Boolean)this.topEntityShowPokemonOwner.get();
    }

    public boolean topEntityShowPokemonLevel() {
        return (Boolean)this.topEntityShowPokemonLevel.get();
    }

    public boolean topEntityShowPokemonPokedexNumber() {
        return (Boolean)this.topEntityShowPokemonPokedexNumber.get();
    }

    public boolean topEntityShowPokemonGeneration() {
        return (Boolean)this.topEntityShowPokemonGeneration.get();
    }

    public boolean topEntityShowPokemonEVYield() {
        return (Boolean)this.topEntityShowPokemonEVYield.get();
    }

    public boolean topEntityShowPokemonTypeInformation() {
        return (Boolean)this.topEntityShowPokemonTypeInformation.get();
    }

    public boolean topEntityShowPokemonNatureInformation() {
        return (Boolean)this.topEntityShowPokemonNatureInformation.get();
    }

    public boolean topEntityShowPokemonGrowthInformation() {
        return (Boolean)this.topEntityShowPokemonGrowthInformation.get();
    }

    public boolean topEntityShowPokemonEVs() {
        return (Boolean)this.topEntityShowPokemonEVs.get();
    }

    public boolean topEntityShowPokemonIVs() {
        return (Boolean)this.topEntityShowPokemonIVs.get();
    }

    public boolean topEntityShowPokemonTypeMatchupInformation() {
        return (Boolean)this.topEntityShowPokemonTypeMatchupInformation.get();
    }

    public boolean topEntityShowPokemonCaught() {
        return (Boolean)this.topEntityShowPokemonCaught.get();
    }
}

