/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.core.util.Pair;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.extensions.TemplateHoldingLevel;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.packets.AllTemplatesPacket;
import com.supermartijn642.formations.tools.template.packets.DeleteTemplatePacket;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.NeoForge;

public class TemplateManager {
    private final Level level;
    private final boolean isClientSide;
    private final Set<Template> templates = new HashSet<Template>();
    private final Map<AABB, Template> templatesByArea = new HashMap<AABB, Template>();
    private final Map<String, Template> templatesByName = new HashMap<String, Template>();
    private final Set<String> removedTemplates = new HashSet<String>();

    public static TemplateManager get(Level level) {
        return ((TemplateHoldingLevel)level).getFormationsTemplateManager();
    }

    public static void registerListeners() {
        NeoForge.EVENT_BUS.addListener(event -> TemplateManager.get(event.getEntity().level()).sendTemplatesToPlayer(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(event -> TemplateManager.get(event.getEntity().level()).sendTemplatesToPlayer(event.getEntity()));
        NeoForge.EVENT_BUS.addListener(event -> TemplateManager.get(event.getEntity().level()).sendTemplatesToPlayer(event.getEntity()));
    }

    public TemplateManager(Level level) {
        this.level = level;
        this.isClientSide = level.isClientSide;
    }

    public void addTemplate(Template template) {
        if (this.templatesByArea.containsKey(template.getArea())) {
            Template oldTemplate = this.templatesByArea.get(template.getArea());
            this.templates.remove(oldTemplate);
            this.templatesByName.remove(oldTemplate.getName());
            this.removedTemplates.add(oldTemplate.getName());
        }
        this.templates.add(template);
        this.templatesByArea.put(template.getArea(), template);
        this.templatesByName.put(template.getName(), template);
        if (!this.isClientSide) {
            this.sendAllTemplates();
        }
    }

    public Template getTemplateByName(String name) {
        return this.templatesByName.get(name);
    }

    public Set<Template> getAllTemplates() {
        return Collections.unmodifiableSet(this.templates);
    }

    public void removeTemplate(Template template) {
        this.templates.remove(template);
        this.templatesByName.remove(template.getName());
        this.templatesByArea.remove(template.getArea());
        this.removedTemplates.add(template.getName());
        if (!this.isClientSide) {
            FormationsDev.CHANNEL.sendToDimension(this.level, (BasePacket)new DeleteTemplatePacket(template));
        }
    }

    public void clearAll() {
        this.templates.clear();
        this.templatesByArea.clear();
        this.templatesByName.clear();
        this.removedTemplates.clear();
    }

    private void sendTemplatesToPlayer(Player player) {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        FormationsDev.CHANNEL.sendToPlayer(player, (BasePacket)new AllTemplatesPacket(this.templates));
    }

    private void sendAllTemplates() {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        FormationsDev.CHANNEL.sendToDimension(this.level, (BasePacket)new AllTemplatesPacket(this.templates));
    }

    public Pair<Integer, Integer> exportAll() {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        String pathProperty = System.getProperty("formations.templates.export-location");
        Path path = pathProperty != null && !pathProperty.isBlank() ? Paths.get(pathProperty.trim(), new String[0]) : this.level.getServer().storageSource.getDimensionPath(this.level.dimension()).resolve("formations").resolve("templates");
        this.removedTemplates.removeAll(this.templatesByName.keySet());
        for (String removedTemplate : this.removedTemplates) {
            Path file = path.resolve(removedTemplate + ".nbt");
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                Formations.LOGGER.error("Failed to remove file '" + String.valueOf(file) + "' for removed a template:", (Throwable)e);
            }
        }
        int successes = 0;
        int fails = 0;
        for (Template template : this.templates) {
            Path file = path.resolve(template.getName() + ".nbt");
            try {
                if (template.recordAndExport(this.level, file)) {
                    ++successes;
                    continue;
                }
                ++fails;
            }
            catch (Exception e) {
                Formations.LOGGER.error("Failed to capture and save template '" + template.getName() + "':", (Throwable)e);
                ++fails;
            }
        }
        return Pair.of((Object)successes, (Object)fails);
    }

    CompoundTag write() {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        CompoundTag data = new CompoundTag();
        ListTag templates = new ListTag();
        this.templates.stream().map(Template::write).forEach(arg_0 -> templates.add(arg_0));
        data.put("templates", (Tag)templates);
        ListTag removedTemplates = new ListTag();
        this.removedTemplates.stream().map(StringTag::valueOf).forEach(arg_0 -> removedTemplates.add(arg_0));
        data.put("removedTemplates", (Tag)removedTemplates);
        return data;
    }

    void read(CompoundTag data) {
        if (this.isClientSide) {
            throw new AssertionError();
        }
        this.clearAll();
        ListTag templates = data.getList("templates", 10);
        templates.stream().map(CompoundTag.class::cast).map(Template::load).forEach(this.templates::add);
        this.templates.forEach(template -> this.templatesByArea.put(template.getArea(), (Template)template));
        this.templates.forEach(template -> this.templatesByName.put(template.getName(), (Template)template));
        ListTag removedTemplates = data.getList("removedTemplates", 8);
        removedTemplates.stream().map(StringTag.class::cast).map(StringTag::getAsString).forEach(this.removedTemplates::add);
    }
}

