/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class LanternDecorator
extends TreeDecorator {
    public static final MapCodec<LanternDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(decorator -> Float.valueOf(decorator.probability)), (App)IntProvider.codec((int)0, (int)10).fieldOf("lantern_count").orElse((Object)ConstantInt.of((int)3)).forGetter(decorator -> decorator.count), (App)IntProvider.codec((int)0, (int)10).fieldOf("chain_length").orElse((Object)ConstantInt.of((int)1)).forGetter(decorator -> decorator.chainLength)).apply((Applicative)builder, LanternDecorator::new));
    private final BlockState chain = (BlockState)Blocks.CHAIN.defaultBlockState().setValue((Property)ChainBlock.AXIS, (Comparable)Direction.Axis.Y);
    private final BlockState lantern = (BlockState)Blocks.LANTERN.defaultBlockState().setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.TRUE);
    private final float probability;
    private final IntProvider count;
    private final IntProvider chainLength;

    public LanternDecorator(float probability, IntProvider count, IntProvider chainLength) {
        this.probability = probability;
        this.count = count;
        this.chainLength = chainLength;
    }

    protected TreeDecoratorType<?> type() {
        return ModRegistry.LANTERN.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        if (random.nextFloat() > this.probability) {
            return;
        }
        int count = this.count.sample(random);
        List<BlockPos> possible = LanternDecorator.getLeavesShuffled(context, count);
        for (int i = 0; i < possible.size(); ++i) {
            BlockPos blockpos = possible.get(i);
            for (int length = this.chainLength.sample(random); context.isAir(blockpos) && length > 0; --length) {
                context.setBlock(blockpos, this.chain);
                blockpos = blockpos.below();
            }
            context.setBlock(blockpos, this.lantern);
        }
    }

    private static List<BlockPos> getLeavesShuffled(TreeDecorator.Context context, int maxCount) {
        List<BlockPos> all = context.leaves().stream().map(BlockPos::below).filter(arg_0 -> ((TreeDecorator.Context)context).isAir(arg_0)).distinct().collect(Collectors.toList());
        Collections.shuffle(all);
        int maxIndex = Math.min(maxCount, all.size());
        all.subList(maxIndex, all.size()).clear();
        return all;
    }
}

