/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.treedecorators;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class CaveVineDecorator
extends TreeDecorator {
    public static final MapCodec<CaveVineDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("start_chance").forGetter(decorator -> Float.valueOf(decorator.startProbability)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("berry_chance").forGetter(decorator -> Float.valueOf(decorator.berrySpawnChance)), (App)Codec.intRange((int)0, (int)10).optionalFieldOf("max_vine_length", (Object)4).forGetter(decorator -> decorator.maxVineLength), (App)Codec.BOOL.optionalFieldOf("only_outer_leaves", (Object)true).forGetter(decorator -> decorator.onlyOuterLeaves)).apply((Applicative)builder, CaveVineDecorator::new));
    private final float startProbability;
    private final float berrySpawnChance;
    private final int maxVineLength;
    private final boolean onlyOuterLeaves;

    public CaveVineDecorator(float startProbability, float berrySpawnChance, int maxVineLength, boolean onlyOuterLeaves) {
        this.startProbability = startProbability;
        this.berrySpawnChance = berrySpawnChance;
        this.maxVineLength = maxVineLength;
        this.onlyOuterLeaves = onlyOuterLeaves;
    }

    protected TreeDecoratorType<?> type() {
        return ModRegistry.CAVE_VINES.get();
    }

    public void place(TreeDecorator.Context context) {
        RandomSource random = context.random();
        context.leaves().forEach(blockPosLeave -> {
            if (random.nextFloat() < this.startProbability) {
                if (this.onlyOuterLeaves && !CaveVineDecorator.isOuterBlock(blockPosLeave, context)) {
                    return;
                }
                BlockPos pos = blockPosLeave.below();
                if (context.isAir(pos)) {
                    CaveVineDecorator.addCaveVines(pos, context, this.berrySpawnChance, this.maxVineLength);
                }
            }
        });
    }

    private static boolean isOuterBlock(BlockPos startPos, TreeDecorator.Context context) {
        ImmutableList neighbours = ImmutableList.of((Object)startPos.north(), (Object)startPos.east(), (Object)startPos.south(), (Object)startPos.west());
        for (BlockPos pos : neighbours) {
            if (!context.isAir(pos)) continue;
            return true;
        }
        return false;
    }

    private static void addCaveVines(BlockPos startPos, TreeDecorator.Context context, float berryChance, int maxVineLength) {
        RandomSource random = context.random();
        BlockPos blockpos = startPos;
        for (int i = maxVineLength; context.isAir(blockpos) && i > 0; --i) {
            BlockState state = Blocks.CAVE_VINES.defaultBlockState();
            if (random.nextFloat() < berryChance) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.BERRIES, (Comparable)Boolean.TRUE);
            }
            context.setBlock(blockpos, state);
            blockpos = blockpos.below();
        }
    }
}

