/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StoneBrickAgingProcessor
extends StructureProcessor {
    public static final MapCodec<StoneBrickAgingProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Chances.CODEC.fieldOf("chances").forGetter(processor -> processor.chances)).apply((Applicative)instance, StoneBrickAgingProcessor::new));
    private static final List<Block> STONE_BRICKS_REPLACEMENTS = List.of(Blocks.MOSSY_STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS);
    private static final Map<Block, Block> BRICKS = Map.of(Blocks.CHISELED_STONE_BRICKS, Blocks.CRACKED_STONE_BRICKS, Blocks.DEEPSLATE_BRICKS, Blocks.CRACKED_DEEPSLATE_BRICKS, Blocks.DEEPSLATE_TILES, Blocks.CRACKED_DEEPSLATE_TILES);
    private final Chances chances;

    public StoneBrickAgingProcessor(Chances chances) {
        this.chances = chances;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos var2, BlockPos var3, StructureTemplate.StructureBlockInfo var4, StructureTemplate.StructureBlockInfo var5, StructurePlaceSettings var6) {
        BlockState old = var5.state();
        BlockState replacement = null;
        RandomSource random = var6.getRandom(var5.pos());
        if (old.is(Blocks.STONE_BRICKS)) {
            Block block = (Block)Util.getRandom(STONE_BRICKS_REPLACEMENTS, (RandomSource)random);
            replacement = this.tryReplacing(block, old, random, this.chances.bricks());
        } else if (old.is(Blocks.STONE_BRICK_STAIRS)) {
            replacement = this.tryReplacing(Blocks.MOSSY_STONE_BRICK_STAIRS, old, random, this.chances.stairs());
        } else if (old.is(Blocks.STONE_BRICK_SLAB)) {
            replacement = this.tryReplacing(Blocks.MOSSY_STONE_BRICK_SLAB, old, random, this.chances.slabs());
        } else if (old.is(Blocks.STONE_BRICK_WALL)) {
            replacement = this.tryReplacing(Blocks.MOSSY_STONE_BRICK_WALL, old, random, this.chances.walls());
        } else if (BRICKS.containsKey(old.getBlock())) {
            Block temp = BRICKS.get(old.getBlock());
            replacement = this.tryReplacing(temp, old, random, this.chances.bricks());
        }
        if (replacement == null) {
            return var5;
        }
        return new StructureTemplate.StructureBlockInfo(var5.pos(), replacement, var5.nbt());
    }

    private BlockState tryReplacing(Block block, BlockState defaultState, RandomSource random, float chance) {
        if (random.nextFloat() < chance) {
            BlockState state = block.defaultBlockState();
            for (Property property : defaultState.getProperties()) {
                if (!state.hasProperty(property)) continue;
                state = StoneBrickAgingProcessor.copyProperty(defaultState, state, property);
            }
            return state;
        }
        return defaultState;
    }

    private static <T extends Comparable<T>> BlockState copyProperty(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.setValue(property, from.getValue(property));
    }

    protected StructureProcessorType<?> getType() {
        return ModRegistry.STONE_BRICK_AGING_PROCESSOR.get();
    }

    private record Chances(float bricks, float walls, float stairs, float slabs) {
        public static final Codec<Chances> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("bricks").orElse((Object)Float.valueOf(0.25f)).forGetter(Chances::bricks), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("walls").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::walls), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stairs").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::stairs), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("slabs").orElse((Object)Float.valueOf(0.15f)).forGetter(Chances::slabs)).apply((Applicative)instance, Chances::new));
    }
}

