/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worldgen.structures.JigsawStructure;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;

public final class UndergroundTempleStructure
extends JigsawStructure {
    public static final MapCodec<UndergroundTempleStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance), UndergroundTempleStructure.jigsawSettingsCodec(instance)).apply((Applicative)instance, UndergroundTempleStructure::new));

    public UndergroundTempleStructure(Structure.StructureSettings config, JigsawStructure.JigsawStructureSettings settings) {
        super(config, settings);
    }

    @Override
    protected BlockPos generateStartPos(Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        int highestY = context.chunkGenerator().getSeaLevel();
        if (highestY <= 30) {
            return null;
        }
        int lowestY = context.chunkGenerator().getMinY() + 15;
        int range = Math.abs((highestY -= 15) - lowestY);
        if (range < 10) {
            return null;
        }
        int y = lowestY + random.nextInt(range);
        return context.chunkPos().getMiddleBlockPosition(y);
    }

    @Override
    protected boolean isFeatureChunk(Structure.GenerationContext context) {
        return true;
    }

    public StructureType<?> type() {
        return ModRegistry.UNDERGROUND_TEMPLE.get();
    }
}

