/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tristankechlo.explorations.init.ModRegistry;
import com.tristankechlo.explorations.worldgen.structures.pieces.SlimeCaveStructurePiece;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public final class SlimeCaveStructure
extends Structure {
    public static final MapCodec<SlimeCaveStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(s -> s.biomes)).apply((Applicative)instance, SlimeCaveStructure::new));
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"explorations", (String)"slime_cave");
    private final HolderSet<Biome> biomes;

    public SlimeCaveStructure(HolderSet<Biome> biomes) {
        super(SlimeCaveStructure.makeSettings(biomes));
        this.biomes = biomes;
    }

    public static Structure.StructureSettings makeSettings(HolderSet<Biome> biomes) {
        return new Structure.StructureSettings(biomes, Map.of(), GenerationStep.Decoration.UNDERGROUND_STRUCTURES, TerrainAdjustment.BURY);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        WorldgenRandom random = context.random();
        int highestY = context.chunkGenerator().getSeaLevel();
        if (highestY <= 30) {
            return Optional.empty();
        }
        int lowestY = context.chunkGenerator().getMinY() + 15;
        int range = Math.abs((highestY -= 20) - lowestY);
        if (range < 10) {
            return Optional.empty();
        }
        int y = lowestY + random.nextInt(range);
        BlockPos pos = context.chunkPos().getWorldPosition().atY(y);
        return Optional.of(new Structure.GenerationStub(pos, builder -> this.generatePieces((StructurePiecesBuilder)builder, context, pos)));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos pos) {
        StructureTemplateManager templateManager = context.structureTemplateManager();
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        builder.addPiece((StructurePiece)new SlimeCaveStructurePiece(templateManager, ID, pos, rotation));
    }

    public StructureType<?> type() {
        return ModRegistry.SLIME_CAVE_STRUCTURE.get();
    }
}

