/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.explorations.worldgen.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public abstract class JigsawStructure
extends Structure {
    protected final JigsawStructureSettings settings;

    public JigsawStructure(Structure.StructureSettings config, JigsawStructureSettings settings) {
        super(config);
        this.settings = settings;
    }

    public static <S extends JigsawStructure> Codec<S> createCodec(BiFunction<Structure.StructureSettings, JigsawStructureSettings, S> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Structure.settingsCodec((RecordCodecBuilder.Instance)instance), JigsawStructure.jigsawSettingsCodec(instance)).apply((Applicative)instance, factory)).codec();
    }

    public static <S extends JigsawStructure> RecordCodecBuilder<S, JigsawStructureSettings> jigsawSettingsCodec(RecordCodecBuilder.Instance<S> instance) {
        return JigsawStructureSettings.CODEC.forGetter(s -> s.settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        if (!this.isFeatureChunk(context)) {
            return Optional.empty();
        }
        BlockPos blockpos = this.generateStartPos(context);
        if (blockpos == null) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.settings.startPool(), this.settings.startJigsawName(), (int)this.settings.size(), (BlockPos)blockpos, (boolean)false, Optional.empty(), (int)this.settings.maxDistanceFromCenter(), (PoolAliasLookup)PoolAliasLookup.create(List.of(), (BlockPos)blockpos, (long)context.seed()), (DimensionPadding)net.minecraft.world.level.levelgen.structure.structures.JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)net.minecraft.world.level.levelgen.structure.structures.JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    protected abstract BlockPos generateStartPos(Structure.GenerationContext var1);

    protected abstract boolean isFeatureChunk(Structure.GenerationContext var1);

    public record JigsawStructureSettings(Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, int maxDistanceFromCenter) {
        public static final MapCodec<JigsawStructureSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(JigsawStructureSettings::startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(JigsawStructureSettings::startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").orElse((Object)5).forGetter(JigsawStructureSettings::size), (App)Codec.intRange((int)0, (int)30).fieldOf("max_distance_from_center").orElse((Object)50).forGetter(JigsawStructureSettings::maxDistanceFromCenter)).apply((Applicative)instance, JigsawStructureSettings::new));
    }
}

